<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

/** @var \Comdev\Component\Onecore\Administrator\View\Reviews\HtmlView $this */
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('keepalive')->useScript('form.validate');
?>

<form action="<?php echo Route::_('index.php?option=com_onecore&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="review-form" class="form-validate">
	<div class="row">
		<div class="col-md-9">
			<?php echo $this->form->renderField('name'); ?>
			<?php echo $this->form->renderField('email'); ?>
			<?php echo $this->form->renderField('title'); ?>
			<?php echo $this->form->renderField('rating'); ?>
			<?php echo $this->form->renderField('body'); ?>
		</div>
		<div class="col-md-3">
			<div class="card">
				<div class="card-body">
					<?php echo $this->form->renderField('content_id'); ?>
					<?php echo $this->form->renderField('event_id'); ?>
					<?php echo $this->form->renderField('approved'); ?>
					<?php echo $this->form->renderField('published'); ?>
					<?php echo $this->form->renderField('created'); ?>
					<?php echo $this->form->renderField('created_by'); ?>
				</div>
			</div>
		</div>
	</div>
	<input type="hidden" name="task" value="">
	<?php echo HTMLHelper::_('form.token'); ?>
</form>
