<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

$listOrder = $this->escape(($this->state && $this->state->get('list.ordering')) ? $this->state->get('list.ordering') : 'a.created');
$listDirn  = $this->escape(($this->state && $this->state->get('list.direction')) ? $this->state->get('list.direction') : 'desc');
?>

<form action="<?php echo Route::_('index.php?option=com_onecore&view=reviews'); ?>" method="post" name="adminForm" id="adminForm">
	<div class="row">
		<div class="col-md-12">
			<div id="j-main-container" class="j-main-container">
				<?php if (!empty($this->filterForm) && $this->filterForm instanceof \Joomla\CMS\Form\Form) : ?>
					<?php echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>
				<?php endif; ?>
				<?php if (empty($this->items)) : ?>
					<div class="alert alert-info">
						<span class="icon-info-circle" aria-hidden="true"></span>
						<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
					</div>
				<?php else : ?>
					<table class="table" id="reviewsList">
						<thead>
							<tr>
								<td class="w-1 text-center">
									<?php echo HTMLHelper::_('grid.checkall'); ?>
								</td>
								<th scope="col" class="w-1 text-center d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-1 text-center d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_REVIEW_APPROVED', 'a.approved', $listDirn, $listOrder); ?>
								</th>
								<th scope="col">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_REVIEW_NAME', 'a.name', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_REVIEW_TITLE', 'a.title', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-2 text-center">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_REVIEW_RATING', 'a.rating', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="d-none d-lg-table-cell">
									<?php echo Text::_('COM_ONECORE_REVIEW_TYPE'); ?>
								</th>
								<th scope="col" class="w-10 d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_FIELD_CREATED_LABEL', 'a.created', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-3 d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($this->items as $i => $item) : ?>
								<?php
								$item->type_label = $item->content_id ? Text::_('COM_ONECORE_CONTENT') : Text::_('COM_ONECORE_EVENT');
								$item->ref_id = $item->content_id ?: $item->event_id;
								?>
								<tr class="row<?php echo $i % 2; ?>">
									<td class="text-center">
										<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
									</td>
									<td class="text-center d-none d-md-table-cell">
										<?php echo HTMLHelper::_('jgrid.published', $item->published ?? 0, $i, 'reviews.', true, 'cb'); ?>
									</td>
									<td class="text-center d-none d-md-table-cell">
										<?php echo $item->approved ? '<span class="badge bg-success">' . Text::_('JYES') . '</span>' : '<span class="badge bg-secondary">' . Text::_('JNO') . '</span>'; ?>
									</td>
									<th scope="row" class="has-context">
										<a href="<?php echo Route::_('index.php?option=com_onecore&task=reviews.edit&id=' . (int) $item->id); ?>">
											<?php echo $this->escape($item->name ?? ''); ?>
										</a>
										<?php if (!empty($item->email)) : ?>
											<div class="small text-muted"><?php echo $this->escape($item->email); ?></div>
										<?php endif; ?>
									</th>
									<td class="d-none d-md-table-cell">
										<?php echo $this->escape($item->title ?? '-'); ?>
									</td>
									<td class="text-center">
										<?php
										$rating = (int) ($item->rating ?? 0);
										echo $rating . ' ' . ($rating > 0 ? str_repeat('★', $rating) . str_repeat('☆', 5 - $rating) : '-');
										?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo $this->escape($item->type_label); ?> (ID: <?php echo (int) $item->ref_id; ?>)
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo $item->created ? HTMLHelper::_('date', $item->created, Text::_('DATE_FORMAT_LC3')) : '-'; ?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo (int) $item->id; ?>
									</td>
								</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
					<?php if ($this->pagination) : ?>
						<?php echo $this->pagination->getListFooter(); ?>
					<?php endif; ?>
				<?php endif; ?>
				<input type="hidden" name="task" value="">
				<input type="hidden" name="boxchecked" value="0">
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
	</div>
</form>
