<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Session\Session;

HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');

$isLicensePlus = isset($this->isLicensePlus) ? $this->isLicensePlus : false;
?>

<div class="onecore-import-export">
	<?php if (!$isLicensePlus) : ?>
		<div class="alert alert-warning">
			<h4 class="alert-heading"><?php echo Text::_('COM_ONECORE_IMPORT_EXPORT_PLUS_ONLY'); ?></h4>
			<p class="mb-0"><?php echo Text::_('COM_ONECORE_IMPORT_EXPORT_PLUS_ONLY_DESC'); ?></p>
		</div>
	<?php else : ?>
	<div class="row">
		<div class="col-lg-6">
			<div class="card">
				<div class="card-header">
					<h3><?php echo Text::_('COM_ONECORE_EXPORT'); ?></h3>
				</div>
				<div class="card-body">
					<p><?php echo Text::_('COM_ONECORE_EXPORT_DESC'); ?></p>
					
					<form action="<?php echo Route::_('index.php?option=com_onecore&task=importexport.export'); ?>" method="post" name="adminForm" id="adminForm" class="form-validate">
						<?php echo HTMLHelper::_('form.token'); ?>
						
						<div class="mb-3">
							<label for="export_type" class="form-label"><?php echo Text::_('COM_ONECORE_EXPORT_TYPE'); ?></label>
							<select name="type" id="export_type" class="form-select" required>
								<option value="content"><?php echo Text::_('COM_ONECORE_CONTENT'); ?></option>
								<option value="events"><?php echo Text::_('COM_ONECORE_EVENTS'); ?></option>
							</select>
						</div>
						
						<div class="mb-3">
							<button type="submit" class="btn btn-primary">
								<span class="icon-download" aria-hidden="true"></span>
								<?php echo Text::_('COM_ONECORE_EXPORT_BUTTON'); ?>
							</button>
						</div>
					</form>
					
					<div class="alert alert-info mt-3">
						<strong><?php echo Text::_('COM_ONECORE_EXPORT_INFO_TITLE'); ?></strong>
						<ul class="mb-0 mt-2">
							<li><?php echo Text::_('COM_ONECORE_EXPORT_INFO_1'); ?></li>
							<li><?php echo Text::_('COM_ONECORE_EXPORT_INFO_2'); ?></li>
							<li><?php echo Text::_('COM_ONECORE_EXPORT_INFO_3'); ?></li>
							<li><?php echo Text::_('COM_ONECORE_EXPORT_INFO_4'); ?></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
		
		<div class="col-lg-6">
			<div class="card">
				<div class="card-header">
					<h3><?php echo Text::_('COM_ONECORE_IMPORT'); ?></h3>
				</div>
				<div class="card-body">
					<p><?php echo Text::_('COM_ONECORE_IMPORT_DESC'); ?></p>
					
					<form action="<?php echo Route::_('index.php?option=com_onecore&task=importexport.import'); ?>" method="post" name="adminFormImport" id="adminFormImport" class="form-validate" enctype="multipart/form-data">
						<?php echo HTMLHelper::_('form.token'); ?>
						
						<div class="mb-3">
							<label for="import_type" class="form-label"><?php echo Text::_('COM_ONECORE_IMPORT_TYPE'); ?></label>
							<select name="type" id="import_type" class="form-select" required>
								<option value="content"><?php echo Text::_('COM_ONECORE_CONTENT'); ?></option>
								<option value="events"><?php echo Text::_('COM_ONECORE_EVENTS'); ?></option>
							</select>
						</div>
						
						<div class="mb-3">
							<label for="csv_file" class="form-label"><?php echo Text::_('COM_ONECORE_IMPORT_FILE'); ?></label>
							<input type="file" name="csv_file" id="csv_file" class="form-control" accept=".csv" required>
							<small class="form-text text-muted"><?php echo Text::_('COM_ONECORE_IMPORT_FILE_DESC'); ?></small>
						</div>
						
						<div class="mb-3">
							<button type="submit" class="btn btn-success">
								<span class="icon-upload" aria-hidden="true"></span>
								<?php echo Text::_('COM_ONECORE_IMPORT_BUTTON'); ?>
							</button>
						</div>
					</form>
					
					<div class="alert alert-warning mt-3">
						<strong><?php echo Text::_('COM_ONECORE_IMPORT_WARNING_TITLE'); ?></strong>
						<ul class="mb-0 mt-2">
							<li><?php echo Text::_('COM_ONECORE_IMPORT_WARNING_1'); ?></li>
							<li><?php echo Text::_('COM_ONECORE_IMPORT_WARNING_2'); ?></li>
							<li><?php echo Text::_('COM_ONECORE_IMPORT_WARNING_3'); ?></li>
							<li><?php echo Text::_('COM_ONECORE_IMPORT_WARNING_4'); ?></li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php endif; ?>
</div>
