<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Comdev\Component\Onecore\Administrator\Helper\LicenseHelper;

// Check license for Plus features
$isLicensePlus = LicenseHelper::getLicenseType() === 'plus';
$canAddPlusFeatures = LicenseHelper::canAddPlusFeatures();
$isLicenseExpired = LicenseHelper::isLicenseExpired();

// Check if this is existing event (editing) or new event
$eventId = 0;
$hasRecurrenceEnabled = false;
if (isset($this->item) && is_object($this->item)) {
	$eventId = (int) ($this->item->id ?? 0);
	$hasRecurrenceEnabled = (bool) ($this->item->recurrence_enabled ?? false);
} elseif ($this->form) {
	$eventId = (int) $this->form->getValue('id', null, 0);
	$hasRecurrenceEnabled = (bool) $this->form->getValue('recurrence_enabled', null, false);
}

// Check if existing event has recurrence in database
$hasExistingRecurrence = false;
if ($eventId > 0) {
	$db = \Joomla\CMS\Factory::getDbo();
	$query = $db->getQuery(true)
		->select('COUNT(*)')
		->from($db->quoteName('#__one_event_recurrences'))
		->where($db->quoteName('event_id') . ' = ' . $db->quote($eventId));
	$db->setQuery($query);
	$hasExistingRecurrence = (bool) $db->loadResult();
}

$isExistingEvent = ($eventId > 0);

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('keepalive')
    ->useScript('form.validate');

// Add inline script for automatic alias generation and date validation
$document = \Joomla\CMS\Factory::getApplication()->getDocument();
$document->addScriptDeclaration("
(function() {
    'use strict';
    
    document.addEventListener('DOMContentLoaded', function() {
        var titleField = document.getElementById('jform_title');
        var aliasField = document.getElementById('jform_alias');
        
        if (titleField && aliasField) {
            // Only auto-generate if alias is empty
            var shouldGenerate = !aliasField.value || aliasField.value === '';
            
            // Function to generate slug from title
            function generateSlug(text) {
                if (!text) return '';
                
                // Convert to lowercase
                var slug = text.toLowerCase();
                
                // Replace special characters with dashes
                slug = slug.replace(/[^a-z0-9\\u00C0-\\u017F]+/g, '-');
                
                // Remove leading and trailing dashes
                slug = slug.replace(/^-+|-+$/g, '');
                
                return slug;
            }
            
            titleField.addEventListener('blur', function() {
                if (shouldGenerate && titleField.value) {
                    aliasField.value = generateSlug(titleField.value);
                }
            });
            
            // Update shouldGenerate flag when user manually edits alias
            aliasField.addEventListener('input', function() {
                shouldGenerate = false;
            });
            
            aliasField.addEventListener('focus', function() {
                if (!aliasField.value || aliasField.value === '') {
                    shouldGenerate = true;
                }
            });
        }
        
        // Validate event_end >= event_start
        var eventStartField = document.getElementById('jform_event_start');
        var eventEndField = document.getElementById('jform_event_end');
        
        if (eventStartField && eventEndField) {
            function validateEventDates() {
                var startValue = eventStartField.value;
                var endValue = eventEndField.value;
                
                if (!startValue || !endValue) {
                    return true; // Allow empty end date
                }
                
                // Parse dates (format: YYYY-MM-DD HH:MM:SS or YYYY-MM-DD)
                var startDate = new Date(startValue.replace(/-/g, '/'));
                var endDate = new Date(endValue.replace(/-/g, '/'));
                
                if (isNaN(startDate.getTime()) || isNaN(endDate.getTime())) {
                    return true; // Invalid dates, skip validation
                }
                
                if (endDate < startDate) {
                    var errorMessage = " . json_encode(\Joomla\CMS\Language\Text::_('COM_ONECORE_EVENT_END_VALIDATION_ERROR'), JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE) . ";
                    eventEndField.setCustomValidity(errorMessage);
                    eventEndField.classList.add('invalid');
                    if (eventEndField.parentElement) {
                        var errorMsg = eventEndField.parentElement.querySelector('.event-end-error');
                        if (!errorMsg) {
                            errorMsg = document.createElement('div');
                            errorMsg.className = 'invalid-feedback event-end-error';
                            errorMsg.textContent = errorMessage;
                            eventEndField.parentElement.appendChild(errorMsg);
                        }
                        errorMsg.style.display = 'block';
                    }
                    return false;
                } else {
                    eventEndField.setCustomValidity('');
                    eventEndField.classList.remove('invalid');
                    var errorMsg = eventEndField.parentElement ? eventEndField.parentElement.querySelector('.event-end-error') : null;
                    if (errorMsg) {
                        errorMsg.style.display = 'none';
                    }
                    return true;
                }
            }
            
            // Validate on change of either field
            eventStartField.addEventListener('change', validateEventDates);
            eventStartField.addEventListener('blur', validateEventDates);
            eventEndField.addEventListener('change', validateEventDates);
            eventEndField.addEventListener('blur', validateEventDates);
            
            // Also validate on form submit
            var form = document.getElementById('event-form');
            if (form) {
                form.addEventListener('submit', function(e) {
                    if (!validateEventDates()) {
                        e.preventDefault();
                        e.stopPropagation();
                        eventEndField.focus();
                        return false;
                    }
                });
            }
        }
    });
})();
");

// Note: Location map JavaScript and Leaflet CSS/JS are now loaded via LayoutHelper::render('com_onecore.edit.location', $this)
?>

<?php if ($this->form && $this->form->getField('title')) : ?>
<form action="<?php echo Route::_('index.php?option=com_onecore&view=events&layout=edit&id=' . (int) ($this->item->id ?? 0)); ?>" method="post" name="adminForm" id="event-form" aria-label="<?php echo Text::_('COM_ONECORE_EVENT_' . ((int) ($this->item->id ?? 0) === 0 ? 'NEW' : 'EDIT'), true); ?>" class="form-validate">

	<?php echo LayoutHelper::render('joomla.edit.title_alias', $this); ?>

	<div class="main-card">
		<?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', ['active' => 'general', 'recall' => true, 'breakpoint' => 768]); ?>
		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'general', Text::_('COM_ONECORE_EVENT')); ?>
		<div class="row">
			<div class="col-lg-9">
				<div class="">
					<?php if ($this->form->getField('event_start')) : ?>
						<?php echo $this->form->renderField('event_start'); ?>
					<?php endif; ?>
					<?php if ($this->form->getField('event_end')) : ?>
						<?php echo $this->form->renderField('event_end'); ?>
					<?php endif; ?>
				</div>
				<?php if ($this->form->getField('description')) : ?>
					<div class="control-group mb-3">
					<?php echo $this->form->getLabel('description'); ?>
					<?php echo $this->form->getInput('description'); ?>
					</div>
				<?php endif; ?>
				<?php if ($this->form->getField('images')) : ?>
					<div class="control-group mb-3 mt-5">
						<div class="controls">
							<?php echo $this->form->renderField('images'); ?>
						</div>
					</div>
				<?php endif; ?>
			</div>
			<div class="col-lg-3">
				<?php 
				// Set fields to render in global section
				$this->fields = [
					['published', 'state', 'enabled'],
					'categories',
					'content',
					'access',
					'language',
					'note',
				];
				?>
				<?php echo LayoutHelper::render('joomla.edit.global', $this); ?>
				<?php $this->fields = null; ?>
			</div>
		</div>

		<?php echo HTMLHelper::_('uitab.endTab'); ?>

		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'location', Text::_('COM_ONECORE_LOCATION')); ?>
		<?php 
		// Use direct include for location layout
		$layoutPath = JPATH_ADMINISTRATOR . '/components/com_onecore/layouts/edit/location.php';
		if (file_exists($layoutPath)) {
			$displayData = $this;
			include $layoutPath;
		} else {
			echo '<div class="alert alert-danger">Layout file not found: ' . htmlspecialchars($layoutPath, ENT_QUOTES, 'UTF-8') . '</div>';
		}
		?>
		<?php echo HTMLHelper::_('uitab.endTab'); ?>

		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'recurrence', Text::_('COM_ONECORE_RECURRENCE')); ?>
		<div class="row">
			<div class="col-lg-12">
				<?php if (!$isLicensePlus) : ?>
					<div class="alert alert-warning">
						<span class="icon-warning" aria-hidden="true"></span>
						<?php echo Text::_('COM_ONECORE_RECURRENCE_PLUS_ONLY'); ?>
					</div>
				<?php elseif ($isLicenseExpired && (!$isExistingEvent || !$hasExistingRecurrence)) : ?>
					<div class="alert alert-warning">
						<span class="icon-warning" aria-hidden="true"></span>
						<?php echo Text::_('COM_ONECORE_LICENSE_EXPIRED_CANNOT_ADD_PLUS_FEATURES'); ?>
					</div>
				<?php endif; ?>
				<?php if ($this->form->getFieldset('recurrence')) : ?>
					<?php 
					// Disable recurrence form: free version always; Plus expired = can't add new recurrence
					$recurrenceFormDisabled = !$isLicensePlus
						|| ($isLicenseExpired && (!$isExistingEvent || !$hasExistingRecurrence));
					if ($recurrenceFormDisabled) {
						$recurrenceFieldNames = [
							'recurrence_enabled', 'recurrence_frequency', 'recurrence_interval',
							'recurrence_byday', 'recurrence_until_date', 'recurrence_count', 'recurrence_exceptions',
						];
						foreach ($recurrenceFieldNames as $name) {
							// Note: 4th argument is the *field group* (<fields name="...">), not the fieldset name.
							// Our events form has no <fields name="..."> wrapper, so group must be omitted.
							$this->form->setFieldAttribute($name, 'disabled', 'true');
						}
					}
					?>
					<?php echo $this->form->renderFieldset('recurrence'); ?>
				<?php endif; ?>
			</div>
		</div>
		<?php echo HTMLHelper::_('uitab.endTab'); ?>

		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'customfields', Text::_('COM_ONECORE_CUSTOMFIELDS_TAB')); ?>
		<div class="row">
			<div class="col-lg-12">
				<?php
				$allFields = $this->customfieldsAll ?? $this->customfields ?? [];
				?>
				<?php if (empty($allFields)) : ?>
					<div class="alert alert-info">
						<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
					</div>
				<?php else : ?>
					<?php foreach ($allFields as $field) : ?>
						<?php
						$fieldId = (int) ($field->id ?? 0);
						$fieldCategoryId = (int) ($field->category_id ?? 0);
						$fieldType = (string) ($field->type ?? 'input');
						$isRequired = !empty($field->required);
						$value = $this->customfieldValues[$fieldId] ?? '';
						$height = (int) ($field->height ?? 0);
						$options = !empty($field->options) ? $field->options : '';
						
						// Parse options for select/multiselect/radio field (one per line)
						$selectOptions = [];
						if (($fieldType === 'select' || $fieldType === 'multiselect' || $fieldType === 'radio') && !empty($options)) {
							$lines = explode("\n", $options);
							foreach ($lines as $line) {
								$line = trim($line);
								if (!empty($line)) {
									// Support format: value|Label or just value
									if (strpos($line, '|') !== false) {
										list($optValue, $optLabel) = explode('|', $line, 2);
										$selectOptions[trim($optValue)] = trim($optLabel);
									} else {
										$selectOptions[$line] = $line;
									}
								}
							}
						}
						
						// For multiselect, value should be an array
						if ($fieldType === 'multiselect') {
							if (is_string($value) && !empty($value)) {
								// If value is a string, try to parse it (comma-separated or JSON)
								if (strpos($value, ',') !== false) {
									$value = array_map('trim', explode(',', $value));
								} elseif (strpos($value, '[') === 0) {
									$decoded = json_decode($value, true);
									$value = is_array($decoded) ? $decoded : [$value];
								} else {
									$value = [$value];
								}
							} elseif (!is_array($value)) {
								$value = [];
							}
						}
						?>
						<div class="control-group mb-3 onecore-cf" data-field-id="<?php echo $fieldId; ?>" data-category-id="<?php echo $fieldCategoryId; ?>">
							<div class="control-label">
								<label for="jform_customfields_<?php echo $fieldId; ?>" class="<?php echo $isRequired ? 'required' : ''; ?>">
									<?php echo $this->escape($field->title ?? ''); ?>
									<?php if ($isRequired) : ?>
										<span class="star">&nbsp;*</span>
									<?php endif; ?>
								</label>
							</div>
							<div class="controls">
								<?php if ($fieldType === 'textarea') : ?>
									<textarea
										class="form-control"
										name="jform[customfields][<?php echo $fieldId; ?>]"
										id="jform_customfields_<?php echo $fieldId; ?>"
										data-required="<?php echo $isRequired ? '1' : '0'; ?>"
										style="<?php echo $height > 0 ? 'height:' . (int) $height . 'px;' : ''; ?>"
									><?php echo htmlspecialchars((string) $value, ENT_QUOTES, 'UTF-8'); ?></textarea>
								<?php elseif ($fieldType === 'radio' && !empty($selectOptions)) : ?>
									<div class="btn-group btn-group-toggle" data-toggle="buttons" role="radiogroup" aria-label="<?php echo htmlspecialchars($field->title ?? '', ENT_QUOTES, 'UTF-8'); ?>">
										<?php if (!$isRequired) : ?>
											<input type="radio" 
												class="btn-check" 
												name="jform[customfields][<?php echo $fieldId; ?>]" 
												id="jform_customfields_<?php echo $fieldId; ?>_none" 
												value="" 
												<?php echo (empty($value)) ? 'checked="checked"' : ''; ?>
												data-required="<?php echo $isRequired ? '1' : '0'; ?>"
											/>
											<label class="btn btn-outline-secondary" for="jform_customfields_<?php echo $fieldId; ?>_none">
												<?php echo \Joomla\CMS\Language\Text::_('JNONE'); ?>
											</label>
										<?php endif; ?>
										<?php foreach ($selectOptions as $optValue => $optLabel) : ?>
											<input type="radio" 
												class="btn-check" 
												name="jform[customfields][<?php echo $fieldId; ?>]" 
												id="jform_customfields_<?php echo $fieldId; ?>_<?php echo htmlspecialchars($optValue, ENT_QUOTES, 'UTF-8'); ?>" 
												value="<?php echo htmlspecialchars($optValue, ENT_QUOTES, 'UTF-8'); ?>" 
												<?php echo ($value === $optValue) ? 'checked="checked"' : ''; ?>
												data-required="<?php echo $isRequired ? '1' : '0'; ?>"
											/>
											<label class="btn btn-outline-primary" for="jform_customfields_<?php echo $fieldId; ?>_<?php echo htmlspecialchars($optValue, ENT_QUOTES, 'UTF-8'); ?>">
												<?php echo htmlspecialchars($optLabel, ENT_QUOTES, 'UTF-8'); ?>
											</label>
										<?php endforeach; ?>
									</div>
								<?php elseif ($fieldType === 'select' && !empty($selectOptions)) : ?>
									<select
										class="form-select"
										name="jform[customfields][<?php echo $fieldId; ?>]"
										id="jform_customfields_<?php echo $fieldId; ?>"
										data-required="<?php echo $isRequired ? '1' : '0'; ?>"
									>
										<?php if (!$isRequired) : ?>
											<option value=""><?php echo \Joomla\CMS\Language\Text::_('JSELECT'); ?></option>
										<?php endif; ?>
										<?php foreach ($selectOptions as $optValue => $optLabel) : ?>
											<option value="<?php echo htmlspecialchars($optValue, ENT_QUOTES, 'UTF-8'); ?>" 
												<?php echo ($value === $optValue) ? 'selected="selected"' : ''; ?>>
												<?php echo htmlspecialchars($optLabel, ENT_QUOTES, 'UTF-8'); ?>
											</option>
										<?php endforeach; ?>
									</select>
								<?php elseif ($fieldType === 'multiselect' && !empty($selectOptions)) : ?>
									<select
										class="form-select"
										name="jform[customfields][<?php echo $fieldId; ?>][]"
										id="jform_customfields_<?php echo $fieldId; ?>"
										data-required="<?php echo $isRequired ? '1' : '0'; ?>"
										multiple="multiple"
										size="<?php echo min(5, max(2, count($selectOptions))); ?>"
									>
										<?php foreach ($selectOptions as $optValue => $optLabel) : ?>
											<option value="<?php echo htmlspecialchars($optValue, ENT_QUOTES, 'UTF-8'); ?>" 
												<?php echo (is_array($value) && in_array($optValue, $value)) ? 'selected="selected"' : ''; ?>>
												<?php echo htmlspecialchars($optLabel, ENT_QUOTES, 'UTF-8'); ?>
											</option>
										<?php endforeach; ?>
									</select>
								<?php else : ?>
									<input
										type="text"
										class="form-control"
										name="jform[customfields][<?php echo $fieldId; ?>]"
										id="jform_customfields_<?php echo $fieldId; ?>"
										value="<?php echo htmlspecialchars((string) $value, ENT_QUOTES, 'UTF-8'); ?>"
										data-required="<?php echo $isRequired ? '1' : '0'; ?>"
									/>
								<?php endif; ?>
							</div>
						</div>
					<?php endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
		<?php
		$categoriesTree = $this->categoriesTree ?? [];
		$rootCategoryIds = $this->rootCategoryIds ?? [];
		?>
		<script>
		(function() {
			'use strict';
			const catTree = <?php echo json_encode($categoriesTree, JSON_UNESCAPED_SLASHES); ?>;
			const rootCategoryIds = <?php echo json_encode(array_map('intval', $rootCategoryIds), JSON_UNESCAPED_SLASHES); ?>;

			function getSelectedCategoryIds() {
				const sel = document.getElementById('jform_categories');
				if (!sel) return [];
				return Array.from(sel.selectedOptions || []).map(o => parseInt(o.value, 10)).filter(v => v > 0);
			}

			function isAncestorOrSame(fieldCatId, contentCatId) {
				if (!fieldCatId || !contentCatId) return false;
				const f = catTree[fieldCatId];
				const c = catTree[contentCatId];
				if (!f || !c) return false;
				return (f.lft <= c.lft) && (f.rgt >= c.rgt);
			}

			function isRootCategory(categoryId) {
				return rootCategoryIds.indexOf(parseInt(categoryId, 10)) !== -1;
			}

			function updateCustomFieldsVisibility() {
				const selected = getSelectedCategoryIds();
				const fields = document.querySelectorAll('.onecore-cf');
				fields.forEach(function(wrapper) {
					const fieldCatId = parseInt(wrapper.getAttribute('data-category-id') || '0', 10);
					let visible = false;
					
					// Always show fields assigned to ROOT category
					if (isRootCategory(fieldCatId)) {
						visible = true;
					} else {
						// Check if field category is ancestor of selected category
						for (const cid of selected) {
							if (isAncestorOrSame(fieldCatId, cid)) {
								visible = true;
								break;
							}
						}
					}
					
					wrapper.style.display = visible ? '' : 'none';

					// required only when visible
					const input = wrapper.querySelector('input, textarea, select');
					if (input) {
						const req = (input.getAttribute('data-required') || '0') === '1';
						input.required = visible && req;
					}
				});
			}

			document.addEventListener('DOMContentLoaded', function() {
				updateCustomFieldsVisibility();
				const sel = document.getElementById('jform_categories');
				if (sel) sel.addEventListener('change', updateCustomFieldsVisibility);
			});
		})();
		</script>
		<?php echo HTMLHelper::_('uitab.endTab'); ?>

		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'publishing', Text::_('JGLOBAL_FIELDSET_PUBLISHING')); ?>
		<div class="row">
			<div class="col-12 col-lg-6">
				<?php echo $this->form->renderFieldset('publishing'); ?>
			</div>
		</div>
		<?php echo HTMLHelper::_('uitab.endTab'); ?>

		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'metadata', Text::_('JGLOBAL_FIELDSET_METADATA_OPTIONS')); ?>
		<div class="row">
			<div class="col-12 col-lg-6">
				<?php echo $this->form->renderFieldset('metadata'); ?>
			</div>
		</div>
		<?php echo HTMLHelper::_('uitab.endTab'); ?>

		<?php 
		// Render params tab but exclude 'location' and 'recurrence' fieldsets (they have their own tabs)
		$this->ignore_fieldsets = ['location', 'recurrence', 'publishing', 'metadata'];
		echo LayoutHelper::render('joomla.edit.params', $this);
		$this->ignore_fieldsets = null;
		?>

		<?php echo HTMLHelper::_('uitab.endTabSet'); ?>

		<?php echo $this->form->renderControlFields(); ?>
		<input type="hidden" name="task" value="">
	</div>
</form>
<?php else : ?>
	<div class="alert alert-danger">
		<?php if (!$this->form) : ?>
			<?php echo Text::_('COM_ONECORE_ERROR_FORM_NOT_LOADED'); ?>
		<?php else : ?>
			<?php echo Text::_('COM_ONECORE_ERROR_FORM_FIELDS_NOT_LOADED'); ?>
			<?php if ($this->form->getField('title')) : ?>
				<p>Form has title field</p>
			<?php else : ?>
				<p>Form does NOT have title field. Form XML may not be loaded correctly.</p>
				<p>Form fields: <?php var_dump($this->form->getFieldsets()); ?></p>
			<?php endif; ?>
		<?php endif; ?>
	</div>
<?php endif; ?>
