<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

/** @var \Comdev\Component\Onecore\Administrator\View\Emailtemplates\HtmlView $this */
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('keepalive')->useScript('form.validate');
?>

<form action="<?php echo Route::_('index.php?option=com_onecore&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="emailtemplate-form" class="form-validate">
	<div class="row">
		<div class="col-md-9">
			<?php echo $this->form->renderField('title'); ?>
			<?php echo $this->form->renderField('email_title'); ?>
			<?php echo $this->form->renderField('email_content'); ?>
			
			<div class="card mt-3">
				<div class="card-header">
					<h4><?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VARIABLES'); ?></h4>
				</div>
				<div class="card-body">
					<p><?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VARIABLES_INFO_DESC'); ?></p>
					<div class="row">
						<div class="col-md-6">
							<ul class="list-unstyled">
								<li><code>{user}</code> - <?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VAR_USER'); ?></li>
								<li><code>{user_email}</code> - <?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VAR_USER_EMAIL'); ?></li>
								<li><code>{listing_title}</code> - <?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VAR_LISTING_TITLE'); ?></li>
								<li><code>{event_title}</code> - <?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VAR_EVENT_TITLE'); ?></li>
							</ul>
						</div>
						<div class="col-md-6">
							<ul class="list-unstyled">
								<li><code>{review_title}</code> - <?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VAR_REVIEW_TITLE'); ?></li>
								<li><code>{review_body}</code> - <?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VAR_REVIEW_BODY'); ?></li>
								<li><code>{site_name}</code> - <?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VAR_SITE_NAME'); ?></li>
								<li><code>{site_url}</code> - <?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_VAR_SITE_URL'); ?></li>
							</ul>
						</div>
					</div>
					<button type="button" class="btn btn-primary" id="preview-btn">
						<span class="icon-eye" aria-hidden="true"></span>
						<?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_PREVIEW'); ?>
					</button>
				</div>
			</div>
		</div>
		<div class="col-md-3">
			<div class="card">
				<div class="card-body">
					<?php echo $this->form->renderField('entity'); ?>
					<?php echo $this->form->renderField('language'); ?>
					<?php echo $this->form->renderField('published'); ?>
					<hr>
					<h5><?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_SETTINGS'); ?></h5>
					<?php echo $this->form->renderField('send_to_user'); ?>
					<?php echo $this->form->renderField('send_cc_to_admin'); ?>
					<hr>
					<?php echo $this->form->renderField('created'); ?>
					<?php echo $this->form->renderField('created_by'); ?>
					<?php echo $this->form->renderField('modified'); ?>
					<?php echo $this->form->renderField('modified_by'); ?>
					<?php echo $this->form->renderField('note'); ?>
				</div>
			</div>
		</div>
	</div>
	<input type="hidden" name="task" value="">
	<?php echo HTMLHelper::_('form.token'); ?>
</form>

<!-- Preview Modal -->
<div class="modal fade" id="emailPreviewModal" tabindex="-1" aria-labelledby="emailPreviewModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="emailPreviewModalLabel"><?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_PREVIEW'); ?></h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo Text::_('JCLOSE'); ?>"></button>
			</div>
			<div class="modal-body">
				<div class="mb-3">
					<strong><?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_EMAIL_TITLE'); ?>:</strong>
					<div id="preview-title" class="mt-1 p-2 bg-light border rounded"></div>
				</div>
				<div>
					<strong><?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_EMAIL_CONTENT'); ?>:</strong>
					<div id="preview-content" class="mt-2 border p-3 bg-light rounded"></div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo Text::_('JCLOSE'); ?></button>
			</div>
		</div>
	</div>
</div>
