<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

// Load Bootstrap modal script
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('bootstrap.modal');

$listOrder = $this->escape(($this->state && $this->state->get('list.ordering')) ? $this->state->get('list.ordering') : 'a.created');
$listDirn  = $this->escape(($this->state && $this->state->get('list.direction')) ? $this->state->get('list.direction') : 'desc');
?>

<form action="<?php echo Route::_('index.php?option=com_onecore&view=emailtemplates'); ?>" method="post" name="adminForm" id="adminForm">
	<div class="row">
		<div class="col-md-12">
			<div id="j-main-container" class="j-main-container">
				<?php if (!empty($this->filterForm) && $this->filterForm instanceof \Joomla\CMS\Form\Form) : ?>
					<?php echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>
				<?php endif; ?>
				<?php if (empty($this->items)) : ?>
					<div class="alert alert-info">
						<span class="icon-info-circle" aria-hidden="true"></span>
						<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
					</div>
				<?php else : ?>
					<table class="table" id="emailTemplatesList">
						<thead>
							<tr>
								<td class="w-1 text-center">
									<?php echo HTMLHelper::_('grid.checkall'); ?>
								</td>
								<th scope="col" class="w-1 text-center d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
								</th>
								<th scope="col">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_EMAIL_TEMPLATE_TITLE', 'a.title', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_EMAIL_TEMPLATE_EMAIL_TITLE', 'a.email_title', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_EMAIL_TEMPLATE_ENTITY', 'a.entity', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JFIELD_LANGUAGE_LABEL', 'a.language', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-10 d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_FIELD_CREATED_LABEL', 'a.created', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-3 d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($this->items as $i => $item) : ?>
								<tr class="row<?php echo $i % 2; ?>">
									<td class="text-center">
										<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
									</td>
									<td class="text-center d-none d-md-table-cell">
										<?php echo HTMLHelper::_('jgrid.published', $item->published ?? 0, $i, 'emailtemplates.', true, 'cb'); ?>
									</td>
									<th scope="row" class="has-context">
										<a href="<?php echo Route::_('index.php?option=com_onecore&task=emailtemplates.edit&id=' . (int) $item->id); ?>">
											<?php echo $this->escape($item->title ?? ''); ?>
										</a>
										<div class="small">
											<a href="#" class="text-muted preview-link" data-id="<?php echo (int) $item->id; ?>" data-bs-toggle="modal" data-bs-target="#emailPreviewModal">
												<?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_PREVIEW'); ?>
											</a>
										</div>
									</th>
									<td class="d-none d-md-table-cell">
										<?php echo $this->escape($item->email_title ?? '-'); ?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php
										if ($item->entity === 'contents') {
											echo Text::_('COM_ONECORE_CONTENT');
										} elseif ($item->entity === 'events') {
											echo Text::_('COM_ONECORE_EVENTS');
										} else {
											echo '-';
										}
										?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo $item->language === '*' ? Text::_('JALL') : $this->escape($item->language); ?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo $item->created ? HTMLHelper::_('date', $item->created, Text::_('DATE_FORMAT_LC3')) : '-'; ?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo (int) $item->id; ?>
									</td>
								</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
					<?php if ($this->pagination) : ?>
						<?php echo $this->pagination->getListFooter(); ?>
					<?php endif; ?>
				<?php endif; ?>
				<input type="hidden" name="task" value="">
				<input type="hidden" name="boxchecked" value="0">
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
	</div>
</form>

<!-- Preview Modal -->
<div class="modal fade" id="emailPreviewModal" tabindex="-1" aria-labelledby="emailPreviewModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="emailPreviewModalLabel"><?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_PREVIEW'); ?></h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?php echo Text::_('JCLOSE'); ?>"></button>
			</div>
			<div class="modal-body">
				<div class="mb-3">
					<strong><?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_EMAIL_TITLE'); ?>:</strong>
					<div id="preview-title" class="mt-1"></div>
				</div>
				<div>
					<strong><?php echo Text::_('COM_ONECORE_EMAIL_TEMPLATE_EMAIL_CONTENT'); ?>:</strong>
					<div id="preview-content" class="mt-2 border p-3"></div>
				</div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal" onclick="closeEmailPreviewModal()"><?php echo Text::_('JCLOSE'); ?></button>
			</div>
		</div>
	</div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
	var previewLinks = document.querySelectorAll('.preview-link');
	var modalElement = document.getElementById('emailPreviewModal');
	
	// Initialize modal when it's shown
	if (modalElement) {
		modalElement.addEventListener('show.bs.modal', function(event) {
			// Get the link that triggered the modal
			var triggerLink = event.relatedTarget;
			if (!triggerLink || !triggerLink.classList.contains('preview-link')) {
				return;
			}
			
			var id = triggerLink.getAttribute('data-id');
			if (!id) {
				event.preventDefault();
				alert('Error: Template ID not found');
				return;
			}
			
			// Show loading state
			document.getElementById('preview-title').textContent = 'Loading...';
			document.getElementById('preview-content').innerHTML = '<div class="text-center"><span class="spinner-border" role="status"></span></div>';
			
			var formData = new FormData();
			formData.append('option', 'com_onecore');
			formData.append('task', 'emailtemplates.preview');
			formData.append('id', id);
			formData.append('format', 'json');
			formData.append('<?php echo \Joomla\CMS\Session\Session::getFormToken(); ?>', '1');
			
			var url = '<?php echo Route::_("index.php?option=com_onecore&task=emailtemplates.preview&format=json", false); ?>';
			
			fetch(url, {
				method: 'POST',
				body: formData,
				headers: {
					'X-Requested-With': 'XMLHttpRequest'
				}
			})
			.then(response => {
				if (!response.ok) {
					throw new Error('HTTP error! status: ' + response.status);
				}
				return response.json();
			})
			.then(data => {
				if (data.success) {
					document.getElementById('preview-title').textContent = data.title || '';
					document.getElementById('preview-content').innerHTML = data.content || '';
				} else {
					document.getElementById('preview-title').textContent = 'Error';
					document.getElementById('preview-content').innerHTML = '<div class="alert alert-danger">' + (data.message || 'Unknown error') + '</div>';
				}
			})
			.catch(error => {
				console.error('Error:', error);
				document.getElementById('preview-title').textContent = 'Error';
				document.getElementById('preview-content').innerHTML = '<div class="alert alert-danger">Error loading preview: ' + error.message + '</div>';
			});
		});
	}
	
	// Handle click on preview links
	previewLinks.forEach(function(link) {
		link.addEventListener('click', function(e) {
			// Let Bootstrap handle the modal opening via data-bs-toggle
			// The show.bs.modal event will handle loading the preview data
		});
	});
});
</script>
