<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

$listOrder = $this->escape(($this->state && $this->state->get('list.ordering')) ? $this->state->get('list.ordering') : 'a.created');
$listDirn  = $this->escape(($this->state && $this->state->get('list.direction')) ? $this->state->get('list.direction') : 'desc');
?>

<form action="<?php echo Route::_('index.php?option=com_onecore&view=emaillogs'); ?>" method="post" name="adminForm" id="adminForm">
	<div class="row">
		<div class="col-md-12">
			<div id="j-main-container" class="j-main-container">
				<?php if (!empty($this->filterForm) && $this->filterForm instanceof \Joomla\CMS\Form\Form) : ?>
					<?php echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>
				<?php endif; ?>
				<?php if (empty($this->items)) : ?>
					<div class="alert alert-info">
						<span class="icon-info-circle" aria-hidden="true"></span>
						<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
					</div>
				<?php else : ?>
					<table class="table" id="emailLogsList">
						<thead>
							<tr>
								<th scope="col" class="w-1 text-center">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
								</th>
								<th scope="col">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_EMAIL_LOG_TEMPLATE', 'template_title', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_EMAIL_LOG_RECIPIENT', 'a.recipient_name', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_EMAIL_LOG_RECIPIENT_EMAIL', 'a.recipient_email', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_EMAIL_LOG_SUBJECT', 'a.subject', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-10 text-center">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_EMAIL_LOG_STATUS', 'a.status', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-10 d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_EMAIL_LOG_SENT_AT', 'a.sent_at', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-10 d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_FIELD_CREATED_LABEL', 'a.created', $listDirn, $listOrder); ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($this->items as $i => $item) : ?>
								<tr class="row<?php echo $i % 2; ?>">
									<td class="text-center">
										<?php echo (int) $item->id; ?>
									</td>
									<th scope="row" class="has-context">
										<?php echo $this->escape($item->template_title ?? Text::_('COM_ONECORE_EMAIL_LOG_TEMPLATE_DELETED')); ?>
									</th>
									<td class="d-none d-md-table-cell">
										<?php echo $this->escape($item->recipient_name ?? '-'); ?>
									</td>
									<td class="d-none d-md-table-cell">
										<?php echo $this->escape($item->recipient_email ?? '-'); ?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo $this->escape($item->subject ?? '-'); ?>
									</td>
									<td class="text-center">
										<?php
										$statusClass = '';
										$statusText = '';
										switch ($item->status) {
											case 'sent':
												$statusClass = 'success';
												$statusText = Text::_('COM_ONECORE_EMAIL_LOG_STATUS_SENT');
												break;
											case 'failed':
												$statusClass = 'danger';
												$statusText = Text::_('COM_ONECORE_EMAIL_LOG_STATUS_FAILED');
												break;
											case 'pending':
												$statusClass = 'warning';
												$statusText = Text::_('COM_ONECORE_EMAIL_LOG_STATUS_PENDING');
												break;
											default:
												$statusText = $this->escape($item->status ?? '-');
										}
										?>
										<span class="badge bg-<?php echo $statusClass; ?>">
											<?php echo $statusText; ?>
										</span>
										<?php if ($item->status === 'failed' && !empty($item->error_message)) : ?>
											<div class="small text-muted mt-1" title="<?php echo $this->escape($item->error_message); ?>">
												<?php echo Text::_('COM_ONECORE_EMAIL_LOG_ERROR'); ?>
											</div>
										<?php endif; ?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo $item->sent_at && $item->sent_at !== '0000-00-00 00:00:00' 
											? HTMLHelper::_('date', $item->sent_at, Text::_('DATE_FORMAT_LC4')) 
											: '-'; ?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo HTMLHelper::_('date', $item->created, Text::_('DATE_FORMAT_LC4')); ?>
									</td>
								</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
					<?php echo $this->pagination->getListFooter(); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<input type="hidden" name="task" value="">
	<input type="hidden" name="boxchecked" value="0">
	<?php echo HTMLHelper::_('form.token'); ?>
</form>
