<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('table.columns')
    ->useScript('multiselect')
    ->useScript('joomla.dialog-autocreate');

$listOrder = $this->escape(($this->state && $this->state->get('list.ordering')) ? $this->state->get('list.ordering') : 'a.title');
$listDirn  = $this->escape(($this->state && $this->state->get('list.direction')) ? $this->state->get('list.direction') : 'asc');
?>

<form action="<?php echo Route::_('index.php?option=com_onecore&view=content'); ?>" method="post" name="adminForm" id="adminForm">
	<div class="row">
		<div class="col-md-12">
			<div id="j-main-container" class="j-main-container">
				<?php echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>
				<?php if (empty($this->items)) : ?>
					<div class="alert alert-info">
						<span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
						<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
					</div>
				<?php else : ?>
					<table class="table" id="contentList">
						<thead>
							<tr>
								<td class="w-1 text-center">
									<?php echo HTMLHelper::_('grid.checkall'); ?>
								</td>
							<th scope="col" class="w-1 text-center d-none d-md-table-cell">
								<?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
							</th>
							<th scope="col" class="w-1 text-center d-none d-md-table-cell">
								<?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_FEATURED', 'a.featured', $listDirn, $listOrder); ?>
							</th>
							<th scope="col" class="w-3 text-center">
								<?php echo Text::_('COM_ONECORE_IMAGE'); ?>
							</th>
								<th scope="col">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-15 d-none d-md-table-cell">
									<?php echo Text::_('JCATEGORY'); ?>
								</th>
								<th scope="col" class="w-15 d-none d-md-table-cell">
									<?php echo Text::_('COM_ONECORE_CUSTOMFIELDGROUPS'); ?>
								</th>
								<th scope="col" class="w-10 d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ORDERING', 'a.ordering', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-3 d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($this->items as $i => $item) : ?>
								<tr class="row<?php echo $i % 2; ?>">
									<td class="text-center">
										<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
									</td>
							<td class="text-center d-none d-md-table-cell">
								<?php echo HTMLHelper::_('jgrid.published', $item->published ?? 0, $i, 'content.', true, 'cb'); ?>
							</td>
							<td class="text-center d-none d-md-table-cell">
								<?php 
								$canChange = true; // You can add permission check here if needed
								echo HTMLHelper::_('onecoreadministrator.featured', $item->featured ?? 0, $i, $canChange); 
								?>
							</td>
							<td class="text-center">
									<?php if (!empty($item->thumbnail)) : ?>
										<?php
										$imagePath = trim($item->thumbnail);

										// Normalize path - handle both absolute and relative paths
										// If path starts with http:// or https://, use as is
										if (strpos($imagePath, 'http://') === 0 || strpos($imagePath, 'https://') === 0) {
											$imageUrl = $imagePath;
											$fullPath = null; // Can't check file existence for external URLs
										} else {
											// Remove leading slash if present for relative paths
											$imagePath = ltrim($imagePath, '/');

											// Build full path for file existence check
											$fullPath = JPATH_ROOT . '/' . $imagePath;

											// Build URL - ensure it starts with /
											$imageUrl = \Joomla\CMS\Uri\Uri::root() . $imagePath;
										}

										// Always try to display the image, even if file check fails
										// (file_exists might fail due to permissions, but image might still be accessible via URL)
										$popupOptions = [
											'popupType' => 'image',
											'src' => $imageUrl,
											'textHeader' => $this->escape($item->title ?? ''),
										];
										?>
											<a href="<?php echo htmlspecialchars($imageUrl, ENT_QUOTES, 'UTF-8'); ?>" 
												title="<?php echo $this->escape($item->title ?? ''); ?>"
												data-joomla-dialog="<?php echo htmlspecialchars(json_encode($popupOptions, JSON_UNESCAPED_SLASHES), ENT_QUOTES, 'UTF-8'); ?>">
												<img src="<?php echo htmlspecialchars($imageUrl, ENT_QUOTES, 'UTF-8'); ?>"
													alt="<?php echo $this->escape($item->title ?? ''); ?>"
													class="img-thumbnail"
													style="width: 90px; max-width: 90px; object-fit: cover; cursor: pointer; height: auto;"
													onerror="this.style.display='none'; this.nextElementSibling.style.display='inline';">
												<span class="icon-image" aria-hidden="true" style="font-size: 24px; color: #ccc; display: none;" title="<?php echo Text::_('COM_ONECORE_IMAGE_NOT_FOUND'); ?>"></span>
											</a>
									<?php else : ?>
										<span class="icon-image" aria-hidden="true" style="font-size: 24px; color: #ccc;" title="<?php echo Text::_('COM_ONECORE_NO_IMAGE'); ?>"></span>
									<?php endif; ?>
								</td>
								<th scope="row" class="has-context">
									<a href="<?php echo Route::_('index.php?option=com_onecore&task=content.edit&id=' . $item->id); ?>">
										<?php echo $this->escape($item->title ?? ''); ?>
									</a>
								</th>
								<td class="d-none d-md-table-cell">
									<?php if (!empty($item->categories)) : ?>
										<?php echo $this->escape($item->categories); ?>
									<?php else : ?>
										<span class="text-muted"><?php echo Text::_('JNONE'); ?></span>
									<?php endif; ?>
								</td>
								<td class="d-none d-md-table-cell">
									<?php if (!empty($item->customfield_groups)) : ?>
										<?php echo $this->escape($item->customfield_groups); ?>
									<?php else : ?>
										<span class="text-muted"><?php echo Text::_('JNONE'); ?></span>
									<?php endif; ?>
								</td>
								<td class="d-none d-md-table-cell">
									<?php echo $item->ordering ?? 0; ?>
								</td>
									<td class="d-none d-lg-table-cell">
										<?php echo (int) ($item->id ?? 0); ?>
									</td>
								</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
					<?php if ($this->pagination) : ?>
						<?php echo $this->pagination->getListFooter(); ?>
					<?php endif; ?>
				<?php endif; ?>
				<input type="hidden" name="task" value="">
				<input type="hidden" name="boxchecked" value="0">
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
	</div>
</form>
