<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\View\Reviews;

use Comdev\Component\Onecore\Administrator\Helper\LicenseHelper;
use Comdev\Component\Onecore\Administrator\Helper\OneCoreHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Reviews view class. (OneCore Plus only)
 *
 * @since  1.0.16
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * The Form object
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	protected $form;

	/**
	 * The active item
	 *
	 * @var  object
	 */
	protected $item;

	/**
	 * The model state
	 *
	 * @var  \Joomla\Registry\Registry
	 */
	protected $state;

	/**
	 * An array of items (for list view)
	 *
	 * @var  array
	 */
	protected $items;

	/**
	 * The pagination object (for list view)
	 *
	 * @var  \Joomla\CMS\Pagination\Pagination
	 */
	protected $pagination;

	/**
	 * Form object for search filters (for list view)
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	public $filterForm;

	/**
	 * The active search filters (for list view)
	 *
	 * @var  array
	 */
	public $activeFilters;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  The name of the template file to parse
	 *
	 * @return  void
	 *
	 * @since   1.0.16
	 */
	public function display($tpl = null)
	{
		// Add custom CSS for submenu padding (needed for Email Logs submenu)
		OneCoreHelper::addAdminMenuCSS();
		
		$app = Factory::getApplication();

		if (LicenseHelper::getLicenseType() !== 'plus') {
			$app->enqueueMessage(\Joomla\CMS\Language\Text::_('COM_ONECORE_REVIEWS_PLUS_ONLY'), 'warning');
			$app->redirect(\Joomla\CMS\Router\Route::_('index.php?option=com_onecore&view=dashboard', false));
			return;
		}

		$layout = $app->getInput()->getCmd('layout', 'default');
		if ($layout === 'edit') {
			$this->displayEdit($tpl);
		} else {
			$this->displayList($tpl);
		}
	}

	/**
	 * Display the list layout
	 *
	 * @param   string  $tpl  The name of the template file to parse
	 *
	 * @return  void
	 *
	 * @since   1.0.16
	 */
	protected function displayList($tpl = null)
	{
		$this->items         = $this->get('Items');
		$this->pagination    = $this->get('Pagination');
		$this->state         = $this->get('State');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Display the edit form
	 *
	 * @param   string  $tpl  The name of the template file to parse
	 *
	 * @return  void
	 *
	 * @since   1.0.16
	 */
	protected function displayEdit($tpl = null)
	{
		$app = Factory::getApplication();
		$component = $app->bootComponent('com_onecore');
		$factory = $component->getMVCFactory();
		$className = 'Comdev\\Component\\Onecore\\Administrator\\Model\\Reviews\\ItemModel';
		$model = new $className(['ignore_request' => false], $factory);
		if ($model instanceof \Joomla\Database\DatabaseAwareInterface) {
			$model->setDatabase(Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class));
		}
		if ($model instanceof \Joomla\CMS\Form\FormFactoryAwareInterface) {
			$model->setFormFactory(Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class));
		}
		if ($model instanceof \Joomla\Event\DispatcherAwareInterface) {
			$model->setDispatcher(Factory::getContainer()->get(\Joomla\Event\DispatcherInterface::class));
		}

		\Joomla\CMS\Form\Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_onecore/forms');
		\Joomla\CMS\Form\Form::addFieldPath(JPATH_ADMINISTRATOR . '/components/com_onecore/src/Field');

		$this->form  = $model->getForm();
		$this->item  = $model->getItem();
		$this->state = $model->getState();

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.0.16
	 */
	protected function addToolbar()
	{
		$app = Factory::getApplication();
		$layout = $app->getInput()->getCmd('layout', 'default');
		$user = $app->getIdentity();

		if ($layout === 'edit') {
			OneCoreHelper::setToolbarTitle(\Joomla\CMS\Language\Text::_('COM_ONECORE_REVIEWS_EDIT'), 'star review');
			ToolbarHelper::apply('review.apply');
			ToolbarHelper::save('review.save');
			ToolbarHelper::save2new('review.save2new');
			ToolbarHelper::cancel('review.cancel', 'JTOOLBAR_CANCEL');
		} else {
			OneCoreHelper::setToolbarTitle(\Joomla\CMS\Language\Text::_('COM_ONECORE_REVIEWS'), 'star review');
			if ($user->authorise('core.create', 'com_onecore')) {
				ToolbarHelper::addNew('reviews.add');
			}
			if ($user->authorise('core.edit.state', 'com_onecore')) {
				ToolbarHelper::publish('reviews.publish', 'JTOOLBAR_PUBLISH', true);
				ToolbarHelper::unpublish('reviews.unpublish', 'JTOOLBAR_UNPUBLISH', true);
				ToolbarHelper::divider();
				ToolbarHelper::custom('reviews.approve', 'check', '', 'COM_ONECORE_REVIEW_APPROVE', true);
				ToolbarHelper::custom('reviews.unapprove', 'times', '', 'COM_ONECORE_REVIEW_UNAPPROVE', true);
			}
			if ($user->authorise('core.delete', 'com_onecore')) {
				ToolbarHelper::divider();
				ToolbarHelper::deleteList('JGLOBAL_CONFIRM_DELETE', 'reviews.delete', 'JTOOLBAR_DELETE');
			}
		}
	}
}
