<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\View\Importexport;

use Comdev\Component\Onecore\Administrator\Helper\LicenseHelper;
use Comdev\Component\Onecore\Administrator\Helper\OneCoreHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\Language\Text;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Import/Export view class.
 *
 * @since  1.0.13
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * Display the view
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  void
	 *
	 * @since   1.0.13
	 */
	public function display($tpl = null)
	{
		// Add custom CSS for submenu padding (needed for Email Logs submenu)
		OneCoreHelper::addAdminMenuCSS();
		
		$this->isLicensePlus = LicenseHelper::getLicenseType() === 'plus';
		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.0.13
	 */
	protected function addToolbar()
	{
		OneCoreHelper::setToolbarTitle(Text::_('COM_ONECORE_IMPORT_EXPORT'), 'upload');

		ToolbarHelper::preferences('com_onecore');
	}
}
