<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\View\Emailtemplates;

use Comdev\Component\Onecore\Administrator\Helper\OneCoreHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Email Templates view class.
 *
 * @since  1.0.17
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * The Form object
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	protected $form;

	/**
	 * The active item
	 *
	 * @var  object
	 */
	protected $item;

	/**
	 * The model state
	 *
	 * @var  \Joomla\Registry\Registry
	 */
	protected $state;

	/**
	 * An array of items (for list view)
	 *
	 * @var  array
	 */
	protected $items;

	/**
	 * The pagination object (for list view)
	 *
	 * @var  \Joomla\CMS\Pagination\Pagination
	 */
	protected $pagination;

	/**
	 * Form object for search filters (for list view)
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	public $filterForm;

	/**
	 * The active search filters (for list view)
	 *
	 * @var  array
	 */
	public $activeFilters;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  The name of the template file to parse
	 *
	 * @return  void
	 *
	 * @since   1.0.17
	 */
	public function display($tpl = null)
	{
		// Add custom CSS for submenu padding
		OneCoreHelper::addAdminMenuCSS();
		
		// Load Bootstrap modal script
		$wa = $this->getDocument()->getWebAssetManager();
		$wa->useScript('bootstrap.modal');
		
		$app = Factory::getApplication();
		$layout = $app->getInput()->getCmd('layout', 'default');
		if ($layout === 'edit') {
			$this->displayEdit($tpl);
		} else {
			$this->displayList($tpl);
		}
	}

	/**
	 * Display the list layout
	 *
	 * @param   string  $tpl  The name of the template file to parse
	 *
	 * @return  void
	 *
	 * @since   1.0.17
	 */
	protected function displayList($tpl = null)
	{
		// Create model directly to ensure it's loaded
		$component = Factory::getApplication()->bootComponent('com_onecore');
		$factory = $component->getMVCFactory();
		$className = \Comdev\Component\Onecore\Administrator\Model\EmailTemplates\EmailTemplatesModel::class;
		
		if (class_exists($className)) {
			$model = new $className(['ignore_request' => false], $factory);
			if ($model instanceof \Joomla\Database\DatabaseAwareInterface) {
				$model->setDatabase(Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class));
			}
			if ($model instanceof \Joomla\CMS\Form\FormFactoryAwareInterface) {
				$model->setFormFactory(Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class));
			}
			if ($model instanceof \Joomla\Event\DispatcherAwareInterface) {
				$model->setDispatcher(Factory::getContainer()->get(\Joomla\Event\DispatcherInterface::class));
			}
			
			// Set model as default
			$this->setModel($model, true);
			
			// Get data directly from model
			$this->items         = $model->getItems();
			$this->pagination    = $model->getPagination();
			$this->state         = $model->getState();
			$this->filterForm    = $model->getFilterForm();
			$this->activeFilters = $model->getActiveFilters();
		} else {
			// Fallback to standard method if model class doesn't exist
			$this->items         = $this->get('Items');
			$this->pagination    = $this->get('Pagination');
			$this->state         = $this->get('State');
			$this->filterForm    = $this->get('FilterForm');
			$this->activeFilters = $this->get('ActiveFilters');
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Display the edit form
	 *
	 * @param   string  $tpl  The name of the template file to parse
	 *
	 * @return  void
	 *
	 * @since   1.0.17
	 */
	protected function displayEdit($tpl = null)
	{
		$app = Factory::getApplication();
		$component = $app->bootComponent('com_onecore');
		$factory = $component->getMVCFactory();
		$className = 'Comdev\\Component\\Onecore\\Administrator\\Model\\EmailTemplates\\ItemModel';
		$model = new $className(['ignore_request' => false], $factory);
		if ($model instanceof \Joomla\Database\DatabaseAwareInterface) {
			$model->setDatabase(Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class));
		}
		if ($model instanceof \Joomla\CMS\Form\FormFactoryAwareInterface) {
			$model->setFormFactory(Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class));
		}
		if ($model instanceof \Joomla\Event\DispatcherAwareInterface) {
			$model->setDispatcher(Factory::getContainer()->get(\Joomla\Event\DispatcherInterface::class));
		}

		\Joomla\CMS\Form\Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_onecore/forms');
		\Joomla\CMS\Form\Form::addFieldPath(JPATH_ADMINISTRATOR . '/components/com_onecore/src/Field');

		$this->form  = $model->getForm();
		$this->item  = $model->getItem();
		$this->state = $model->getState();

		// Add preview modal script
		$document = Factory::getDocument();
		$itemId = (int) ($this->item->id ?? 0);
		$document->addScriptDeclaration("
			document.addEventListener('DOMContentLoaded', function() {
				var previewBtn = document.getElementById('preview-btn');
				var modalElement = document.getElementById('emailPreviewModal');
				
				if (previewBtn && modalElement) {
					// Initialize modal if Bootstrap is available
					if (typeof window.bootstrap !== 'undefined' && window.bootstrap.Modal) {
						var modalInstance = window.bootstrap.Modal.getInstance(modalElement);
						if (!modalInstance) {
							modalInstance = new window.bootstrap.Modal(modalElement);
						}
					}
					
					previewBtn.addEventListener('click', function(e) {
						e.preventDefault();
						
						// Show loading state
						document.getElementById('preview-title').textContent = 'Loading...';
						document.getElementById('preview-content').innerHTML = '<div class=\"text-center\"><span class=\"spinner-border\" role=\"status\"></span></div>';
						
						// Show modal first
						if (typeof window.bootstrap !== 'undefined' && window.bootstrap.Modal) {
							var modalInstance = window.bootstrap.Modal.getInstance(modalElement);
							if (!modalInstance) {
								modalInstance = new window.bootstrap.Modal(modalElement);
							}
							modalInstance.show();
						} else {
							// Fallback: show modal using CSS
							modalElement.classList.add('show');
							modalElement.style.display = 'block';
							document.body.classList.add('modal-open');
							var backdrop = document.createElement('div');
							backdrop.className = 'modal-backdrop fade show';
							backdrop.id = 'emailPreviewModalBackdrop';
							document.body.appendChild(backdrop);
						}
						
						var form = document.getElementById('emailtemplate-form');
						if (!form) {
							alert('Error: Form not found');
							return;
						}
						
						var formData = new FormData(form);
						formData.append('task', 'emailtemplates.preview');
						formData.append('format', 'json');
						formData.append('id', " . $itemId . ");
						
						var url = '" . Route::_('index.php?option=com_onecore&task=emailtemplates.preview&format=json', false) . "';
						
						fetch(url, {
							method: 'POST',
							body: formData,
							headers: {
								'X-Requested-With': 'XMLHttpRequest'
							}
						})
						.then(response => {
							if (!response.ok) {
								throw new Error('HTTP error! status: ' + response.status);
							}
							return response.json();
						})
						.then(data => {
							if (data.success) {
								document.getElementById('preview-title').textContent = data.title || '';
								document.getElementById('preview-content').innerHTML = data.content || '';
							} else {
								document.getElementById('preview-title').textContent = 'Error';
								document.getElementById('preview-content').innerHTML = '<div class=\"alert alert-danger\">' + (data.message || 'Unknown error') + '</div>';
							}
						})
						.catch(error => {
							console.error('Error:', error);
							document.getElementById('preview-title').textContent = 'Error';
							document.getElementById('preview-content').innerHTML = '<div class=\"alert alert-danger\">Error loading preview: ' + error.message + '</div>';
						});
					});
				}
			});
		");

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.0.17
	 */
	protected function addToolbar()
	{
		$app = Factory::getApplication();
		$layout = $app->getInput()->getCmd('layout', 'default');
		$user = $app->getIdentity();

		if ($layout === 'edit') {
			OneCoreHelper::setToolbarTitle(\Joomla\CMS\Language\Text::_('COM_ONECORE_EMAIL_TEMPLATES_EDIT'), 'envelope');
			ToolbarHelper::apply('emailtemplate.apply');
			ToolbarHelper::save('emailtemplate.save');
			ToolbarHelper::cancel('emailtemplates.cancel', 'JTOOLBAR_CANCEL');
		} else {
			OneCoreHelper::setToolbarTitle(\Joomla\CMS\Language\Text::_('COM_ONECORE_EMAIL_TEMPLATES'), 'envelope');
			if ($user->authorise('core.edit.state', 'com_onecore')) {
				ToolbarHelper::publish('emailtemplates.publish', 'JTOOLBAR_PUBLISH', true);
				ToolbarHelper::unpublish('emailtemplates.unpublish', 'JTOOLBAR_UNPUBLISH', true);
			}
		}
	}
}
