<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\View\Emaillogs;

use Comdev\Component\Onecore\Administrator\Helper\OneCoreHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Email Logs view class.
 *
 * @since  1.0.17
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * An array of items (for list view)
	 *
	 * @var  array
	 */
	protected $items;

	/**
	 * The pagination object (for list view)
	 *
	 * @var  \Joomla\CMS\Pagination\Pagination
	 */
	protected $pagination;

	/**
	 * The model state
	 *
	 * @var  \Joomla\Registry\Registry
	 */
	protected $state;

	/**
	 * Form object for search filters (for list view)
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	public $filterForm;

	/**
	 * The active search filters (for list view)
	 *
	 * @var  array
	 */
	public $activeFilters;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  The name of the template file to parse
	 *
	 * @return  void
	 *
	 * @since   1.0.17
	 */
	public function display($tpl = null)
	{
		// Add custom CSS for submenu padding
		OneCoreHelper::addAdminMenuCSS();
		
		// Create model directly to ensure it's loaded
		$component = Factory::getApplication()->bootComponent('com_onecore');
		$factory = $component->getMVCFactory();
		$className = \Comdev\Component\Onecore\Administrator\Model\EmailLogs\EmailLogsModel::class;

		if (class_exists($className)) {
			$model = new $className(['ignore_request' => false], $factory);
			if ($model instanceof \Joomla\Database\DatabaseAwareInterface) {
				$model->setDatabase(Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class));
			}
			if ($model instanceof \Joomla\CMS\Form\FormFactoryAwareInterface) {
				$model->setFormFactory(Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class));
			}
			if ($model instanceof \Joomla\Event\DispatcherAwareInterface) {
				$model->setDispatcher(Factory::getContainer()->get(\Joomla\Event\DispatcherInterface::class));
			}

			// Set model as default
			$this->setModel($model, true);

			// Get data directly from model
			$this->items         = $model->getItems();
			$this->pagination    = $model->getPagination();
			$this->state         = $model->getState();
			$this->filterForm    = $model->getFilterForm();
			$this->activeFilters = $model->getActiveFilters();
		} else {
			// Fallback to standard method if model class doesn't exist
			$this->items         = $this->get('Items');
			$this->pagination    = $this->get('Pagination');
			$this->state         = $this->get('State');
			$this->filterForm    = $this->get('FilterForm');
			$this->activeFilters = $this->get('ActiveFilters');
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.0.17
	 */
	protected function addToolbar()
	{
		ToolbarHelper::title(\Joomla\CMS\Language\Text::_('COM_ONECORE_EMAIL_LOGS'), 'envelope');

		// No actions needed for read-only logs view
	}
}
