<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Table;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Email Template table class.
 *
 * @since  1.0.17
 */
class EmailTemplateTable extends Table
{
	/**
	 * Constructor
	 *
	 * @param   DatabaseDriver  $db  Database connector object
	 *
	 * @since   1.0.17
	 */
	public function __construct(DatabaseDriver $db)
	{
		$this->typeAlias = 'com_onecore.emailtemplate';

		parent::__construct('#__one_email_templ', 'id', $db);
	}

	/**
	 * Method to perform sanity checks on the Table instance properties.
	 *
	 * @return  boolean  True if the instance is sane and able to be stored in the database.
	 *
	 * @since   1.0.17
	 */
	public function check()
	{
		if (trim((string) ($this->title ?? '')) === '') {
			$this->setError(Text::_('COM_ONECORE_EMAIL_TEMPLATE_TITLE_REQUIRED'));
			return false;
		}

		if (trim((string) ($this->email_title ?? '')) === '') {
			$this->setError(Text::_('COM_ONECORE_EMAIL_TEMPLATE_EMAIL_TITLE_REQUIRED'));
			return false;
		}

		if (trim((string) ($this->email_content ?? '')) === '') {
			$this->setError(Text::_('COM_ONECORE_EMAIL_TEMPLATE_EMAIL_CONTENT_REQUIRED'));
			return false;
		}

		if (empty($this->created) || $this->created === '0000-00-00 00:00:00') {
			$this->created = Factory::getDate()->toSql();
		}

		if (empty($this->language)) {
			$this->language = '*';
		}

		// Set modified date
		$date = Factory::getDate()->toSql();
		if ($this->id) {
			$this->modified = $date;
			$this->modified_by = Factory::getApplication()->getIdentity()->id;
		} else {
			$this->created_by = Factory::getApplication()->getIdentity()->id;
		}

		return true;
	}
}
