<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Table;

use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Customfieldgroup table class.
 *
 * @since  1.0.9
 */
class CustomfieldgroupTable extends Table
{
	/**
	 * Constructor
	 *
	 * @param   DatabaseDriver  $db  Database connector object
	 *
	 * @since   1.0.9
	 */
	public function __construct(DatabaseDriver $db)
	{
		$this->typeAlias = 'com_onecore.customfieldgroup';

		parent::__construct('#__one_customfield_groups', 'id', $db);
	}

	/**
	 * Method to store a row in the database from the Table instance properties.
	 *
	 * @param   boolean  $updateNulls  True to update fields even if they are null.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.0.9
	 */
	public function store($updateNulls = false)
	{
		$date = \Joomla\CMS\Factory::getDate()->toSql();

		if ($this->id) {
			$this->modified = $date;
		} else {
			if (!(int) $this->created) {
				$this->created = $date;
			}
		}

		return parent::store($updateNulls);
	}
}
