<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Table;

use Joomla\CMS\Application\ApplicationHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Content table class.
 *
 * @since  1.0.0
 */
class ContentTable extends Table
{
	/**
	 * Constructor
	 *
	 * @param   DatabaseDriver  $db  Database connector object
	 *
	 * @since   1.0.0
	 */
	public function __construct(DatabaseDriver $db)
	{
		$this->typeAlias = 'com_onecore.content';

		parent::__construct('#__one_content', 'id', $db);
	}

	/**
	 * Method to perform sanity checks on the Table instance properties to ensure they are safe to store in the database.
	 *
	 * @return  boolean  True if the instance is sane and able to be stored in the database.
	 *
	 * @since   1.0.0
	 */
	public function check()
	{
		try {
			parent::check();
		} catch (\Exception $e) {
			$this->setError($e->getMessage());
			return false;
		}

		// Check for a title
		if (trim($this->title) == '') {
			$this->setError(Text::_('COM_ONECORE_WARNING_PROVIDE_VALID_NAME'));
			return false;
		}

		// Generate alias from title if empty
		if (trim($this->alias) == '') {
			$this->alias = $this->title;
		}

		// Make alias URL-safe
		$app = Factory::getApplication();
		if ($app->get('unicodeslugs') == 1) {
			$this->alias = \Joomla\CMS\Filter\OutputFilter::stringUrlUnicodeSlug($this->alias);
		} else {
			$this->alias = ApplicationHelper::stringURLSafe($this->alias);
		}

		// If alias is still empty after sanitization, use date
		if (trim(str_replace('-', '', $this->alias)) == '') {
			$this->alias = Factory::getDate()->format('Y-m-d-H-i-s');
		}

		return true;
	}
}

