<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Model\Reviews;

use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Table\Table;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Review item model class.
 *
 * @since  1.0.16
 */
class ItemModel extends AdminModel
{
	/**
	 * The model name.
	 *
	 * @var    string
	 * @since  1.0.16
	 */
	protected $name = 'item';

	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.0.16
	 */
	protected $text_prefix = 'COM_ONECORE_REVIEWS';

	/**
	 * Method to get a table object, load it if necessary.
	 *
	 * @param   string  $name     The table name. Optional.
	 * @param   string  $prefix   The class prefix. Optional.
	 * @param   array   $options  Configuration array for model. Optional.
	 *
	 * @return  Table  A Table object
	 *
	 * @since   1.0.16
	 */
	public function getTable($name = 'Review', $prefix = 'Administrator', $options = [])
	{
		return parent::getTable($name, $prefix, $options);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  \Joomla\CMS\Form\Form|boolean  A Form object on success, false on failure
	 *
	 * @since   1.0.16
	 */
	public function getForm($data = [], $loadData = true)
	{
		\Joomla\CMS\Form\Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_onecore/forms');
		\Joomla\CMS\Form\Form::addFieldPath(JPATH_ADMINISTRATOR . '/components/com_onecore/src/Field');

		$form = $this->loadForm(
			'com_onecore.review',
			'reviews',
			['control' => 'jform', 'load_data' => $loadData]
		);

		if (empty($form)) {
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 *
	 * @since   1.0.16
	 */
	protected function loadFormData()
	{
		$app = \Joomla\CMS\Factory::getApplication();
		$data = $app->getUserState('com_onecore.edit.review.data', []);

		if (empty($data)) {
			$data = $this->getItem();
		}

		return $data;
	}
}
