<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Model\EmailTemplates;

use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Table\Table;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Email Template item model class.
 *
 * @since  1.0.17
 */
class ItemModel extends AdminModel
{
	/**
	 * The model name.
	 *
	 * @var    string
	 * @since   1.0.17
	 */
	protected $name = 'item';

	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since   1.0.17
	 */
	protected $text_prefix = 'COM_ONECORE_EMAIL_TEMPLATES';

	/**
	 * Method to get a table object, load it if necessary.
	 *
	 * @param   string  $name     The table name. Optional.
	 * @param   string  $prefix   The class prefix. Optional.
	 * @param   array   $options  Configuration array for model. Optional.
	 *
	 * @return  Table  A Table object
	 *
	 * @since   1.0.17
	 */
	public function getTable($name = 'EmailTemplate', $prefix = 'Administrator', $options = [])
	{
		return parent::getTable($name, $prefix, $options);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  \Joomla\CMS\Form\Form|boolean  A Form object on success, false on failure
	 *
	 * @since   1.0.17
	 */
	public function getForm($data = [], $loadData = true)
	{
		\Joomla\CMS\Form\Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_onecore/forms');
		\Joomla\CMS\Form\Form::addFieldPath(JPATH_ADMINISTRATOR . '/components/com_onecore/src/Field');

		$form = $this->loadForm(
			'com_onecore.emailtemplate',
			'emailtemplates',
			['control' => 'jform', 'load_data' => $loadData]
		);

		if (empty($form)) {
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 *
	 * @since   1.0.17
	 */
	protected function loadFormData()
	{
		$app = \Joomla\CMS\Factory::getApplication();
		$data = $app->getUserState('com_onecore.edit.emailtemplate.data', []);

		if (empty($data)) {
			$data = $this->getItem();
		}

		return $data;
	}

	/**
	 * Method to get a preview of the email template with variables replaced.
	 *
	 * @param   int     $id        Template ID
	 * @param   array   $variables  Variables to replace
	 *
	 * @return  object|false  Template object with replaced content, false on failure
	 *
	 * @since   1.0.17
	 */
	public function getPreview($id, $variables = [])
	{
		$item = $this->getItem($id);

		if (!$item) {
			return false;
		}

		// Default variables for preview
		$defaultVars = [
			'{user}' => 'John Doe',
			'{user_email}' => 'john.doe@example.com',
			'{listing_title}' => 'Sample Listing Title',
			'{event_title}' => 'Sample Event Title',
			'{review_title}' => 'Sample Review Title',
			'{review_body}' => 'This is a sample review body text.',
			'{site_name}' => \Joomla\CMS\Factory::getApplication()->get('sitename'),
			'{site_url}' => \Joomla\CMS\Uri\Uri::root(),
		];

		$vars = array_merge($defaultVars, $variables);

		$preview = clone $item;
		$preview->email_title = str_replace(array_keys($vars), array_values($vars), $preview->email_title);
		$preview->email_content = str_replace(array_keys($vars), array_values($vars), $preview->email_content);

		return $preview;
	}
}
