<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Model\EmailTemplates;

use Joomla\CMS\MVC\Model\ListModel;
use Joomla\Database\ParameterType;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Email Templates model class.
 *
 * @since  1.0.17
 */
class EmailTemplatesModel extends ListModel
{
	/**
	 * Constructor.
	 *
	 * @param   array  $config  An optional associative array of configuration settings.
	 *
	 * @since   1.0.17
	 */
	public function __construct($config = [])
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = [
				'id', 'a.id',
				'title', 'a.title',
				'email_title', 'a.email_title',
				'entity', 'a.entity',
				'published', 'a.published',
				'language', 'a.language',
				'created', 'a.created',
				'modified', 'a.modified',
			];
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * @param   string  $ordering   An optional ordering field.
	 * @param   string  $direction  An optional direction (asc|desc).
	 *
	 * @return  void
	 *
	 * @since   1.0.17
	 */
	protected function populateState($ordering = 'a.created', $direction = 'DESC')
	{
		parent::populateState($ordering, $direction);
	}

	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @return  \Joomla\Database\DatabaseQuery
	 *
	 * @since   1.0.17
	 */
	protected function getListQuery()
	{
		$db = $this->getDatabase();
		$query = $db->getQuery(true);

		$query->select(
			$this->getState(
				'list.select',
				'a.*'
			)
		)
			->from($db->quoteName('#__one_email_templ', 'a'));

		// Filter by published
		$published = $this->getState('filter.published');
		if ($published !== '' && $published !== null && is_numeric($published)) {
			$query->where($db->quoteName('a.published') . ' = :published')
				->bind(':published', $published, ParameterType::INTEGER);
		}

		// Filter by entity
		$entity = $this->getState('filter.entity');
		if ($entity !== null && $entity !== '') {
			$query->where($db->quoteName('a.entity') . ' = :entity')
				->bind(':entity', $entity);
		}

		// Filter by language
		$language = $this->getState('filter.language');
		if ($language !== null && $language !== '') {
			$query->where($db->quoteName('a.language') . ' = :language')
				->bind(':language', $language);
		}

		// Search
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$search = '%' . str_replace(' ', '%', $db->escape(trim($search), true)) . '%';
			$query->where(
				'(' . $db->quoteName('a.title') . ' LIKE :search1 OR ' .
				$db->quoteName('a.email_title') . ' LIKE :search2 OR ' .
				$db->quoteName('a.email_content') . ' LIKE :search3)'
			)
				->bind([':search1', ':search2', ':search3'], $search);
		}

		$orderCol = $this->state->get('list.ordering', 'a.created');
		$orderDirn = $this->state->get('list.direction', 'DESC');
		$query->order($db->escape($orderCol) . ' ' . $db->escape($orderDirn));

		return $query;
	}
}
