<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Model\Customfieldgroups;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\CMS\Table\Table;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Customfieldgroup item model.
 *
 * @since  1.0.9
 */
class ItemModel extends AdminModel
{
	/**
	 * The type alias for this content type.
	 *
	 * @var    string
	 * @since  1.0.9
	 */
	public $typeAlias = 'com_onecore.customfieldgroup';

	/**
	 * Method to get a table object, load it if necessary.
	 *
	 * @param   string  $name     The table name. Optional.
	 * @param   string  $prefix   The class prefix. Optional.
	 * @param   array   $options  Configuration array for model. Optional.
	 *
	 * @return  Table  A Table object
	 *
	 * @since   1.0.9
	 */
	public function getTable($name = 'Customfieldgroup', $prefix = 'Administrator', $options = [])
	{
		return parent::getTable($name, $prefix, $options);
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array    $data      Data for the form.
	 * @param   boolean  $loadData  True if the form is to load its own data (default case), false if not.
	 *
	 * @return  \Joomla\CMS\Form\Form|boolean  A Form object on success, false on failure
	 *
	 * @since   1.0.9
	 */
	public function getForm($data = [], $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm(
			'com_onecore.customfieldgroup',
			'customfieldgroup',
			[
				'control' => 'jform',
				'load_data' => $loadData,
			]
		);

		if (empty($form)) {
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return  mixed  The data for the form.
	 *
	 * @since   1.0.9
	 */
	protected function loadFormData()
	{
		$app = Factory::getApplication();

		// Check the session for previously entered form data.
		$data = $app->getUserState('com_onecore.edit.customfieldgroup.data', []);

		if (empty($data)) {
			$data = $this->getItem();
		}

		$this->preprocessData('com_onecore.customfieldgroup', $data);

		return $data;
	}

	/**
	 * Method to save the form data.
	 *
	 * @param   array  $data  The form data.
	 *
	 * @return  boolean  True on success.
	 *
	 * @since   1.0.9
	 */
	public function save($data)
	{
		$table = $this->getTable();

		$key = $table->getKeyName();
		$pk = (!empty($data[$key])) ? $data[$key] : (int) $this->getState($this->getName() . '.id');
		$isNew = true;

		// Allow an exception to be thrown.
		try {
			// Load the row if saving an existing record.
			if ($pk > 0) {
				$table->load($pk);
				$isNew = false;
			}
		} catch (\Exception $e) {
			if ($e->getCode() == 404) {
				// Need to go thru the save method to insert
				$isNew = true;
			} else {
				$this->setError($e->getMessage());

				return false;
			}
		}

		if ($isNew && empty($data['created'])) {
			$data['created'] = Factory::getDate()->toSql();
		}

		if (isset($data['modified'])) {
			$data['modified'] = Factory::getDate()->toSql();
		}

		// Handle entity_type - convert empty string to NULL before binding
		if (isset($data['entity_type']) && $data['entity_type'] === '') {
			$data['entity_type'] = null;
		}

		// Bind the data.
		if (!$table->bind($data)) {
			$this->setError($table->getError());

			return false;
		}

		// Prepare the row for saving
		$this->prepareTable($table);

		// Check the data.
		if (!$table->check()) {
			$this->setError($table->getError());

			return false;
		}

		// Store the data.
		if (!$table->store()) {
			$this->setError($table->getError());

			return false;
		}

		$this->setState($this->getName() . '.id', $table->$key);

		// Clear the cache
		$this->cleanCache();

		return true;
	}
}
