-- Fix broken hardcoded prefix in earlier updates by ensuring the correct table is updated
-- and extend custom fields with category mapping.

-- Ensure nested-set columns exist for #__one_categories (safe for existing installs)
ALTER TABLE `#__one_categories`
	ADD COLUMN IF NOT EXISTS `lft` int NOT NULL DEFAULT 0 AFTER `parent_id`,
	ADD COLUMN IF NOT EXISTS `rgt` int NOT NULL DEFAULT 0 AFTER `lft`,
	ADD COLUMN IF NOT EXISTS `level` int NOT NULL DEFAULT 0 AFTER `rgt`,
	ADD COLUMN IF NOT EXISTS `path` varchar(1024) NOT NULL DEFAULT '' AFTER `alias`,
	ADD COLUMN IF NOT EXISTS `extension` varchar(50) NOT NULL DEFAULT 'com_onecore' AFTER `id`;

ALTER TABLE `#__one_categories`
	ADD KEY IF NOT EXISTS `idx_lft_rgt` (`lft`, `rgt`),
	ADD KEY IF NOT EXISTS `idx_extension` (`extension`);

-- Create custom fields tables if missing (in case 1.0.4 wasn't applied)
CREATE TABLE IF NOT EXISTS `#__one_customfields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'input',
  `required` tinyint NOT NULL DEFAULT 0,
  `height` int NOT NULL DEFAULT 0,
  `ordering` int NOT NULL DEFAULT 0,
  `display_label` tinyint NOT NULL DEFAULT 1,
  `label_position` varchar(10) NOT NULL DEFAULT 'next',
  `searchable` tinyint NOT NULL DEFAULT 0,
  `pos_items` varchar(20) NOT NULL DEFAULT 'none',
  `pos_item` varchar(20) NOT NULL DEFAULT 'none',
  `pos_module` varchar(20) NOT NULL DEFAULT 'none',
  `published` tinyint NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_ordering` (`ordering`),
  KEY `idx_searchable` (`searchable`),
  KEY `idx_type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__one_customfield_values` (
  `id` int NOT NULL AUTO_INCREMENT,
  `content_id` int NOT NULL,
  `field_id` int NOT NULL,
  `value` mediumtext NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_content_field` (`content_id`, `field_id`),
  KEY `idx_field_id` (`field_id`),
  CONSTRAINT `fk_one_customfield_values_content` FOREIGN KEY (`content_id`) REFERENCES `#__one_content` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_customfield_values_field` FOREIGN KEY (`field_id`) REFERENCES `#__one_customfields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__one_customfield_categories` (
  `field_id` int NOT NULL,
  `category_id` int NOT NULL,
  PRIMARY KEY (`field_id`, `category_id`),
  KEY `idx_field_id` (`field_id`),
  KEY `idx_category_id` (`category_id`),
  CONSTRAINT `fk_one_customfield_categories_field` FOREIGN KEY (`field_id`) REFERENCES `#__one_customfields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_customfield_categories_category` FOREIGN KEY (`category_id`) REFERENCES `#__one_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

