-- Add tables for Email Templates feature
CREATE TABLE IF NOT EXISTS `#__one_email_templ` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `email_title` varchar(255) NOT NULL DEFAULT '',
  `email_content` mediumtext NOT NULL,
  `entity` enum('contents','events') DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '*',
  `send_to_user` tinyint NOT NULL DEFAULT 1,
  `send_cc_to_admin` tinyint NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT 0,
  `modified` datetime,
  `modified_by` int unsigned NOT NULL DEFAULT 0,
  `checked_out` int unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime,
  `note` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_entity` (`entity`),
  KEY `idx_language` (`language`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__one_email_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `template_id` int NOT NULL,
  `recipient_email` varchar(255) NOT NULL DEFAULT '',
  `recipient_name` varchar(255) NOT NULL DEFAULT '',
  `cc_email` varchar(255) NOT NULL DEFAULT '',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `body` mediumtext NOT NULL,
  `status` enum('sent','failed','pending') NOT NULL DEFAULT 'pending',
  `error_message` text,
  `sent_at` datetime,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_template_id` (`template_id`),
  KEY `idx_status` (`status`),
  KEY `idx_sent_at` (`sent_at`),
  KEY `idx_created` (`created`),
  CONSTRAINT `fk_one_email_logs_template` FOREIGN KEY (`template_id`) REFERENCES `#__one_email_templ` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Insert default email template for Review Approved
--

INSERT INTO `#__one_email_templ` (`title`, `email_title`, `email_content`, `entity`, `published`, `language`, `send_to_user`, `send_cc_to_admin`, `created`, `created_by`)
SELECT 
    'Review Approved',
    'Your review has been approved - {listing_title}',
    '<p>Hello {user},</p><p>Thank you for your review!</p><p>Your review for <strong>{listing_title}</strong> has been approved and is now visible on our website.</p><p><strong>Your review:</strong><br><strong>Title:</strong> {review_title}<br><strong>Content:</strong> {review_body}</p><p>You can view the listing here: <a href="{site_url}">{site_url}</a></p><p>Thank you for taking the time to share your experience.</p><p>Best regards,<br>{site_name}</p>',
    NULL,
    1,
    '*',
    1,
    0,
    NOW(),
    0
WHERE NOT EXISTS (
    SELECT 1 FROM `#__one_email_templ` WHERE `title` = 'Review Approved'
);
