-- Add table #__one_reviews (OneCore Plus - Reviews feature)
CREATE TABLE IF NOT EXISTS `#__one_reviews` (
  `id` int NOT NULL AUTO_INCREMENT,
  `content_id` int DEFAULT NULL,
  `event_id` int DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `rating` tinyint NOT NULL DEFAULT 0,
  `body` text NOT NULL,
  `approved` tinyint NOT NULL DEFAULT 0,
  `published` tinyint NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_content_id` (`content_id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_approved` (`approved`),
  KEY `idx_published` (`published`),
  KEY `idx_created` (`created`),
  CONSTRAINT `fk_one_reviews_content` FOREIGN KEY (`content_id`) REFERENCES `#__one_content` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_reviews_event` FOREIGN KEY (`event_id`) REFERENCES `#__one_events` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chk_one_reviews_ref` CHECK ((`content_id` IS NOT NULL AND `event_id` IS NULL) OR (`content_id` IS NULL AND `event_id` IS NOT NULL))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;
