-- Add attendees_count column to events table
ALTER TABLE `#__one_events` 
ADD COLUMN IF NOT EXISTS `attendees_count` int unsigned NOT NULL DEFAULT 0 AFTER `hits`;

-- Create table for event attendees (if not exists)
CREATE TABLE IF NOT EXISTS `#__one_event_attendees` (
  `id` int NOT NULL AUTO_INCREMENT,
  `event_id` int NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_event_user` (`event_id`, `user_id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_user_id` (`user_id`),
  CONSTRAINT `fk_one_event_attendees_event` FOREIGN KEY (`event_id`) REFERENCES `#__one_events` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;
