--
-- Table structure for table `#__one_categories`
--

CREATE TABLE IF NOT EXISTS `#__one_categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `extension` varchar(50) NOT NULL DEFAULT 'com_onecore',
  `parent_id` int unsigned NOT NULL DEFAULT 0,
  `lft` int NOT NULL DEFAULT 0,
  `rgt` int NOT NULL DEFAULT 0,
  `level` int NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `published` tinyint NOT NULL DEFAULT 0,
  `checked_out` int unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime,
  `ordering` int NOT NULL DEFAULT 0,
  `access` int unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT 0,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `version` int unsigned NOT NULL DEFAULT 1,
  `hits` int unsigned NOT NULL DEFAULT 0,
  `image` varchar(255) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_parent_id` (`parent_id`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`),
  KEY `idx_lft_rgt` (`lft`, `rgt`),
  KEY `idx_extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__one_categories`
-- Insert ROOT categories at the top of the tree
-- ROOT (id=1) is for content, ROOT EVENTS (id=2) is for events
-- Using INSERT IGNORE to prevent duplicate key errors on reinstall/update
--

INSERT IGNORE INTO `#__one_categories` (`id`, `extension`, `parent_id`, `lft`, `rgt`, `level`, `title`, `alias`, `path`, `description`, `published`, `checked_out`, `checked_out_time`, `ordering`, `access`, `language`, `params`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `version`, `hits`, `image`, `note`) VALUES
(1, 'com_onecore', 0, 1, 2, 0, 'ROOT', 'root', '', '', 1, 0, NULL, 0, 1, '*', '{}', NOW(), 0, '', NOW(), 0, '', '', '{}', 1, 0, '', ''),
(2, 'com_onecore', 0, 3, 4, 0, 'ROOT EVENTS', 'root-events', '', '', 1, 0, NULL, 0, 1, '*', '{}', NOW(), 0, '', NOW(), 0, '', '', '{}', 1, 0, '', '');

--
-- Table structure for table `#__one_content`
--

CREATE TABLE IF NOT EXISTS `#__one_content` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `published` tinyint NOT NULL DEFAULT 0,
  `featured` tinyint NOT NULL DEFAULT 0,
  `checked_out` int unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime,
  `ordering` int NOT NULL DEFAULT 0,
  `access` int unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT 0,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `author` varchar(255) NOT NULL DEFAULT '',
  `robots` varchar(50) NOT NULL DEFAULT '',
  `xreference` varchar(255) NOT NULL DEFAULT '',
  `metadata` text NOT NULL,
  `version` int unsigned NOT NULL DEFAULT 1,
  `hits` int unsigned NOT NULL DEFAULT 0,
  `images` text NOT NULL,
  `video_link` varchar(2048) NOT NULL DEFAULT '',
  `user` int unsigned NOT NULL DEFAULT 0,
  `note` varchar(255) NOT NULL DEFAULT '',
  `publish_up` datetime,
  `publish_down` datetime,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_featured` (`featured`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`),
  KEY `idx_user` (`user`),
  KEY `idx_publish_up` (`publish_up`),
  KEY `idx_publish_down` (`publish_down`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_content_addresses`
--

CREATE TABLE IF NOT EXISTS `#__one_content_addresses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `content_id` int NOT NULL,
  `address` varchar(255) NOT NULL DEFAULT '',
  `address_street` varchar(255) NOT NULL DEFAULT '',
  `address_street_number` varchar(20) NOT NULL DEFAULT '',
  `address_postal_code` varchar(20) NOT NULL DEFAULT '',
  `address_city` varchar(100) NOT NULL DEFAULT '',
  `address_country` varchar(100) NOT NULL DEFAULT '',
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_content_id` (`content_id`),
  KEY `idx_location` (`latitude`, `longitude`),
  CONSTRAINT `fk_one_content_addresses_content` FOREIGN KEY (`content_id`) REFERENCES `#__one_content` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_content_categories` (for multi-category support)
--

CREATE TABLE IF NOT EXISTS `#__one_content_categories` (
  `content_id` int NOT NULL,
  `category_id` int NOT NULL,
  PRIMARY KEY (`content_id`, `category_id`),
  KEY `idx_content_id` (`content_id`),
  KEY `idx_category_id` (`category_id`),
  CONSTRAINT `fk_one_content_categories_content` FOREIGN KEY (`content_id`) REFERENCES `#__one_content` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_content_categories_category` FOREIGN KEY (`category_id`) REFERENCES `#__one_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_customfields`
--

CREATE TABLE IF NOT EXISTS `#__one_customfields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `group_id` int NOT NULL DEFAULT 0,
  `category_id` int NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'input',
  `required` tinyint NOT NULL DEFAULT 0,
  `height` int NOT NULL DEFAULT 0,
  `ordering` int NOT NULL DEFAULT 0,
  `display_label` tinyint NOT NULL DEFAULT 1,
  `label_position` varchar(10) NOT NULL DEFAULT 'next',
  `searchable` tinyint NOT NULL DEFAULT 0,
  `options` text,
  `pos_items` varchar(20) NOT NULL DEFAULT 'none',
  `pos_item` varchar(20) NOT NULL DEFAULT 'none',
  `pos_module` varchar(20) NOT NULL DEFAULT 'none',
  `published` tinyint NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  KEY `idx_group_id` (`group_id`),
  KEY `idx_category_id` (`category_id`),
  KEY `idx_published` (`published`),
  KEY `idx_ordering` (`ordering`),
  KEY `idx_searchable` (`searchable`),
  KEY `idx_type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_customfield_categories` (for linking custom fields to categories)
--
CREATE TABLE IF NOT EXISTS `#__one_customfield_categories` (
  `field_id` int NOT NULL,
  `category_id` int NOT NULL,
  PRIMARY KEY (`field_id`, `category_id`),
  KEY `idx_field_id` (`field_id`),
  KEY `idx_category_id` (`category_id`),
  CONSTRAINT `fk_one_customfield_categories_field` FOREIGN KEY (`field_id`) REFERENCES `#__one_customfields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_customfield_categories_category` FOREIGN KEY (`category_id`) REFERENCES `#__one_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_customfield_groups`
--

CREATE TABLE IF NOT EXISTS `#__one_customfield_groups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_id` int NOT NULL DEFAULT 0,
  `entity_type` enum('content','events') DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `show_title` tinyint NOT NULL DEFAULT 1,
  `show_description` tinyint NOT NULL DEFAULT 1,
  `pos_items` varchar(20) NOT NULL DEFAULT 'none',
  `pos_item` varchar(20) NOT NULL DEFAULT 'none',
  `pos_module` varchar(20) NOT NULL DEFAULT 'none',
  `ordering` int NOT NULL DEFAULT 0,
  `published` tinyint NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  KEY `idx_category_id` (`category_id`),
  KEY `idx_entity_type` (`entity_type`),
  KEY `idx_published` (`published`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_events`
--

CREATE TABLE IF NOT EXISTS `#__one_events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `images` text NOT NULL,
  `event_start` datetime NOT NULL,
  `event_end` datetime,
  `recur_event` text NOT NULL,
  `category_id` int DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT 0,
  `featured` tinyint NOT NULL DEFAULT 0,
  `checked_out` int unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime,
  `ordering` int NOT NULL DEFAULT 0,
  `access` int unsigned NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT 0,
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT 0,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `author` varchar(255) NOT NULL DEFAULT '',
  `robots` varchar(50) NOT NULL DEFAULT '',
  `xreference` varchar(255) NOT NULL DEFAULT '',
  `metadata` text NOT NULL,
  `version` int unsigned NOT NULL DEFAULT 1,
  `hits` int unsigned NOT NULL DEFAULT 0,
  `attendees_count` int unsigned NOT NULL DEFAULT 0,
  `note` varchar(255) NOT NULL DEFAULT '',
  `publish_up` datetime,
  `publish_down` datetime,
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_featured` (`featured`),
  KEY `idx_category_id` (`category_id`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`),
  KEY `idx_event_start` (`event_start`),
  KEY `idx_event_end` (`event_end`),
  CONSTRAINT `fk_one_events_category` FOREIGN KEY (`category_id`) REFERENCES `#__one_categories` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_event_addresses`
--

CREATE TABLE IF NOT EXISTS `#__one_event_addresses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `event_id` int NOT NULL,
  `address` varchar(255) NOT NULL DEFAULT '',
  `address_street` varchar(255) NOT NULL DEFAULT '',
  `address_street_number` varchar(20) NOT NULL DEFAULT '',
  `address_postal_code` varchar(20) NOT NULL DEFAULT '',
  `address_city` varchar(100) NOT NULL DEFAULT '',
  `address_country` varchar(100) NOT NULL DEFAULT '',
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_event_id` (`event_id`),
  KEY `idx_location` (`latitude`, `longitude`),
  CONSTRAINT `fk_one_event_addresses_event` FOREIGN KEY (`event_id`) REFERENCES `#__one_events` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_content_events` (for linking content to events - one-to-many)
--

CREATE TABLE IF NOT EXISTS `#__one_content_events` (
  `content_id` int NOT NULL,
  `event_id` int NOT NULL,
  PRIMARY KEY (`content_id`, `event_id`),
  KEY `idx_content_id` (`content_id`),
  KEY `idx_event_id` (`event_id`),
  CONSTRAINT `fk_one_content_events_content` FOREIGN KEY (`content_id`) REFERENCES `#__one_content` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_content_events_event` FOREIGN KEY (`event_id`) REFERENCES `#__one_events` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_event_attendees` (for tracking event attendees)
--

CREATE TABLE IF NOT EXISTS `#__one_event_attendees` (
  `id` int NOT NULL AUTO_INCREMENT,
  `event_id` int NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_event_user` (`event_id`, `user_id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_user_id` (`user_id`),
  CONSTRAINT `fk_one_event_attendees_event` FOREIGN KEY (`event_id`) REFERENCES `#__one_events` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_event_categories` (for multi-category support)
--

CREATE TABLE IF NOT EXISTS `#__one_event_categories` (
  `event_id` int NOT NULL,
  `category_id` int NOT NULL,
  PRIMARY KEY (`event_id`, `category_id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_category_id` (`category_id`),
  CONSTRAINT `fk_one_event_categories_event` FOREIGN KEY (`event_id`) REFERENCES `#__one_events` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_event_categories_category` FOREIGN KEY (`category_id`) REFERENCES `#__one_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_event_recurrences` (for recurring events - OneCore Plus feature)
--

CREATE TABLE IF NOT EXISTS `#__one_event_recurrences` (
  `id` int NOT NULL AUTO_INCREMENT,
  `event_id` int NOT NULL,
  `frequency` enum('daily','weekly','monthly','yearly') NOT NULL DEFAULT 'daily',
  `interval` int NOT NULL DEFAULT 1,
  `byday` varchar(255) DEFAULT NULL,
  `until_date` date DEFAULT NULL,
  `count` int DEFAULT NULL,
  `exceptions` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_event_id` (`event_id`),
  KEY `idx_frequency` (`frequency`),
  KEY `idx_until_date` (`until_date`),
  CONSTRAINT `fk_one_event_recurrences_event` FOREIGN KEY (`event_id`) REFERENCES `#__one_events` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_customfield_values`
--

CREATE TABLE IF NOT EXISTS `#__one_customfield_values` (
  `id` int NOT NULL AUTO_INCREMENT,
  `content_id` int DEFAULT NULL,
  `event_id` int DEFAULT NULL,
  `field_id` int NOT NULL,
  `value` mediumtext NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_content_field` (`content_id`, `field_id`),
  UNIQUE KEY `idx_event_field` (`event_id`, `field_id`),
  KEY `idx_field_id` (`field_id`),
  KEY `idx_content_id` (`content_id`),
  KEY `idx_event_id` (`event_id`),
  CONSTRAINT `fk_one_customfield_values_content` FOREIGN KEY (`content_id`) REFERENCES `#__one_content` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_customfield_values_event` FOREIGN KEY (`event_id`) REFERENCES `#__one_events` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_customfield_values_field` FOREIGN KEY (`field_id`) REFERENCES `#__one_customfields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chk_one_customfield_values_ref` CHECK ((`content_id` IS NOT NULL AND `event_id` IS NULL) OR (`content_id` IS NULL AND `event_id` IS NOT NULL))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_reviews` (OneCore Plus)
--

CREATE TABLE IF NOT EXISTS `#__one_reviews` (
  `id` int NOT NULL AUTO_INCREMENT,
  `content_id` int DEFAULT NULL,
  `event_id` int DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `rating` tinyint NOT NULL DEFAULT 0,
  `body` text NOT NULL,
  `approved` tinyint NOT NULL DEFAULT 0,
  `published` tinyint NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_content_id` (`content_id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_approved` (`approved`),
  KEY `idx_published` (`published`),
  KEY `idx_created` (`created`),
  CONSTRAINT `fk_one_reviews_content` FOREIGN KEY (`content_id`) REFERENCES `#__one_content` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_one_reviews_event` FOREIGN KEY (`event_id`) REFERENCES `#__one_events` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chk_one_reviews_ref` CHECK ((`content_id` IS NOT NULL AND `event_id` IS NULL) OR (`content_id` IS NULL AND `event_id` IS NOT NULL))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_email_templ` (Email Templates)
--

CREATE TABLE IF NOT EXISTS `#__one_email_templ` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `email_title` varchar(255) NOT NULL DEFAULT '',
  `email_content` mediumtext NOT NULL,
  `entity` enum('contents','events') DEFAULT NULL,
  `published` tinyint NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '*',
  `send_to_user` tinyint NOT NULL DEFAULT 1,
  `send_cc_to_admin` tinyint NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT 0,
  `modified` datetime,
  `modified_by` int unsigned NOT NULL DEFAULT 0,
  `checked_out` int unsigned NOT NULL DEFAULT 0,
  `checked_out_time` datetime,
  `note` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_entity` (`entity`),
  KEY `idx_language` (`language`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Table structure for table `#__one_email_logs` (Email Logs)
--

CREATE TABLE IF NOT EXISTS `#__one_email_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `template_id` int NOT NULL,
  `recipient_email` varchar(255) NOT NULL DEFAULT '',
  `recipient_name` varchar(255) NOT NULL DEFAULT '',
  `cc_email` varchar(255) NOT NULL DEFAULT '',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `body` mediumtext NOT NULL,
  `status` enum('sent','failed','pending') NOT NULL DEFAULT 'pending',
  `error_message` text,
  `sent_at` datetime,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_template_id` (`template_id`),
  KEY `idx_status` (`status`),
  KEY `idx_sent_at` (`sent_at`),
  KEY `idx_created` (`created`),
  CONSTRAINT `fk_one_email_logs_template` FOREIGN KEY (`template_id`) REFERENCES `#__one_email_templ` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_unicode_ci;

--
-- Insert default email templates
--

INSERT INTO `#__one_email_templ` (`title`, `email_title`, `email_content`, `entity`, `published`, `language`, `send_to_user`, `send_cc_to_admin`, `created`, `created_by`) VALUES
('Review Approved', 'Your review has been approved - {listing_title}', '<p>Hello {user},</p><p>Thank you for your review!</p><p>Your review for <strong>{listing_title}</strong> has been approved and is now visible on our website.</p><p><strong>Your review:</strong><br><strong>Title:</strong> {review_title}<br><strong>Content:</strong> {review_body}</p><p>You can view the listing here: <a href="{site_url}">{site_url}</a></p><p>Thank you for taking the time to share your experience.</p><p>Best regards,<br>{site_name}</p>', NULL, 1, '*', 1, 0, NOW(), 0);
