<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Comdev\Component\Onecore\Site\Helper\ContentHelper;
use Comdev\Component\Onecore\Site\Helper\RouteHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

/** @var \Comdev\Component\Onecore\Site\View\Content\HtmlView $this */

// Function to limit text by words
if (!function_exists('limitWords')) {
	function limitWords($text, $limit = 30) {
		if (empty($text)) {
			return '';
		}
		
		$text = strip_tags($text);
		$words = explode(' ', $text);
		
		if (count($words) <= $limit) {
			return $text;
		}
		
		$words = array_slice($words, 0, $limit);
		return implode(' ', $words) . '...';
	}
}

// Get Itemid for main content menu (used to build SEF item URLs)
// Not needed - RouteHelper::getItemRoute() handles Itemid automatically
// $contentItemid = null;

// Map data for top map (used by default.php init; data attributes for AJAX reload)
$listMapItems = [];
$listMapZoom = 13;
$listHasMap = false;
$showMap = $this->params->get('show_map', 1);
$mapPositionItems = $this->params->get('map_position_items', 'top');
// Show only items from current page, not all items from database
$itemsForMap = $this->items ?? [];
if ($showMap && $mapPositionItems === 'top' && !empty($itemsForMap)) {
	foreach ($itemsForMap as $it) {
		if (!empty($it->latitude) && !empty($it->longitude)) {
			$listHasMap = true;
			$listMapItems[] = [
				'lat' => (float) $it->latitude,
				'lng' => (float) $it->longitude,
				'title' => $this->escape($it->title ?? ''),
				'url' => Route::_(RouteHelper::getItemRoute($it->id . ':' . ($it->alias ?? '')))
			];
		}
	}
	$listMapZoom = (int) $this->params->get('map_default_zoom', 13);
}
?>
<div class="com-onecore-content content-list one_container one_list" id="onecore-content-list">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header one_header">
			<h1 class="one_page_heading"><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>

	<?php if (!empty($this->items)) : ?>
		<?php if ($listHasMap) : ?>
			<div class="col-12 mb-4">
				<div class="onecore-map-container"
					 id="onecore-map-items-top"
					 style="height: 400px; border: 1px solid #ddd; border-radius: 4px;"
					 data-map-items="<?php echo htmlspecialchars(json_encode($listMapItems), ENT_QUOTES, 'UTF-8'); ?>"
					 data-map-zoom="<?php echo (int) $listMapZoom; ?>"></div>
			</div>
		<?php endif; ?>
		<div class="items-list one_list_items">
			<?php foreach ($this->items as $item) : ?>
				<?php 
				$hasImage = $this->params->get('show_image', 1) && !empty($item->image);
				?>
				<div class="item-row row mb-4 pb-4 border-bottom one_list_row<?php echo !empty($item->featured) ? ' one_list_row--featured' : ''; ?>">
					<?php if ($this->params->get('show_image', 1)) : ?>
						<div class="col-md-3 one_list_image_col">
							<?php 
							$itemUrl = Route::_(RouteHelper::getItemRoute($item->id . ':' . $item->alias));
							?>
							<div class="item-image one_list_image">
								<?php if ($this->params->get('linked_titles', 1)) : ?>
									<a href="<?php echo $itemUrl; ?>" title="<?php echo $this->escape($item->title); ?>" class="one_list_image_link">
								<?php endif; ?>
								<?php if ($hasImage) : ?>
									<?php echo HTMLHelper::_('image', $item->image, $this->escape($item->title), [
										'class' => 'img-fluid one_list_image_img',
										'loading' => 'lazy'
									]); ?>
								<?php else : ?>
									<div class="one_list_image_placeholder img-fluid one_list_image_img">
										<svg class="one_list_placeholder_icon" width="80" height="80" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M21 19V5C21 3.9 20.1 3 19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19ZM8.5 13.5L11 16.51L14.5 12L19 18H5L8.5 13.5Z" fill="currentColor"/>
										</svg>
										<span class="one_list_placeholder_text"><?php echo Text::_('COM_ONECORE_NO_IMAGE') ?: 'No Image'; ?></span>
									</div>
								<?php endif; ?>
								<?php if ($this->params->get('linked_titles', 1)) : ?>
									</a>
								<?php endif; ?>
							</div>
						</div>
					<?php endif; ?>

					<div class="<?php echo ($this->params->get('show_image', 1)) ? 'col-md-9' : 'col-12'; ?> one_list_content_col">
						<?php if ($this->params->get('show_title', 1)) : ?>
							<h3 class="item-title one_list_title">
								<?php if ($this->params->get('linked_titles', 1)) : ?>
									<a href="<?php echo Route::_(RouteHelper::getItemRoute($item->id . ':' . $item->alias)); ?>" class="one_list_title_link">
										<?php echo $this->escape($item->title); ?>
									</a>
								<?php else : ?>
									<span class="one_list_title_text"><?php echo $this->escape($item->title); ?></span>
								<?php endif; ?>
							</h3>
						<?php endif; ?>

						<?php if (!empty($item->customfields_under_title)) : ?>
							<?php foreach ($item->customfields_under_title as $group) : ?>
								<div class="one_customfield_group one_customfield_group--under-title mb-2">
									<?php if (!empty($group->fields)) : ?>
										<div class="one_customfields one_customfields--under-title">
											<?php foreach ($group->fields as $cf) : ?>
												<div class="one_customfield">
													<?php if (!empty($cf->display_label)) : ?>
														<?php if (($cf->label_position ?? 'next') === 'over') : ?>
															<div class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
															<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
														<?php else : ?>
															<span class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
															<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
														<?php endif; ?>
													<?php else : ?>
														<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
													<?php endif; ?>
												</div>
											<?php endforeach; ?>
										</div>
									<?php endif; ?>
								</div>
							<?php endforeach; ?>
						<?php endif; ?>

					<?php if ($this->params->get('show_intro_text', 1) && !empty($item->introtext)) : ?>
						<?php 
						$introLimit = $this->params->get('introtext_limit', 15);
						$introText = limitWords($item->introtext, $introLimit);
						?>
							<div class="item-introtext one_list_introtext">
								<?php echo htmlspecialchars($introText, ENT_QUOTES, 'UTF-8'); ?>
							</div>
						<?php endif; ?>

						<?php if (!empty($item->customfields_under_intro)) : ?>
							<?php foreach ($item->customfields_under_intro as $group) : ?>
								<div class="one_customfield_group one_customfield_group--under-intro mb-2">
									<?php if (!empty($group->fields)) : ?>
										<div class="one_customfields one_customfields--under-intro">
											<?php foreach ($group->fields as $cf) : ?>
												<div class="one_customfield">
													<?php if (!empty($cf->display_label)) : ?>
														<?php if (($cf->label_position ?? 'next') === 'over') : ?>
															<div class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
															<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
														<?php else : ?>
															<span class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
															<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
														<?php endif; ?>
													<?php else : ?>
														<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
													<?php endif; ?>
												</div>
											<?php endforeach; ?>
										</div>
									<?php endif; ?>
								</div>
							<?php endforeach; ?>
						<?php endif; ?>

						<?php if ($this->params->get('show_category', 1) && !empty($item->categories)) : ?>
							<div class="item-categories mt-2 one_list_categories">
								<span class="one_list_categories_label"><?php echo Text::_('JCATEGORY') . ': '; ?></span>
								<?php 
								$categoryNames = [];
								foreach ($item->categories as $category) {
									$categoryNames[] = '<span class="one_list_category_name">' . $this->escape($category->title) . '</span>';
								}
								echo implode(', ', $categoryNames);
								?>
							</div>
						<?php endif; ?>
					</div>
				</div>
			<?php endforeach; ?>
		</div>

		<?php if ($this->params->get('show_pagination', 1) && !empty($this->pagination->pagesTotal) && $this->pagination->pagesTotal > 1) : ?>
			<div class="pagination-wrapper one_pagination">
				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php endif; ?>
	<?php else : ?>
		<div class="alert alert-info one_no_items">
			<p class="one_no_items_text"><?php echo Text::_('COM_ONECORE_NO_ITEMS_FOUND'); ?></p>
		</div>
	<?php endif; ?>
</div>

