<?php
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

/** @var \Comdev\Component\Onecore\Site\View\Categories\HtmlView $this */

$items = is_array($this->items) ? $this->items : [];
?>

<?php if ($this->maxLevelcat != 0 && !empty($items)) : ?>
	<div class="com-onecore-categories-grid">
		<div class="categories-grid row g-3">

			<?php foreach ($items as $item) : ?>
				<?php
				$categoryUrl = Route::_('index.php?option=com_onecore&view=content&layout=grid&id=' . $item->id);

				// Image
				$image = $item->getParams()->get('image') ?: ($item->image ?? null);

				// Children (deduplicate by id)
				$rawChildren = $this->maxLevelcat > 1 ? $item->getChildren() : [];
				$children = [];
				$seenIds = [];
				foreach ($rawChildren as $child) {
					$cid = isset($child->id) ? (int) $child->id : 0;
					if ($cid && !isset($seenIds[$cid])) {
						$seenIds[$cid] = true;
						$children[] = $child;
					}
				}
				?>

				<div class="col-md-4 col-sm-6">
					<div class="category-card card h-100">

						<?php if ($image) : ?>
							<div class="category-image">
								<a href="<?php echo $categoryUrl; ?>">
									<?php echo HTMLHelper::_('image', $image, $this->escape($item->title), [
										'class' => 'card-img-top',
										'loading' => 'lazy'
									]); ?>
								</a>
							</div>
						<?php endif; ?>

						<div class="card-body">

							<h3 class="card-title">
								<a href="<?php echo $categoryUrl; ?>">
									<?php echo $this->escape($item->title); ?>
								</a>
							</h3>

							<?php if ($this->params->get('show_subcat_desc_cat') && !empty($item->description)) : ?>
								<div class="category-description card-text">
									<?php echo HTMLHelper::_('content.prepare', $item->description, '', 'com_onecore.categories'); ?>
								</div>
							<?php endif; ?>

							<?php if ($this->params->get('show_cat_num_articles_cat') && isset($item->numitems)) : ?>
								<div class="category-count">
									<span class="badge bg-info">
										<?php echo Text::_('COM_ONECORE_NUM_ITEMS'); ?>: <?php echo $item->numitems; ?>
									</span>
								</div>
							<?php endif; ?>

							<?php if (!empty($children)) : ?>
								<div class="category-subcategories mt-3">
									<h5><?php echo Text::_('COM_ONECORE_SUBCATEGORIES'); ?>:</h5>

									<ul class="list-unstyled">
										<?php foreach ($children as $child) : ?>
											<li>
												<a href="<?php echo Route::_('index.php?option=com_onecore&view=content&layout=grid&id=' . $child->id); ?>">
													<?php echo $this->escape($child->title); ?>
												</a>

												<?php if ($this->params->get('show_cat_num_articles_cat') && isset($child->numitems)) : ?>
													<small class="text-muted">
														(<?php echo $child->numitems; ?>)
													</small>
												<?php endif; ?>
											</li>
										<?php endforeach; ?>
									</ul>
								</div>
							<?php endif; ?>

						</div>
					</div>
				</div>

			<?php endforeach; ?>

		</div>
	</div>

<?php else : ?>

	<p><?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?></p>

<?php endif; ?>
