<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Site\View\Categories;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\CategoriesView;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Content categories view.
 *
 * @since  1.0.0
 */
class HtmlView extends CategoriesView
{
	/**
	 * Language key for default page heading
	 *
	 * @var    string
	 * @since  1.0.0
	 */
	protected $pageHeading = 'COM_ONECORE_CATEGORIES';

	/**
	 * @var    string  The name of the extension for the category
	 * @since  1.0.0
	 */
	protected $extension = 'com_onecore';

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  void|boolean
	 *
	 * @since   1.0.0
	 * @throws  \Exception
	 */
	public function display($tpl = null)
	{
		$errors = $this->get('Errors');
		if ($errors === null) {
			$this->set('Errors', []);
		}

		$items = $this->get('Items');
		if ($items === null) {
			$items = [];
			$this->set('Items', $items);
		} elseif ($items === false) {
			$items = [];
			$this->set('Items', $items);
		}

		$state  = $this->get('State');
		$parent = $this->get('Parent');
		$app    = Factory::getApplication();

		if (\count($errors = $this->get('Errors'))) {
			$app->enqueueMessage($errors, 'error');
			return false;
		}
		if ($items === false) {
			$app->enqueueMessage(Text::_('JGLOBAL_CATEGORY_NOT_FOUND'), 'error');
			return false;
		}
		if ($parent === null) {
			$app->enqueueMessage(Text::_('JGLOBAL_CATEGORY_NOT_FOUND'), 'error');
			return false;
		}

		$params = $state->get('params');
		$this->pageclass_sfx = htmlspecialchars($params->get('pageclass_sfx', ''), ENT_COMPAT, 'UTF-8');
		$this->maxLevelcat  = $params->get('maxLevelcat', -1) < 0 ? PHP_INT_MAX : $params->get('maxLevelcat', PHP_INT_MAX);
		$this->params       = $params;
		$this->parent       = $parent;
		// Flat list for template (no [parentId => items] wrap)
		$this->items        = \is_array($items) ? $items : [];

		$this->prepareDocument();

		$this->getDocument()->getWebAssetManager()
			->registerAndUseStyle('com_onecore.categories', 'components/com_onecore/assets/css/categories.css');

		BaseHtmlView::display($tpl);
	}
}
