<?php

namespace Comdev\Component\Onecore\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Categories\Categories;
use Joomla\CMS\Categories\CategoryNode;
use Joomla\Registry\Registry;

class CategoriesModel extends ListModel
{
	protected $_context = 'com_onecore.categories';
	protected $_extension = 'com_onecore';

	/** @var CategoryNode|null */
	private $_parent = null;

	/** @var CategoryNode[] */
	private $_items = [];

	/**
	 * Auto populate state
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = Factory::getApplication();

		$this->setState('filter.extension', $this->_extension);
		$this->setState('filter.published', 1);
		$this->setState('filter.access', true);

		// Parent ID priority:
		// 1. URL
		// 2. Menu root_category
		// 3. GLOBAL ROOT = 1
		$parentId = $app->getInput()->getInt('id');

		if (!$parentId) {
			$active = $app->getMenu()->getActive();

			if ($active) {
				$rootCategory = (int) $active->getParams()->get('root_category');

				if ($rootCategory > 0) {
					$parentId = $rootCategory;
				}
			}
		}

		// NEVER use 'root'
		if (!$parentId) {
			$parentId = 1;
		}

		$this->setState('filter.parentId', (int) $parentId);

		$params = $app->getParams();
		$this->setState('params', $params);
	}

	/**
	 * Store ID (important for cache correctness)
	 */
	protected function getStoreId($id = '')
	{
		$id .= ':' . $this->getState('filter.extension');
		$id .= ':' . $this->getState('filter.published');
		$id .= ':' . $this->getState('filter.access');
		$id .= ':' . (int) $this->getState('filter.parentId');

		return parent::getStoreId($id);
	}

	/**
	 * Get categories
	 */
	public function getItems()
	{
		if ($this->_items !== []) {
			return $this->_items;
		}

		$options = [
			'countItems' => true,
			'access'     => true,
			'published'  => 1,
		];

		// Uses #__one_categories via Service/Category.php (Categories::getInstance → component CategoryFactory)
		$categories = Categories::getInstance('com_onecore', $options);

		$parentId = (int) $this->getState('filter.parentId', 1);

		$this->_parent = $categories->get($parentId);

		if (!$this->_parent instanceof CategoryNode) {
			$this->_items = [];
			return $this->_items;
		}

		$children = $this->_parent->getChildren();

		// Deduplicate by id (one_categories via Service/Category.php; avoid same category twice)
		$seen = [];
		$unique = [];
		foreach ($children as $node) {
			$id = isset($node->id) ? (int) $node->id : 0;
			if ($id && !isset($seen[$id])) {
				$seen[$id] = true;
				$unique[] = $node;
			}
		}

		$this->_items = array_values($unique);

		return $this->_items;
	}

	/**
	 * Get parent category
	 */
	public function getParent()
	{
		if (!$this->_parent instanceof CategoryNode) {
			$this->getItems();
		}

		return $this->_parent;
	}
}
