<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Site\Helper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Content Component Route Helper.
 *
 * @since  1.0.0
 */
abstract class RouteHelper
{
	/**
	 * Get the item route.
	 *
	 * @param   string|int  $id        The route of the content item (slug "id:alias" or numeric id).
	 * @param   string      $language  The language code.
	 *
	 * @return  string  The item route.
	 *
	 * @since   1.0.0
	 */
	public static function getItemRoute($id, $language = null)
	{
		// Create the link
		$link = 'index.php?option=com_onecore&view=item&id=' . $id;

		if (!empty($language) && $language !== '*' && \Joomla\CMS\Language\Multilanguage::isEnabled()) {
			$link .= '&lang=' . $language;
		}

		return $link;
	}

	/**
	 * Get the event route.
	 *
	 * @param   string|int  $id        The route of the event item (slug "id:alias" or numeric id).
	 * @param   string      $language  The language code.
	 *
	 * @return  string  The event route.
	 *
	 * @since   1.0.0
	 */
	public static function getEventRoute($id, $language = null)
	{
		// Create the link
		$link = 'index.php?option=com_onecore&view=event&id=' . $id;

		if (!empty($language) && $language !== '*' && \Joomla\CMS\Language\Multilanguage::isEnabled()) {
			$link .= '&lang=' . $language;
		}

		return $link;
	}

	/**
	 * Get the content list route.
	 *
	 * @param   string  $language  The language code.
	 *
	 * @return  string  The content list route.
	 *
	 * @since   1.0.0
	 */
	public static function getContentRoute($language = null)
	{
		$link = 'index.php?option=com_onecore&view=content';

		if (!empty($language) && $language !== '*' && \Joomla\CMS\Language\Multilanguage::isEnabled()) {
			$link .= '&lang=' . $language;
		}

		return $link;
	}

	/**
	 * Get the events list route.
	 *
	 * @param   string  $language  The language code.
	 *
	 * @return  string  The events list route.
	 *
	 * @since   1.0.0
	 */
	public static function getEventsRoute($language = null)
	{
		$link = 'index.php?option=com_onecore&view=events';

		if (!empty($language) && $language !== '*' && \Joomla\CMS\Language\Multilanguage::isEnabled()) {
			$link .= '&lang=' . $language;
		}

		return $link;
	}
}
