<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Site\Controller;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Response\JsonResponse;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Suggestions controller for autocomplete
 *
 * @since  1.0.0
 */
class SuggestionsController extends BaseController
{
	/**
	 * Get search suggestions for autocomplete
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	public function suggest()
	{
		$app = Factory::getApplication();
		$input = $app->getInput();
		$query = $input->getString('q', '');

		// Set JSON response header
		$app->setHeader('Content-Type', 'application/json', true);

		// Validate query length
		if (strlen($query) < 2) {
			echo new JsonResponse([]);
			$app->close();
		}

		try {
			// Get helper from module
			$helper = $app->bootModule('mod_onecore_search', 'site')->getHelper('SearchHelper');
			
			// Get suggestions
			$suggestions = $helper->getSuggestions($query, 10);

			// Format response
			$response = [];
			foreach ($suggestions as $item) {
				$response[] = [
					'id' => $item->id,
					'title' => $item->title,
					'alias' => $item->alias,
				];
			}

			echo new JsonResponse($response);
		} catch (\Exception $e) {
			echo new JsonResponse([]);
		}

		$app->close();
	}
}
