<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Site\Controller;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Content Controller
 *
 * @since  1.0.0
 */
class ContentController extends BaseController
{
	/**
	 * Display method for AJAX requests
	 *
	 * @return  void
	 */
	public function display($cachable = false, $urlparams = [])
	{
		$app = Factory::getApplication();
		$input = $app->getInput();
		
		// Check if this is an AJAX request
		if ($input->get('X-Requested-With') === 'XMLHttpRequest' || $input->server->get('HTTP_X_REQUESTED_WITH') === 'XMLHttpRequest') {
			$view = $this->getView('Content', 'html');
			$model = $this->getModel('Content');
			
			$view->setModel($model, true);
			$view->display();
			
			$app->close();
		}
		
		parent::display($cachable, $urlparams);
	}
}
