<?php
/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

/** @var array $displayData */
$item = $displayData['item'] ?? null;
$type = $displayData['type'] ?? 'content'; // 'content' or 'event'
$showFacebook = (int) ($displayData['show_facebook'] ?? 1) === 1;
$showInstagram = (int) ($displayData['show_instagram'] ?? 1) === 1;
$showPinterest = (int) ($displayData['show_pinterest'] ?? 1) === 1;

if (!$item || (!$showFacebook && !$showInstagram && !$showPinterest)) {
	return;
}

$currentUrl = Uri::getInstance()->toString();
$title = htmlspecialchars($item->title ?? '', ENT_QUOTES, 'UTF-8');
$description = htmlspecialchars(strip_tags($item->description ?? $item->introtext ?? ''), ENT_QUOTES, 'UTF-8');
$description = mb_substr($description, 0, 200);

// Get image for sharing
$imageUrl = '';
if (!empty($item->images)) {
	$images = json_decode($item->images);
	if (!empty($images->image_intro)) {
		$imageUrl = Uri::root() . ltrim($images->image_intro, '/');
	} elseif (!empty($images->image_fulltext)) {
		$imageUrl = Uri::root() . ltrim($images->image_fulltext, '/');
	}
}

$facebookUrl = 'https://www.facebook.com/sharer/sharer.php?u=' . urlencode($currentUrl);
$pinterestUrl = 'https://pinterest.com/pin/create/button/?url=' . urlencode($currentUrl) . '&description=' . urlencode($title);
if ($imageUrl) {
	$pinterestUrl .= '&media=' . urlencode($imageUrl);
}
?>

<div class="onecore-social-share onecore-social-share--icons mb-4">
	<div class="d-flex gap-2 flex-wrap">
		<?php if ($showFacebook) : ?>
			<a href="<?php echo $facebookUrl; ?>" 
			   target="_blank" 
			   rel="noopener noreferrer" 
			   class="btn btn-primary btn-sm onecore-share-btn onecore-share-facebook"
			   title="<?php echo Text::_('COM_ONECORE_SHARE_FACEBOOK'); ?>"
			   aria-label="<?php echo Text::_('COM_ONECORE_SHARE_FACEBOOK'); ?>">
				<i class="fab fa-facebook-f" aria-hidden="true"></i>
			</a>
		<?php endif; ?>
		<?php if ($showInstagram) : ?>
			<a href="https://www.instagram.com/" 
			   target="_blank" 
			   rel="noopener noreferrer" 
			   class="btn btn-danger btn-sm onecore-share-btn onecore-share-instagram"
			   title="<?php echo Text::_('COM_ONECORE_SHARE_INSTAGRAM'); ?>"
			   aria-label="<?php echo Text::_('COM_ONECORE_SHARE_INSTAGRAM'); ?>"
			   onclick="alert('<?php echo addslashes(Text::_('COM_ONECORE_SHARE_INSTAGRAM_INFO')); ?>'); return false;">
				<i class="fab fa-instagram" aria-hidden="true"></i>
			</a>
		<?php endif; ?>
		<?php if ($showPinterest) : ?>
			<a href="<?php echo $pinterestUrl; ?>" 
			   target="_blank" 
			   rel="noopener noreferrer" 
			   class="btn btn-danger btn-sm onecore-share-btn onecore-share-pinterest"
			   title="<?php echo Text::_('COM_ONECORE_SHARE_PINTEREST'); ?>"
			   aria-label="<?php echo Text::_('COM_ONECORE_SHARE_PINTEREST'); ?>">
				<i class="fab fa-pinterest" aria-hidden="true"></i>
			</a>
		<?php endif; ?>
	</div>
</div>
