<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Comdev\Component\Onecore\Site\Helper\ReviewsHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

$item    = $displayData['item'] ?? null;
$type    = $displayData['type'] ?? 'content'; // 'content' | 'event'
$reviews = $displayData['reviews'] ?? [];
$rating  = $displayData['averageRating'] ?? (object) ['average' => 0.0, 'count' => 0];
$params  = $displayData['params'] ?? null;
$canSubmit = $displayData['canSubmit'] ?? false;
$returnUrl = $displayData['returnUrl'] ?? '';

if (!$item || !$params) {
	return;
}

$contentId = ($type === 'content') ? (int) $item->id : 0;
$eventId   = ($type === 'event') ? (int) $item->id : 0;
$submitUrl = Route::_('index.php?option=com_onecore&task=submitReview');
?>

<div class="onecore-reviews-block card mb-4">
	<div class="card-body">
		<h3 class="card-title h5 mb-3"><?php echo Text::_('COM_ONECORE_REVIEWS'); ?></h3>

		<?php if ($rating->count > 0) : ?>
			<div class="onecore-reviews-summary mb-3">
				<span class="onecore-reviews-stars" aria-label="<?php echo Text::sprintf('COM_ONECORE_REVIEWS_AVERAGE_RATING', $rating->average); ?>">
					<?php
					$full = (int) floor($rating->average);
					$half = ($rating->average - $full) >= 0.5;
					echo str_repeat('★', $full);
					if ($half) {
						echo '½';
					}
					echo str_repeat('☆', 5 - $full - ($half ? 1 : 0));
					?>
				</span>
				<span class="onecore-reviews-average ms-2"><?php echo number_format($rating->average, 1); ?></span>
				<span class="onecore-reviews-count text-muted small ms-2">(<?php echo Text::sprintf('COM_ONECORE_REVIEWS_COUNT', $rating->count); ?>)</span>
			</div>
		<?php endif; ?>

		<?php if (!empty($reviews)) : ?>
			<div class="onecore-reviews-list mb-4">
				<?php foreach ($reviews as $review) : ?>
					<div class="onecore-review-item border-bottom pb-3 mb-3">
						<div class="d-flex justify-content-between align-items-start">
							<strong class="onecore-review-name"><?php echo htmlspecialchars($review->name ?? ''); ?></strong>
							<span class="onecore-review-rating text-warning" aria-hidden="true"><?php echo str_repeat('★', (int) ($review->rating ?? 0)) . str_repeat('☆', 5 - (int) ($review->rating ?? 0)); ?></span>
						</div>
						<?php if (!empty($review->title)) : ?>
							<div class="onecore-review-title fw-bold small mt-1"><?php echo htmlspecialchars($review->title); ?></div>
						<?php endif; ?>
						<div class="onecore-review-body mt-1"><?php echo nl2br(htmlspecialchars($review->body ?? '')); ?></div>
						<div class="onecore-review-date text-muted small mt-1"><?php echo $review->created ? HTMLHelper::_('date', $review->created, Text::_('DATE_FORMAT_LC3')) : ''; ?></div>
					</div>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>

		<?php if ($canSubmit) : ?>
			<div class="onecore-reviews-form">
				<h4 class="h6 mb-2"><?php echo Text::_('COM_ONECORE_REVIEWS_NEW'); ?></h4>
				<form action="<?php echo $submitUrl; ?>" method="post" class="onecore-review-form form-validate">
					<?php echo HTMLHelper::_('form.token'); ?>
					<input type="hidden" name="task" value="submitReview">
					<?php if ($returnUrl) : ?>
						<input type="hidden" name="return" value="<?php echo base64_encode($returnUrl); ?>">
					<?php endif; ?>
					<?php if ($contentId) : ?>
						<input type="hidden" name="content_id" value="<?php echo $contentId; ?>">
					<?php else : ?>
						<input type="hidden" name="event_id" value="<?php echo $eventId; ?>">
					<?php endif; ?>
					<div class="mb-2">
						<label for="onecore-review-name" class="form-label"><?php echo Text::_('COM_ONECORE_REVIEW_NAME'); ?> <span class="text-danger">*</span></label>
						<input type="text" name="name" id="onecore-review-name" class="form-control" required maxlength="255" value="">
					</div>
					<div class="mb-2">
						<label for="onecore-review-email" class="form-label"><?php echo Text::_('COM_ONECORE_REVIEW_EMAIL'); ?> <span class="text-danger">*</span></label>
						<input type="email" name="email" id="onecore-review-email" class="form-control" required maxlength="255" value="">
					</div>
					<div class="mb-2">
						<label for="onecore-review-title" class="form-label"><?php echo Text::_('COM_ONECORE_REVIEW_TITLE'); ?></label>
						<input type="text" name="title" id="onecore-review-title" class="form-control" maxlength="255" value="">
					</div>
					<div class="mb-2">
						<label class="form-label"><?php echo Text::_('COM_ONECORE_REVIEW_RATING'); ?> <span class="text-danger">*</span></label>
						<div class="onecore-review-rating-stars d-flex flex-wrap align-items-center gap-2">
							<?php for ($i = 1; $i <= 5; $i++) : ?>
								<label class="onecore-rating-option d-flex align-items-center gap-1 mb-0">
									<input type="radio" name="rating" value="<?php echo $i; ?>" required class="form-check-input">
									<span class="text-warning" aria-hidden="true">★</span>
									<span class="onecore-rating-num small"><?php echo $i; ?></span>
								</label>
							<?php endfor; ?>
						</div>
					</div>
					<div class="mb-3">
						<label for="onecore-review-body" class="form-label"><?php echo Text::_('COM_ONECORE_REVIEW_BODY'); ?> <span class="text-danger">*</span></label>
						<textarea name="body" id="onecore-review-body" class="form-control" required rows="4" maxlength="2000"></textarea>
					</div>
					<button type="submit" class="btn btn-primary"><?php echo Text::_('COM_ONECORE_REVIEWS_SUBMIT'); ?></button>
				</form>
			</div>
		<?php endif; ?>
	</div>
</div>
