<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;

/**
 * Custom fields block (sidebar style). Data via $displayData.
 *
 * Keys: groups, layout.
 */

$displayData = $displayData ?? [];
$groups = $displayData['groups'] ?? [];
$layout = $displayData['layout'] ?? 'sidebar';

if (empty($groups) || !is_array($groups)) {
	return;
}
$modifier = 'one_customfield_group--' . $layout;
?>
<?php foreach ($groups as $group) : ?>
	<div class="one_customfield_group <?php echo $modifier; ?> mb-4">
		<?php if (!empty($group->show_title) && !empty($group->title)) : ?>
			<h4 class="one_customfield_group_title fw-bold mb-2"><?php echo htmlspecialchars((string) $group->title, ENT_QUOTES, 'UTF-8'); ?></h4>
		<?php endif; ?>
		<?php if (!empty($group->show_description) && !empty($group->description)) : ?>
			<div class="one_customfield_group_description mb-4"><?php echo HTMLHelper::_('content.prepare', $group->description, '', 'com_onecore.customfieldgroup'); ?></div>
		<?php endif; ?>
		<?php if (!empty($group->fields)) : ?>
			<div class="one_customfields one_customfields--<?php echo $layout; ?>">
				<?php foreach ($group->fields as $cf) : ?>
					<div class="one_customfield mb-2">
						<?php if (!empty($cf->display_label)) : ?>
							<?php if (($cf->label_position ?? 'next') === 'over') : ?>
								<div class="one_customfield_label fw-bold">
									<?php if (!empty($cf->icon)) : ?>
										<i data-feather="<?php echo htmlspecialchars($cf->icon, ENT_QUOTES, 'UTF-8'); ?>" class="one_customfield_icon me-1" aria-hidden="true"></i>
									<?php endif; ?>
									<?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>
								</div>
								<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
							<?php else : ?>
								<span class="one_customfield_label fw-bold">
									<?php if (!empty($cf->icon)) : ?>
										<i data-feather="<?php echo htmlspecialchars($cf->icon, ENT_QUOTES, 'UTF-8'); ?>" class="one_customfield_icon me-1" aria-hidden="true"></i>
									<?php endif; ?>
									<?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:
								</span>
								<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
							<?php endif; ?>
						<?php else : ?>
							<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
						<?php endif; ?>
					</div>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>
	</div>
<?php endforeach; ?>
