<?php
/**
 * Script to add Import/Export menu item to OneCore component
 * 
 * Run this script once to add the menu item to the database.
 * After running, you can delete this file.
 * 
 * Usage: php add_importexport_menu.php
 */

// Define Joomla constants
define('_JEXEC', 1);
define('JPATH_BASE', dirname(dirname(dirname(dirname(__FILE__)))));
define('JPATH_ADMINISTRATOR', JPATH_BASE . '/administrator');

// Load Joomla framework
require_once JPATH_BASE . '/includes/app.php';

// Get application
$app = \Joomla\CMS\Factory::getApplication('administrator');

// Get database
$db = \Joomla\CMS\Factory::getDbo();

try {
	// Find parent menu (OneCore main menu)
	$query = $db->getQuery(true)
		->select('id')
		->from($db->quoteName('#__menu'))
		->where($db->quoteName('menutype') . ' = ' . $db->quote('main'))
		->where($db->quoteName('client_id') . ' = 1')
		->where($db->quoteName('parent_id') . ' = 1')
		->where($db->quoteName('link') . ' LIKE ' . $db->quote('%option=com_onecore%'))
		->where($db->quoteName('type') . ' = ' . $db->quote('component'))
		->setLimit(1);
	
	$db->setQuery($query);
	$parentId = $db->loadResult();
	
	if (!$parentId) {
		echo "ERROR: Parent menu item (OneCore) not found!\n";
		exit(1);
	}
	
	echo "Found parent menu ID: $parentId\n";
	
	// Get component ID
	$query = $db->getQuery(true)
		->select('extension_id')
		->from($db->quoteName('#__extensions'))
		->where($db->quoteName('element') . ' = ' . $db->quote('com_onecore'))
		->where($db->quoteName('type') . ' = ' . $db->quote('component'))
		->setLimit(1);
	
	$db->setQuery($query);
	$componentId = $db->loadResult();
	
	if (!$componentId) {
		echo "ERROR: Component ID not found!\n";
		exit(1);
	}
	
	echo "Found component ID: $componentId\n";
	
	// Check if menu item already exists
	$query = $db->getQuery(true)
		->select('id')
		->from($db->quoteName('#__menu'))
		->where($db->quoteName('menutype') . ' = ' . $db->quote('main'))
		->where($db->quoteName('client_id') . ' = 1')
		->where($db->quoteName('link') . ' = ' . $db->quote('index.php?option=com_onecore&view=importexport'))
		->setLimit(1);
	
	$db->setQuery($query);
	$existingId = $db->loadResult();
	
	if ($existingId) {
		echo "INFO: Menu item already exists (ID: $existingId)\n";
		exit(0);
	}
	
	// Create menu item using Menu table
	$table = new \Joomla\CMS\Table\Menu($db);
	
	// Set location (as last child of parent)
	$table->setLocation($parentId, 'last-child');
	
	// Prepare menu item data
	$data = [
		'menutype'     => 'main',
		'title'        => 'COM_ONECORE_IMPORT_EXPORT',
		'alias'        => 'import-export',
		'type'         => 'component',
		'link'         => 'index.php?option=com_onecore&view=importexport',
		'component_id' => (int) $componentId,
		'parent_id'    => (int) $parentId,
		'client_id'    => 1,
		'published'    => 1,
		'access'       => 1,
		'language'     => '*',
		'home'         => 0,
		'img'          => 'class:upload',
		'params'       => '{}',
		'browserNav'   => 0,
	];
	
	// Bind data
	if (!$table->bind($data)) {
		echo "ERROR: Bind failed - " . $table->getError() . "\n";
		exit(1);
	}
	
	// Check data
	if (!$table->check()) {
		echo "ERROR: Check failed - " . $table->getError() . "\n";
		exit(1);
	}
	
	// Store menu item
	if (!$table->store()) {
		echo "ERROR: Store failed - " . $table->getError() . "\n";
		exit(1);
	}
	
	// Rebuild menu path
	$table->rebuildPath($table->id);
	
	echo "SUCCESS: Menu item added successfully (ID: {$table->id})\n";
	echo "You can now delete this file.\n";
	
} catch (\Exception $e) {
	echo "ERROR: " . $e->getMessage() . "\n";
	exit(1);
}
