# Changelog (com_onecore)

All notable changes to **com_onecore** will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/).

## [Released]

## [1.0.19] - 2026-02-03

### Added
- **Email notification on review approval** - Automatic email sending when review status is changed to "approved". Uses email template "Review Approved" with variable replacement ({user}, {user_email}, {listing_title}, {event_title}, {review_title}, {review_body}, {site_name}, {site_url}). Emails are logged to `#__one_email_logs` table.
- **EmailHelper class** - New helper class (`Administrator\Helper\EmailHelper`) for sending emails using email templates. Handles template loading, variable replacement, email sending via Joomla Mailer, and logging to email logs table.
- **Email menu reorganization** - New menu structure: "Emails" as parent menu item under OneCore, with "Email Templates" and "Email Logs" as submenu items. Menu structure is created automatically during component installation/update via SQL script `1.0.19.sql`.
- Language strings: `COM_ONECORE_REVIEWS_N_ITEMS_PUBLISHED`, `COM_ONECORE_REVIEWS_N_ITEMS_UNPUBLISHED` (EN/PL).

### Changed
- **Email menu structure** - Reorganized from flat menu to hierarchical structure:
  - Emails (parent, level 2, child of OneCore)
    - Email Templates (submenu, level 3)
    - Email Logs (submenu, level 3)
- **Email Templates controller** - Added `preview()` method for AJAX preview functionality. Added `cancel()` method override to fix "Invalid controller class" error. Registered tasks: `emailtemplates.preview`, `emailtemplate.preview`, `emailtemplate.cancel`, `emailtemplates.cancel`.
- **Email Templates view** - Added Bootstrap modal script loading via WebAssetManager. Improved preview modal JavaScript with proper Bootstrap Modal API usage and error handling.

### Fixed
- **Preview modal error** - Fixed "bootstrap.Modal is not a constructor" error by loading Bootstrap modal script via WebAssetManager and using `window.bootstrap.Modal` API correctly.
- **Cancel button error** - Fixed "Invalid controller class: emailtemplate" error by registering `emailtemplate.cancel` and `emailtemplates.cancel` tasks and adding `cancel()` method override in EmailtemplatesController.
- **Email menu visibility** - Fixed menu structure so "Emails" appears as submenu under OneCore instead of separate top-level menu item. Updated SQL script to properly set parent_id, level, and path values.

### Removed
- **Unnecessary CSS for submenu padding** - Removed CSS rules for `ul.collapse-level-3.mm-collapse.mm-show` padding as they are no longer needed. Methods `addAdminMenuCSS()` and `addGlobalAdminMenuCSS()` are now empty but kept for backward compatibility.

## [1.0.15] - 2026-01-30

### Added
- **Custom field groups required** – When no custom field groups exist, the custom field edit form shows an info message with a link to add a group first instead of an empty Group select.
- Language strings: `COM_ONECORE_CUSTOMFIELD_ADD_GROUP_FIRST`, `COM_ONECORE_CUSTOMFIELD_ADD_GROUP_LINK` (EN/PL).

### Changed
- **Categories (frontend)** – View passes a flat list of categories to the template; template uses `$items = is_array($this->items) ? $this->items : []`. Categories view overrides `display()` and sets `$this->items` as flat array (no `[parentId => items]` wrap).
- **Categories model** – Uses `#__one_categories` via `Service/Category.php`; `filter.parentId` defaults to `1` (ROOT); children are deduplicated by id before return.
- **Categories template** – Subcategories list deduplicated by id; empty categories are no longer skipped so all ROOT children are shown.
- **Category images** – Main/parent category image taken from `$item->getParams()->get('image')` so JSON params are correctly read.

### Fixed
- Backend categories list showed only first page of tree; set `list.limit = 0` so full category tree is displayed.
- Category images not showing for main (parent) categories; fixed by using `getParams()` for Registry.
- Duplicate category cards (e.g. sub1 twice); fixed by deduplicating items and children by id in model and template.
- Frontend category view wrong/missing structure; fixed by flat items and correct ROOT children.

## [1.0.14] - 2026-01-30

### Added
- **Events list search/filter** - search form on administrator events list (option=com_onecore&view=events), same as content list: search field, status, featured, category, access, sort and limit. New `forms/filter_events.xml` and filter logic in EventsModel (search, published, category_id, featured, access).
- **Event date/time icons** - YOOtheme/UIkit calendar and clock icons next to event start/end date and time on single event page.
- **Social share in sidebar** - share block moved from main content to sidebar on single event and single item pages. Icons-only display (no text labels).
- **Component Options for share** - new settings in Options: Event Blocks – "Share (sidebar)" show/order; Item Blocks – "Share (sidebar)" show/order; new "Social Share" fieldset with Facebook, Instagram, Pinterest show/hide. Language strings (EN/PL) for new options.
- **External CSS assets** - all inline `<style>` blocks moved to `components/com_onecore/assets/css/`: event.css, item.css, content-list.css, content-grid.css, event-attend.css, social-share.css. Views register and load these via WebAssetManager.

### Changed
- Social share layout: icons only; respects Options (share_show_facebook, share_show_instagram, share_show_pinterest). Share block added as sidebar block with configurable order.
- CSS registration paths updated to `components/com_onecore/assets/css/...` so Joomla loads files from component folder (fixes slider and other styles when not using media folder).
- Slider (item/event): increased specificity and z-index for prev/next buttons so they remain clickable with template CSS.

### Fixed
- **Parse error on single event page** - typo in event default template: `<?php endif; ?` corrected to `<?php endif; ?>`.
- **Slider prev/next arrows not working on single item** - CSS was not loaded because asset paths pointed to media; fixed by using `components/com_onecore/assets/css/` paths in all View style registration.

## [1.0.13]

### Added
- **Import/Export functionality** - new feature to import and export content and events to/from CSV format.
- Import/Export menu item in component administration menu.
- CSV export with support for:
  - Content items and Events
  - Categories exported as path/slug (comma-separated for multiple categories)
  - Custom fields as separate columns (prefixed with 'cf_')
  - Multiple values for custom fields separated by pipe (|)
  - All standard fields (title, alias, introtext, fulltext, metadata, etc.)
- CSV import with support for:
  - Creating new items or updating existing ones (based on ID)
  - Category assignment by path/slug
  - Custom field values (including multiple values)
  - Automatic alias generation from title if not provided
- UTF-8 BOM support in exported CSV files for proper Excel compatibility.
- **Social Share Buttons** - Facebook, Instagram, and Pinterest share buttons for content items and events.
- **Event Attend Functionality** - "Attend: Yes/No" button with attendee counter for events.
- New `attendees_count` column in `#__one_events` table to track number of attendees.
- New `#__one_event_attendees` table to track which users are attending events (for logged-in users).
- Session-based attendance tracking for guest users.

### Changed
- License settings tab renamed from "General Settings" to "License" and moved to last position before Permissions tab.

## [1.0.12]

### Added
- **Calendar view** for Events list - users can now switch between list and calendar view using toggle buttons.
- FullCalendar integration with month, week, and list views.
- View preference persistence using localStorage - selected view (list/calendar) is remembered across page reloads.
- Button height adjustment in event view controls (44px for better touch accessibility).
- **Radio Button field type** for Custom Fields - new field type that displays options as radio buttons in edit forms. Works similarly to Select field but with radio button UI. Supports value|Label format for options. Values are automatically converted to labels on frontend display.

### Changed
- Events list now includes interactive view toggle buttons with icons (list/calendar).
- Sort dropdown is now hidden when calendar view is active (only visible in list view).

## [1.0.11]

### Added
- Metadata fields for Content: **Author**, **Robots**, **Content Rights** (xreference).
- Metadata fields for Events: **Author**, **Robots**, **Content Rights** (xreference).
- New columns in `#__one_content` table: `author`, `robots`, `xreference`.
- New columns in `#__one_events` table: `author`, `robots`, `xreference`.
- **Publishing** tab in Content and Events edit forms with creation/modification info.
- **Metadata** tab in Content and Events edit forms with SEO fields.
- Language strings for metadata fields: `JGLOBAL_FIELD_AUTHOR_LABEL`, `JGLOBAL_FIELD_AUTHOR_DESC`, `JGLOBAL_FIELD_XREFERENCE_LABEL`, `JGLOBAL_FIELD_XREFERENCE_DESC` (EN/PL).
- Language strings for publishing fields: `JGLOBAL_FIELD_VERSION_LABEL`, `JGLOBAL_FIELD_CREATED_LABEL`, `JGLOBAL_FIELD_CREATED_BY_LABEL`, `JGLOBAL_FIELD_MODIFIED_LABEL`, `JGLOBAL_FIELD_MODIFIED_BY_LABEL`, `JGLOBAL_FIELD_PUBLISH_UP_LABEL`, `JGLOBAL_FIELD_PUBLISH_DOWN_LABEL`, `JGLOBAL_FIELD_ID_LABEL`, `JGLOBAL_HITS`, `JGLOBAL_FIELDSET_PUBLISHING`, `JGLOBAL_FIELDSET_METADATA_OPTIONS` (EN/PL).


### Changed
- Reorganized form fields into proper fieldsets: default, publishing, metadata.
- Publishing fields (publish_up, publish_down, created, modified, etc.) moved to Publishing tab.
- Metadata fields (metadesc, metakey, author, robots, xreference) moved to Metadata tab.
- Content edit.php and Events edit.php: added explicit rendering of Publishing and Metadata tabs.
- **Map marker icon** - updated to new 128x128px square design (11 KB). Added cache busting with file modification timestamp (`?v=timestamp`) to ensure browser always loads the latest version. Adjusted Leaflet icon settings for square proportions (48x48 display size).

### Fixed
- **Content fulltext and introtext**: now properly rendered with `HTMLHelper::_('content.prepare')` to display HTML tags and process Joomla content plugins correctly.
- **Pagination not displaying in grid/list views**: fixed by adding `default="1"` to `show_pagination` parameter in menu XML and improving the display condition to properly check for multiple pages (`pagesTotal > 1`).

## [1.0.10]

### Added
- Events list: added **Recurrence (Yes/No)** column based on `#__one_event_recurrences`.
- Dashboard stat cards: replaced pseudo-icons with per-card SVG icons.

### Changed
- Installer script: fixed Joomla installer detection by using class name `Com_OnecoreInstallerScript` and registering `<scriptfile>script.php</scriptfile>` in `administrator/components/com_onecore/onecore.xml`.
- Installer logging: write to `administrator/logs/onecore-install.log` (more reliable than site root).
- Recurrence edit UI: `recurrence_enabled` rendered as a Bootstrap button group (Yes/No).




