<?php

/**
 * @package     Comdev.Module
 * @subpackage  mod_onecore_search_events
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

/** @var \stdClass $module */
/** @var \Joomla\Registry\Registry $params */
/** @var object $app */
/** @var \Joomla\Input\Input $input */
/** @var string $template */

// Variables are extracted from displayData by AbstractModuleDispatcher
// Available variables: $module, $params, $app, $input, $template
// Plus custom variables from Dispatcher: $helper, $categories, $authors, etc.

// Initialize default values if not set
$helper = $helper ?? null;
$categories = $categories ?? [];
$searchableCustomFields = $searchableCustomFields ?? [];
$currentCustomFields = $currentCustomFields ?? [];
$formAction = $formAction ?? ($app->get('live_site') ?: '') . '/index.php?option=com_onecore&view=events';
$currentSearch = $currentSearch ?? '';
$currentCategories = $currentCategories ?? [];
$currentSort = $currentSort ?? 'newest';
$currentDateFrom = $currentDateFrom ?? '';
$currentDateTo = $currentDateTo ?? '';
$currentFeatured = $currentFeatured ?? 0;
$moduleClassSfx = $moduleClassSfx ?? '';
$showSearch = $showSearch ?? 1;
$showAutosuggest = $showAutosuggest ?? 1;
$showCategory = $showCategory ?? 1;
$showSort = $showSort ?? 1;
$showDate = $showDate ?? 1;
$showFeatured = $showFeatured ?? 0;
$showAdvanced = $showAdvanced ?? 0;
$showCustomFields = $showCustomFields ?? 1;

// Load assets
$wa = $app->getDocument()->getWebAssetManager();
$wa->registerAndUseStyle('mod_onecore_search_events', 'mod_onecore_search_events/mod_onecore_search_events.css');
if ($showAutosuggest) {
	$wa->registerAndUseScript('mod_onecore_search_events.autocomplete', 'mod_onecore_search_events/mod_onecore_search_events.js', [], ['defer' => true], ['core']);
}
?>

<!-- MOD_ONECORE_SEARCH_EVENTS_MODULE_START ID:<?php echo $module->id; ?> -->
<div class="mod-onecore-search-events<?php echo $moduleClassSfx ? ' ' . htmlspecialchars($moduleClassSfx, ENT_COMPAT, 'UTF-8') : ''; ?>" id="mod-onecore-search-events-<?php echo $module->id; ?>">
	<form class="mod-onecore-search-events__form" action="<?php echo htmlspecialchars($formAction, ENT_QUOTES, 'UTF-8'); ?>" method="get" role="search">
		
		<?php if ($showSearch) : ?>
			<div class="mod-onecore-search-events__field mod-onecore-search-events__field--search ">
				<label for="mod-onecore-search-events-input-<?php echo $module->id; ?>" class="visually-hidden">
					<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_SEARCH_LABEL'); ?>
				</label>
				<div class="mod-onecore-search-events__input-wrapper">
					<input 
						type="text" 
						name="search" 
						id="mod-onecore-search-events-input-<?php echo $module->id; ?>" 
						class="mod-onecore-search-events__input form-control" 
						value="<?php echo htmlspecialchars($currentSearch, ENT_COMPAT, 'UTF-8'); ?>"
						placeholder="<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_SEARCH_PLACEHOLDER'); ?>"
						autocomplete="off"
					/>
					<?php if ($showAutosuggest) : ?>
						<div class="mod-onecore-search-events__suggestions" id="mod-onecore-search-events-suggestions-<?php echo $module->id; ?>" role="listbox" aria-label="<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_SUGGESTIONS'); ?>"></div>
					<?php endif; ?>
				</div>
			</div>
		<?php endif; ?>

		<div class="mod-onecore-search-events__filters mod-onecore-search-events__filters--basic ">
		<?php if ($showCategory && !empty($categories)) : ?>
			<div class="mod-onecore-search-events__field mod-onecore-search-events__field--category">
				<label for="mod-onecore-search-events-category-<?php echo $module->id; ?>">
					<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_CATEGORY_LABEL'); ?>
				</label>
				<?php
				// Load fancy select assets
				$wa->usePreset('choicesjs')
					->useScript('webcomponent.field-fancy-select');
				Text::script('JGLOBAL_SELECT_NO_RESULTS_MATCH');
				Text::script('JGLOBAL_SELECT_PRESS_TO_SELECT');
				?>
				<joomla-field-fancy-select 
					class="mod-onecore-search-events__fancy-select"
					placeholder="<?php echo htmlspecialchars(Text::_('MOD_ONECORE_SEARCH_EVENTS_CATEGORY_PLACEHOLDER'), ENT_QUOTES, 'UTF-8'); ?>"
					search-placeholder="<?php echo htmlspecialchars(Text::_('JGLOBAL_TYPE_OR_SELECT_SOME_OPTIONS'), ENT_QUOTES, 'UTF-8'); ?>"
					min-term-length="1"
					data-max-results="50"
				>
					<select 
						name="category[]" 
						id="mod-onecore-search-events-category-<?php echo $module->id; ?>" 
						class="mod-onecore-search-events__select form-select" 
						multiple
					>
						<?php foreach ($categories as $category) : ?>
							<option value="<?php echo (int) $category->id; ?>" 
								<?php echo in_array($category->id, $currentCategories) ? 'selected' : ''; ?>>
								<?php echo htmlspecialchars($category->title, ENT_COMPAT, 'UTF-8'); ?>
							</option>
						<?php endforeach; ?>
					</select>
				</joomla-field-fancy-select>
			</div>
		<?php endif; ?>

			<?php if ($showSort) : ?>
				<div class="mod-onecore-search-events__field mod-onecore-search-events__field--sort ">
					<label for="mod-onecore-search-events-sort-<?php echo $module->id; ?>">
						<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_SORT_LABEL'); ?>
					</label>
					<select 
						name="sort" 
						id="mod-onecore-search-events-sort-<?php echo $module->id; ?>" 
						class="mod-onecore-search-events__select form-select"
					>
						<option value="newest" <?php echo $currentSort === 'newest' ? 'selected' : ''; ?>>
							<?php echo Text::_('COM_ONECORE_SORT_NEWEST'); ?>
						</option>
						<option value="oldest" <?php echo $currentSort === 'oldest' ? 'selected' : ''; ?>>
							<?php echo Text::_('COM_ONECORE_SORT_OLDEST'); ?>
						</option>
						<option value="a-z" <?php echo $currentSort === 'a-z' ? 'selected' : ''; ?>>
							<?php echo Text::_('COM_ONECORE_SORT_A_Z'); ?>
						</option>
						<option value="z-a" <?php echo $currentSort === 'z-a' ? 'selected' : ''; ?>>
							<?php echo Text::_('COM_ONECORE_SORT_Z_A'); ?>
						</option>
					</select>
				</div>
			<?php endif; ?>

			<?php if ($showCustomFields && !empty($searchableCustomFields)) : ?>
				<?php foreach ($searchableCustomFields as $customField) : ?>
					<?php
					$fieldId = (int) $customField->id;
					$fieldName = 'cf_' . $fieldId;
					$currentValue = $currentCustomFields[$fieldId] ?? '';
					?>
					<div class="mod-onecore-search-events__field mod-onecore-search-events__field--customfield mod-onecore-search-events__field--customfield-<?php echo $fieldId; ?> ">
						<label for="mod-onecore-search-events-cf-<?php echo $fieldId; ?>-<?php echo $module->id; ?>">
							<?php echo htmlspecialchars($customField->title, ENT_COMPAT, 'UTF-8'); ?>
						</label>
						<?php if ($customField->type === 'select' || $customField->type === 'multiselect') : ?>
							<?php if (!empty($customField->values)) : ?>
								<?php
								// Load fancy select assets for select/multiselect fields
								$wa->usePreset('choicesjs')
									->useScript('webcomponent.field-fancy-select');
								Text::script('JGLOBAL_SELECT_NO_RESULTS_MATCH');
								Text::script('JGLOBAL_SELECT_PRESS_TO_SELECT');
								?>
								<joomla-field-fancy-select 
									class="mod-onecore-search-events__fancy-select"
									placeholder="<?php echo htmlspecialchars(Text::_('JGLOBAL_SELECT_AN_OPTION'), ENT_QUOTES, 'UTF-8'); ?>"
									search-placeholder="<?php echo htmlspecialchars(Text::_('JGLOBAL_TYPE_OR_SELECT_SOME_OPTIONS'), ENT_QUOTES, 'UTF-8'); ?>"
									min-term-length="1"
									data-max-results="50"
								>
									<select 
										name="<?php echo htmlspecialchars($fieldName, ENT_QUOTES, 'UTF-8'); ?><?php echo ($customField->type === 'multiselect') ? '[]' : ''; ?>" 
										id="mod-onecore-search-events-cf-<?php echo $fieldId; ?>-<?php echo $module->id; ?>" 
										class="mod-onecore-search-events__select form-select"
										<?php echo ($customField->type === 'multiselect') ? 'multiple="multiple"' : ''; ?>
									>
										<?php if ($customField->type !== 'multiselect') : ?>
											<option value=""><?php echo Text::_('JGLOBAL_SELECT_AN_OPTION'); ?></option>
										<?php endif; ?>
										<?php foreach ($customField->values as $option) : ?>
											<option value="<?php echo htmlspecialchars($option->value, ENT_QUOTES, 'UTF-8'); ?>" 
												<?php echo ($currentValue == $option->value || (is_array($currentValue) && in_array($option->value, $currentValue))) ? 'selected' : ''; ?>>
												<?php echo htmlspecialchars($option->label, ENT_COMPAT, 'UTF-8'); ?>
											</option>
										<?php endforeach; ?>
									</select>
								</joomla-field-fancy-select>
							<?php else : ?>
								<select 
									name="<?php echo htmlspecialchars($fieldName, ENT_QUOTES, 'UTF-8'); ?><?php echo ($customField->type === 'multiselect') ? '[]' : ''; ?>" 
									id="mod-onecore-search-events-cf-<?php echo $fieldId; ?>-<?php echo $module->id; ?>" 
									class="mod-onecore-search-events__select form-select"
									<?php echo ($customField->type === 'multiselect') ? 'multiple="multiple"' : ''; ?>
								>
									<?php if ($customField->type !== 'multiselect') : ?>
										<option value=""><?php echo Text::_('JGLOBAL_SELECT_AN_OPTION'); ?></option>
									<?php endif; ?>
								</select>
							<?php endif; ?>
						<?php elseif ($customField->type === 'input') : ?>
							<?php
							// For input fields, always use text input
							?>
							<input 
								type="text" 
								name="<?php echo htmlspecialchars($fieldName, ENT_QUOTES, 'UTF-8'); ?>" 
								id="mod-onecore-search-events-cf-<?php echo $fieldId; ?>-<?php echo $module->id; ?>" 
								class="mod-onecore-search-events__input form-control" 
								value="<?php echo htmlspecialchars(is_array($currentValue) ? implode(',', $currentValue) : $currentValue, ENT_COMPAT, 'UTF-8'); ?>"
								placeholder="<?php echo htmlspecialchars(Text::_('MOD_ONECORE_SEARCH_EVENTS_SEARCH_PLACEHOLDER'), ENT_COMPAT, 'UTF-8'); ?>"
							/>
						<?php elseif ($customField->type === 'textarea' && !empty($customField->values)) : ?>
							<?php
							// For textarea fields with values, use select dropdown
							$wa->usePreset('choicesjs')
								->useScript('webcomponent.field-fancy-select');
							Text::script('JGLOBAL_SELECT_NO_RESULTS_MATCH');
							Text::script('JGLOBAL_SELECT_PRESS_TO_SELECT');
							?>
							<joomla-field-fancy-select 
								class="mod-onecore-search-events__fancy-select"
								placeholder="<?php echo htmlspecialchars(Text::_('JGLOBAL_SELECT_AN_OPTION'), ENT_QUOTES, 'UTF-8'); ?>"
								search-placeholder="<?php echo htmlspecialchars(Text::_('JGLOBAL_TYPE_OR_SELECT_SOME_OPTIONS'), ENT_QUOTES, 'UTF-8'); ?>"
								min-term-length="1"
								data-max-results="50"
							>
								<select 
									name="<?php echo htmlspecialchars($fieldName, ENT_QUOTES, 'UTF-8'); ?>" 
									id="mod-onecore-search-events-cf-<?php echo $fieldId; ?>-<?php echo $module->id; ?>" 
									class="mod-onecore-search-events__select form-select"
								>
									<option value=""><?php echo Text::_('JGLOBAL_SELECT_AN_OPTION'); ?></option>
									<?php foreach ($customField->values as $option) : ?>
										<option value="<?php echo htmlspecialchars($option->value, ENT_QUOTES, 'UTF-8'); ?>" 
											<?php echo ($currentValue == $option->value || (is_array($currentValue) && in_array($option->value, $currentValue))) ? 'selected' : ''; ?>>
											<?php echo htmlspecialchars($option->label, ENT_COMPAT, 'UTF-8'); ?>
										</option>
									<?php endforeach; ?>
								</select>
							</joomla-field-fancy-select>
						<?php else : ?>
							<?php
							// For textarea fields without predefined values, use text input
							?>
							<input 
								type="text" 
								name="<?php echo htmlspecialchars($fieldName, ENT_QUOTES, 'UTF-8'); ?>" 
								id="mod-onecore-search-events-cf-<?php echo $fieldId; ?>-<?php echo $module->id; ?>" 
								class="mod-onecore-search-events__input form-control" 
								value="<?php echo htmlspecialchars(is_array($currentValue) ? implode(',', $currentValue) : $currentValue, ENT_COMPAT, 'UTF-8'); ?>"
								placeholder="<?php echo htmlspecialchars(Text::_('MOD_ONECORE_SEARCH_EVENTS_SEARCH_PLACEHOLDER'), ENT_COMPAT, 'UTF-8'); ?>"
							/>
						<?php endif; ?>
					</div>
				<?php endforeach; ?>
			<?php endif; ?>
		</div>

		<?php 
		// Show advanced section if:
		// - showAdvanced is set to 1 (always show) or 2 (show as link if conditions met)
		// - OR if showDate is enabled (always show event date filter)
		$hasAdvancedContent = ($showDate || $showFeatured || $showFeatured);
		$shouldShowAdvanced = ($showAdvanced == 1) || ($showAdvanced == 2 && $hasAdvancedContent) || ($showDate);
		?>
		<?php if ($shouldShowAdvanced) : ?>
			<?php if ($showAdvanced == 1 || ($showAdvanced == 2 && $hasAdvancedContent)) : ?>
				<div class="mod-onecore-search-events__advanced-toggle ">
					<button 
						type="button" 
						class="mod-onecore-search-events__toggle btn btn-link" 
						data-bs-toggle="collapse" 
						data-bs-target="#mod-onecore-search-events-advanced-<?php echo $module->id; ?>"
						aria-expanded="<?php echo ($showAdvanced == 1 || $showDate) ? 'true' : 'false'; ?>"
						aria-controls="mod-onecore-search-events-advanced-<?php echo $module->id; ?>"
					>
						<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_SHOW_ADVANCED'); ?>
						<span class="mod-onecore-search-events__toggle-icon" aria-hidden="true">▼</span>
					</button>
				</div>
			<?php endif; ?>

			<div class="collapse<?php echo ($showAdvanced == 1 || $showDate) ? ' show' : ''; ?> mod-onecore-search-events__filters mod-onecore-search-events__filters--advanced" id="mod-onecore-search-events-advanced-<?php echo $module->id; ?>">
				<?php if ($showDate) : ?>
					<div class="mod-onecore-search-events__field mod-onecore-search-events__field--date ">
						<div class="row g-2">
							<div class="col-md-6">
								<label for="mod-onecore-search-events-date-from-<?php echo $module->id; ?>">
									<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_DATE_FROM_LABEL'); ?>
								</label>
								<input 
									type="date" 
									name="event_date_from" 
									id="mod-onecore-search-events-date-from-<?php echo $module->id; ?>" 
									class="mod-onecore-search-events__input form-control" 
									value="<?php echo htmlspecialchars($currentDateFrom, ENT_COMPAT, 'UTF-8'); ?>"
								/>
							</div>
							<div class="col-md-6">
								<label for="mod-onecore-search-events-date-to-<?php echo $module->id; ?>">
									<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_DATE_TO_LABEL'); ?>
								</label>
								<input 
									type="date" 
									name="event_date_to" 
									id="mod-onecore-search-events-date-to-<?php echo $module->id; ?>" 
									class="mod-onecore-search-events__input form-control" 
									value="<?php echo htmlspecialchars($currentDateTo, ENT_COMPAT, 'UTF-8'); ?>"
								/>
							</div>
						</div>
					</div>
				<?php endif; ?>

				<?php if ($showFeatured) : ?>
					<div class="mod-onecore-search-events__field mod-onecore-search-events__field--featured ">
						<div class="form-check">
							<input 
								type="checkbox" 
								name="featured" 
								id="mod-onecore-search-events-featured-<?php echo $module->id; ?>" 
								class="mod-onecore-search-events__checkbox form-check-input" 
								value="1"
								<?php echo $currentFeatured ? 'checked' : ''; ?>
							/>
							<label class="form-check-label" for="mod-onecore-search-events-featured-<?php echo $module->id; ?>">
								<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_FEATURED_LABEL'); ?>
							</label>
						</div>
					</div>
				<?php endif; ?>
			</div>
		<?php endif; ?>

		<div class="mod-onecore-search-events__actions mt-5">
			<button type="submit" class="mod-onecore-search-events__submit btn btn-primary ">
				<span class="icon-search" aria-hidden="true"></span>
				<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_SUBMIT'); ?>
			</button>
			<button type="button" class="mod-onecore-search-events__reset btn btn-secondary">
				<?php echo Text::_('MOD_ONECORE_SEARCH_EVENTS_RESET'); ?>
			</button>
		</div>

		<?php
		// Preserve menu item ID if exists
		$menuItemId = $input->getInt('Itemid', 0);
		if ($menuItemId > 0) :
		?>
			<input type="hidden" name="Itemid" value="<?php echo (int) $menuItemId; ?>" />
		<?php endif; ?>
		
		<?php
		// Preserve view (always events for this module)
		?>
		<input type="hidden" name="view" value="events" />
		
		<?php
		// Preserve custom fields entity type
		?>
		<input type="hidden" name="custom_fields_entity_type" value="events" />
		
		<?php
		// Preserve layout + columns, but always render inputs with IDs so JS can keep them in sync.
		$currentLayout  = $input->getString('layout', '');
		$currentColumns = $input->getInt('columns', 0);

		// Only allow 2, 3, or 4 columns
		if (!in_array($currentColumns, [2, 3, 4], true)) {
			$currentColumns = 0;
		}
		?>
		<input
			type="hidden"
			name="layout"
			id="mod-onecore-search-events-layout-<?php echo (int) $module->id; ?>"
			value="<?php echo htmlspecialchars((string) $currentLayout, ENT_QUOTES, 'UTF-8'); ?>"
		/>
		<input
			type="hidden"
			name="columns"
			id="mod-onecore-search-events-columns-<?php echo (int) $module->id; ?>"
			value="<?php echo $currentColumns ? (int) $currentColumns : ''; ?>"
		/>
		
		<script>
		// Set columns value immediately (runs before DOMContentLoaded)
		(function() {
			function setColumnsValue() {
				const columnsInput = document.getElementById('mod-onecore-search-events-columns-<?php echo $module->id; ?>');
				if (!columnsInput) {
					// If element not found, try again after DOM loads
					if (document.readyState === 'loading') {
						document.addEventListener('DOMContentLoaded', setColumnsValue);
					}
					return;
				}
				
				// Check layout - if grid, we need columns
				const urlParams = new URLSearchParams(window.location.search);
				let layout = urlParams.get('layout');
				if (!layout) {
					layout = localStorage.getItem('onecore_layout') || 'grid';
				}
				
				// If layout is not grid, don't set columns
				if (layout !== 'grid') {
					columnsInput.value = '';
					return;
				}
				
				// Only set if value is empty (not already set from URL)
				if (columnsInput.value && ['2', '3', '4'].includes(columnsInput.value)) {
					localStorage.setItem('onecore_columns', columnsInput.value);
					return;
				}
				
				// Get from URL first
				let columns = urlParams.get('columns');
				
				// Validate and get from localStorage if needed
				if (!columns || !['2', '3', '4'].includes(columns)) {
					columns = localStorage.getItem('onecore_columns');
					if (!columns || !['2', '3', '4'].includes(columns)) {
						columns = '3';
					}
				}
				
				columnsInput.value = columns;
				localStorage.setItem('onecore_columns', columns);
			}
			
			// Try to set immediately if DOM is ready, otherwise wait for DOMContentLoaded
			if (document.readyState === 'loading') {
				document.addEventListener('DOMContentLoaded', setColumnsValue);
			} else {
				setColumnsValue();
			}
		})();
		</script>

		<script>
		// Always sync layout/columns right before submit (so changing #onecore-columns is respected).
		(function () {
			function getValidColumns(val) {
				return (val === '2' || val === '3' || val === '4') ? val : '';
			}

			function syncLayoutAndColumns() {
				const root = document.getElementById('mod-onecore-search-events-<?php echo (int) $module->id; ?>');
				if (!root) return;

				const layoutInput = document.getElementById('mod-onecore-search-events-layout-<?php echo (int) $module->id; ?>');
				const columnsInput = document.getElementById('mod-onecore-search-events-columns-<?php echo (int) $module->id; ?>');
				if (!layoutInput || !columnsInput) return;

				const urlParams = new URLSearchParams(window.location.search);
				let layout = urlParams.get('layout') || localStorage.getItem('onecore_layout') || 'grid';
				if (layout !== 'grid' && layout !== 'list') {
					layout = 'grid';
				}
				layoutInput.value = layout;
				localStorage.setItem('onecore_layout', layout);

				// Prefer the real selector in the component toolbar if present, then URL, then localStorage.
				let columns = '';
				const componentColumnsSelect = document.getElementById('onecore-columns');
				if (componentColumnsSelect && componentColumnsSelect.value) {
					columns = componentColumnsSelect.value;
				} else {
					columns = urlParams.get('columns') || localStorage.getItem('onecore_columns') || '';
				}

				columns = getValidColumns(columns);

				// Only keep columns when layout is grid
				if (layout !== 'grid') {
					columnsInput.value = '';
					return;
				}

				if (!columns) {
					columns = '3';
				}

				columnsInput.value = columns;
				localStorage.setItem('onecore_columns', columns);
			}

			function bind() {
				const root = document.getElementById('mod-onecore-search-events-<?php echo (int) $module->id; ?>');
				if (!root) return;
				const form = root.querySelector('form');
				if (!form) return;

				// Keep in sync on load + on submit (submit is the critical one)
				syncLayoutAndColumns();
				form.addEventListener('submit', syncLayoutAndColumns);
			}

			if (document.readyState === 'loading') {
				document.addEventListener('DOMContentLoaded', bind);
			} else {
				bind();
			}
		})();
		</script>
	</form>
</div>

<?php if ($showAutosuggest) : ?>
	<script>
		document.addEventListener('DOMContentLoaded', function() {
			const moduleId = <?php echo $module->id; ?>;
			
			// Preserve layout from URL or localStorage
			const layoutInput = document.getElementById('mod-onecore-search-events-layout-' + moduleId);
			if (layoutInput) {
				const urlParams = new URLSearchParams(window.location.search);
				let layout = urlParams.get('layout');
				
				// If no layout in URL, try localStorage
				if (!layout) {
					layout = localStorage.getItem('onecore_layout') || 'grid';
				}
				
				// Store in localStorage for future use
				if (layout) {
					localStorage.setItem('onecore_layout', layout);
					layoutInput.value = layout;
				}
			}
			
			// Preserve columns from URL or localStorage (only if not already set by inline script)
			const columnsInput = document.getElementById('mod-onecore-search-events-columns-' + moduleId);
			if (columnsInput && !columnsInput.value) {
				const urlParams = new URLSearchParams(window.location.search);
				let columns = urlParams.get('columns');
				
				// Validate columns - only allow 2, 3, or 4
				if (!columns || !['2', '3', '4'].includes(columns)) {
					columns = localStorage.getItem('onecore_columns');
					if (!columns || !['2', '3', '4'].includes(columns)) {
						columns = '3';
					}
				}
				
				// Store in localStorage for future use
				localStorage.setItem('onecore_columns', columns);
				columnsInput.value = columns;
			} else if (columnsInput && columnsInput.value) {
				// If value is already set, ensure it's valid and save to localStorage
				const columns = columnsInput.value;
				if (['2', '3', '4'].includes(columns)) {
					localStorage.setItem('onecore_columns', columns);
				} else {
					columnsInput.value = '3';
					localStorage.setItem('onecore_columns', '3');
				}
			}
			
			// Ensure columns value is set before form submission
			const searchForm = document.querySelector('#mod-onecore-search-events-' + moduleId + ' .mod-onecore-search-events__form');
			if (searchForm) {
				searchForm.addEventListener('submit', function(e) {
					const columnsInput = document.getElementById('mod-onecore-search-events-columns-' + moduleId);
					const layoutInput = document.getElementById('mod-onecore-search-events-layout-' + moduleId);
					
					// Check if layout is grid - if so, we need columns
					let layout = layoutInput ? layoutInput.value : '';
					if (!layout) {
						const urlParams = new URLSearchParams(window.location.search);
						layout = urlParams.get('layout') || localStorage.getItem('onecore_layout') || 'grid';
						if (layoutInput) {
							layoutInput.value = layout;
						}
					}
					
					// If layout is grid, always get current columns from localStorage (most up-to-date)
					if (columnsInput && layout === 'grid') {
						// ALWAYS check localStorage first for the most current value (user may have changed it)
						let columns = localStorage.getItem('onecore_columns');
						
						// Validate columns - only allow 2, 3, or 4
						if (!columns || !['2', '3', '4'].includes(columns)) {
							// Fallback to URL param if localStorage has invalid value
							const urlParams = new URLSearchParams(window.location.search);
							columns = urlParams.get('columns');
							if (!columns || !['2', '3', '4'].includes(columns)) {
								columns = '3';
							}
						}
						
						// Always update input with value from localStorage (may have changed)
						columnsInput.value = columns;
						localStorage.setItem('onecore_columns', columns);
					} else if (columnsInput && layout !== 'grid') {
						// If layout is not grid, remove columns param
						columnsInput.value = '';
					}
				}, true); // Use capture phase to ensure it runs early
			}
			
			const searchInput = document.getElementById('mod-onecore-search-events-input-' + moduleId);
			const suggestionsContainer = document.getElementById('mod-onecore-search-events-suggestions-' + moduleId);
			
			if (!searchInput || !suggestionsContainer) return;
			
			let debounceTimer;
			let currentRequest = null;
			
			searchInput.addEventListener('input', function() {
				const query = this.value.trim();
				
				clearTimeout(debounceTimer);
				
				if (query.length < 2) {
					suggestionsContainer.innerHTML = '';
					suggestionsContainer.classList.remove('is-visible');
					return;
				}
				
				debounceTimer = setTimeout(function() {
					if (currentRequest) {
						currentRequest.abort();
					}
					
					suggestionsContainer.classList.add('is-loading');
					
					const baseUrl = '<?php echo Route::_('index.php?option=com_onecore&task=suggestions.suggest&format=json', false); ?>';
					const url = new URL(baseUrl, window.location.origin);
					url.searchParams.set('q', query);
					
					currentRequest = fetch(url.toString(), {
						method: 'GET',
						headers: {
							'X-Requested-With': 'XMLHttpRequest',
							'Accept': 'application/json'
						}
					})
					.then(function(response) {
						return response.json();
					})
					.then(function(data) {
						suggestionsContainer.classList.remove('is-loading');
						
						if (data && data.length > 0) {
							let html = '';
							data.forEach(function(item) {
								html += '<div class="mod-onecore-search-events__suggestion" role="option" tabindex="0" data-title="' + 
									item.title.replace(/"/g, '&quot;') + '">' + 
									item.title + 
									'</div>';
							});
							suggestionsContainer.innerHTML = html;
							suggestionsContainer.classList.add('is-visible');
							
							// Add click handlers
							suggestionsContainer.querySelectorAll('.mod-onecore-search-events__suggestion').forEach(function(suggestion) {
								suggestion.addEventListener('click', function() {
									searchInput.value = this.getAttribute('data-title');
									suggestionsContainer.innerHTML = '';
									suggestionsContainer.classList.remove('is-visible');
								});
							});
						} else {
							suggestionsContainer.innerHTML = '';
							suggestionsContainer.classList.remove('is-visible');
						}
					})
					.catch(function(error) {
						suggestionsContainer.classList.remove('is-loading');
						suggestionsContainer.classList.remove('is-visible');
					});
				}, 300);
			});
			
			// Hide suggestions when clicking outside
			document.addEventListener('click', function(e) {
				if (!searchInput.contains(e.target) && !suggestionsContainer.contains(e.target)) {
					suggestionsContainer.classList.remove('is-visible');
				}
			});
		});
		
		// Handle form reset button
		const resetButton = document.querySelector('#mod-onecore-search-events-<?php echo $module->id; ?> .mod-onecore-search-events__reset');
		if (resetButton) {
			resetButton.addEventListener('click', function(e) {
				e.preventDefault();
				const form = this.closest('.mod-onecore-search-events__form');
				if (form) {
					// Reset form fields
					form.reset();
					
					// Clear suggestions if exists
					const suggestions = form.querySelector('.mod-onecore-search-events__suggestions');
					if (suggestions) {
						suggestions.innerHTML = '';
						suggestions.classList.remove('is-visible');
					}
					
					// Build reset URL (base URL without search parameters)
					const viewInput = form.querySelector('input[name="view"]');
					const currentView = viewInput ? viewInput.value : 'events';
					
					// Always use current URL and remove all search parameters
					const currentUrl = new URL(window.location.href);
					const itemId = currentUrl.searchParams.get('Itemid');
					
					// Clear all search parameters
					currentUrl.search = '';
					
					// Add back only essential parameters
					if (itemId) {
						currentUrl.searchParams.set('Itemid', itemId);
					}
					
					// Always preserve view parameter
					currentUrl.searchParams.set('view', currentView);
					
					// Redirect to clean URL
					window.location.href = currentUrl.toString();
				}
			});
		}
	</script>
<?php endif; ?>

<?php if (!$showAutosuggest) : ?>
	<script>
		document.addEventListener('DOMContentLoaded', function() {
			// Preserve layout from URL or localStorage
			const layoutInput = document.getElementById('mod-onecore-search-events-layout-<?php echo $module->id; ?>');
			if (layoutInput) {
				const urlParams = new URLSearchParams(window.location.search);
				let layout = urlParams.get('layout');
				
				// If no layout in URL, try localStorage
				if (!layout) {
					layout = localStorage.getItem('onecore_layout') || 'grid';
				}
				
				// Store in localStorage for future use
				if (layout) {
					localStorage.setItem('onecore_layout', layout);
					layoutInput.value = layout;
				}
			}
			
			// Preserve columns from URL or localStorage (only if not already set by inline script)
			const columnsInput = document.getElementById('mod-onecore-search-events-columns-<?php echo $module->id; ?>');
			if (columnsInput && !columnsInput.value) {
				const urlParams = new URLSearchParams(window.location.search);
				let columns = urlParams.get('columns');
				
				// Validate columns - only allow 2, 3, or 4
				if (!columns || !['2', '3', '4'].includes(columns)) {
					columns = localStorage.getItem('onecore_columns');
					if (!columns || !['2', '3', '4'].includes(columns)) {
						columns = '3';
					}
				}
				
				// Store in localStorage for future use
				localStorage.setItem('onecore_columns', columns);
				columnsInput.value = columns;
			} else if (columnsInput && columnsInput.value) {
				// If value is already set, ensure it's valid and save to localStorage
				const columns = columnsInput.value;
				if (['2', '3', '4'].includes(columns)) {
					localStorage.setItem('onecore_columns', columns);
				} else {
					columnsInput.value = '3';
					localStorage.setItem('onecore_columns', '3');
				}
			}
			
			// Ensure columns value is set before form submission
			const searchForm = document.querySelector('#mod-onecore-search-events-<?php echo $module->id; ?> .mod-onecore-search-events__form');
			if (searchForm) {
				searchForm.addEventListener('submit', function(e) {
					const columnsInput = document.getElementById('mod-onecore-search-events-columns-<?php echo $module->id; ?>');
					const layoutInput = document.getElementById('mod-onecore-search-events-layout-<?php echo $module->id; ?>');
					
					// Check if layout is grid - if so, we need columns
					let layout = layoutInput ? layoutInput.value : '';
					if (!layout) {
						const urlParams = new URLSearchParams(window.location.search);
						layout = urlParams.get('layout') || localStorage.getItem('onecore_layout') || 'grid';
						if (layoutInput) {
							layoutInput.value = layout;
						}
					}
					
					// If layout is grid, always get current columns from localStorage (most up-to-date)
					if (columnsInput && layout === 'grid') {
						// ALWAYS check localStorage first for the most current value (user may have changed it)
						let columns = localStorage.getItem('onecore_columns');
						
						// Validate columns - only allow 2, 3, or 4
						if (!columns || !['2', '3', '4'].includes(columns)) {
							// Fallback to URL param if localStorage has invalid value
							const urlParams = new URLSearchParams(window.location.search);
							columns = urlParams.get('columns');
							if (!columns || !['2', '3', '4'].includes(columns)) {
								columns = '3';
							}
						}
						
						// Always update input with value from localStorage (may have changed)
						columnsInput.value = columns;
						localStorage.setItem('onecore_columns', columns);
					} else if (columnsInput && layout !== 'grid') {
						// If layout is not grid, remove columns param
						columnsInput.value = '';
					}
				}, true); // Use capture phase to ensure it runs early
			}
			
			// Handle form reset button when autosuggest is disabled
			const resetButton = document.querySelector('#mod-onecore-search-events-<?php echo $module->id; ?> .mod-onecore-search-events__reset');
			if (resetButton) {
				resetButton.addEventListener('click', function(e) {
					e.preventDefault();
					const form = this.closest('.mod-onecore-search-events__form');
					if (form) {
						form.reset();
						
						const viewInput = form.querySelector('input[name="view"]');
						const currentView = viewInput ? viewInput.value : 'events';
						
						// Always use current URL and remove all search parameters
						const currentUrl = new URL(window.location.href);
						const itemId = currentUrl.searchParams.get('Itemid');
						
						// Clear all search parameters
						currentUrl.search = '';
						
						// Add back only essential parameters
						if (itemId) {
							currentUrl.searchParams.set('Itemid', itemId);
						}
						
						// Always preserve view parameter
						currentUrl.searchParams.set('view', currentView);
						
						// Redirect to clean URL
						window.location.href = currentUrl.toString();
					}
				});
			}
		});
	</script>
<?php endif; ?>
