<?php

/**
 * @package     Comdev.Module
 * @subpackage  mod_onecore_items
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

/** @var \stdClass $module */
/** @var \Joomla\Registry\Registry $params */
/** @var object $app */
/** @var \Joomla\Input\Input $input */
/** @var string $template */

// Variables are extracted from displayData by AbstractModuleDispatcher
// Available variables: $module, $params, $app, $input, $template
// Plus custom variables from Dispatcher: $items, $columns, $showImage, etc.

// Initialize default values if not set
$items = $items ?? [];
$columns = $columns ?? 3;
$showImage = $showImage ?? true;
$showTitle = $showTitle ?? true;
$showIntrotext = $showIntrotext ?? true;
$showCategory = $showCategory ?? true;
$moduleClassSfx = $moduleClassSfx ?? '';

// Get columns per row from params
$columnsPerRow = (int) ($columns ?? 3);

// Validate columns (only allow 1, 2, 3, or 4)
if (!in_array($columnsPerRow, [1, 2, 3, 4])) {
	$columnsPerRow = 3;
}

// Calculate Bootstrap column classes based on columns per row
$colClassMap = [
	1 => 'col-12',
	2 => 'col-md-6',
	3 => 'col-md-4',
	4 => 'col-md-3',
];

$colClass = isset($colClassMap[$columnsPerRow]) ? $colClassMap[$columnsPerRow] : 'col-md-4';
$smColClass = ($columnsPerRow === 1) ? 'col-12' : 'col-sm-6'; // Full width for single column

// Function to limit text by words
if (!function_exists('limitWords')) {
	function limitWords($text, $limit = 30) {
		if (empty($text)) {
			return '';
		}
		
		$text = strip_tags($text);
		$words = explode(' ', $text);
		
		if (count($words) <= $limit) {
			return $text;
		}
		
		$words = array_slice($words, 0, $limit);
		return implode(' ', $words) . '...';
	}
}

$moduleClassSfx = htmlspecialchars($moduleClassSfx ?? '', ENT_COMPAT, 'UTF-8');
$itemsCount = is_array($items) ? count($items) : 0;
?>

<!-- MOD_ONECORE_ITEMS_MODULE_START ID:<?php echo $module->id; ?> -->
<div class="mod-onecore-items onecore-items-grid<?php echo $moduleClassSfx ? ' ' . htmlspecialchars($moduleClassSfx, ENT_COMPAT, 'UTF-8') : ''; ?>" id="mod-onecore-items-<?php echo $module->id; ?>">
	<?php if (!empty($items) && is_array($items) && count($items) > 0) : ?>
		<div class="items-grid row g-3 one_grid_items" data-columns="<?php echo (int)$columnsPerRow; ?>">
			<?php foreach ($items as $item) : ?>
				<div class="<?php echo htmlspecialchars($colClass . ' ' . $smColClass, ENT_QUOTES, 'UTF-8'); ?> one_grid_col<?php echo (!empty($item->featured)) ? ' one_grid_col--featured' : ''; ?>">
					<div class="item-card card h-100 one_grid_card">
						<?php if ($showImage ?? true) : ?>
							<?php 
							$itemUrl = Route::_('index.php?option=com_onecore&view=item&id=' . $item->id . ':' . $item->alias);
							$hasImage = !empty($item->image);
							?>
							<div class="item-image one_grid_image">
								<a href="<?php echo $itemUrl; ?>" title="<?php echo htmlspecialchars($item->title ?? '', ENT_QUOTES, 'UTF-8'); ?>" class="one_grid_image_link">
									<?php if ($hasImage) : ?>
										<?php echo HTMLHelper::_('image', $item->image, htmlspecialchars($item->title ?? '', ENT_QUOTES, 'UTF-8'), [
											'class' => 'card-img-top one_grid_image_img',
											'loading' => 'lazy'
										]); ?>
									<?php else : ?>
										<div class="one_grid_image_placeholder card-img-top one_grid_image_img">
											<svg class="one_grid_placeholder_icon" width="100" height="100" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M21 19V5C21 3.9 20.1 3 19 3H5C3.9 3 3 3.9 3 5V19C3 20.1 3.9 21 5 21H19C20.1 21 21 20.1 21 19ZM8.5 13.5L11 16.51L14.5 12L19 18H5L8.5 13.5Z" fill="currentColor"/>
											</svg>
											<span class="one_grid_placeholder_text"><?php echo Text::_('COM_ONECORE_NO_IMAGE') ?: 'No Image'; ?></span>
										</div>
									<?php endif; ?>
								</a>
							</div>
						<?php endif; ?>

						<div class="card-body one_grid_body">
							<?php if ($showTitle ?? true) : ?>
								<h3 class="card-title one_grid_title">
									<a href="<?php echo Route::_('index.php?option=com_onecore&view=item&id=' . $item->id . ':' . $item->alias); ?>" class="one_grid_title_link">
										<?php echo htmlspecialchars($item->title ?? '', ENT_QUOTES, 'UTF-8'); ?>
									</a>
								</h3>
							<?php endif; ?>

							<?php if (!empty($item->customfields_under_title)) : ?>
								<?php foreach ($item->customfields_under_title as $group) : ?>
									<div class="one_customfield_group one_customfield_group--under-title mb-2">
										<?php if (!empty($group->fields)) : ?>
											<div class="one_customfields one_customfields--under-title">
												<?php foreach ($group->fields as $cf) : ?>
													<div class="one_customfield">
														<?php if (!empty($cf->display_label)) : ?>
															<?php if (($cf->label_position ?? 'next') === 'over') : ?>
																<div class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
																<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
															<?php else : ?>
																<span class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
																<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
															<?php endif; ?>
														<?php else : ?>
															<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
														<?php endif; ?>
													</div>
												<?php endforeach; ?>
											</div>
										<?php endif; ?>
									</div>
								<?php endforeach; ?>
							<?php endif; ?>

							<?php if (($showIntrotext ?? true) && !empty($item->introtext)) : ?>
								<?php 
								$introText = limitWords($item->introtext, 30);
								?>
								<div class="card-text introtext one_grid_introtext">
									<?php echo htmlspecialchars($introText, ENT_QUOTES, 'UTF-8'); ?>
								</div>
							<?php endif; ?>

							<?php if (!empty($item->customfields_under_intro)) : ?>
								<?php foreach ($item->customfields_under_intro as $group) : ?>
									<div class="one_customfield_group one_customfield_group--under-intro mb-2">
										<?php if (!empty($group->fields)) : ?>
											<div class="one_customfields one_customfields--under-intro">
												<?php foreach ($group->fields as $cf) : ?>
													<div class="one_customfield">
														<?php if (!empty($cf->display_label)) : ?>
															<?php if (($cf->label_position ?? 'next') === 'over') : ?>
																<div class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?></div>
																<div class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></div>
															<?php else : ?>
																<span class="one_customfield_label"><?php echo htmlspecialchars((string) $cf->title, ENT_QUOTES, 'UTF-8'); ?>:</span>
																<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
															<?php endif; ?>
														<?php else : ?>
															<span class="one_customfield_value"><?php echo nl2br(htmlspecialchars((string) $cf->value, ENT_QUOTES, 'UTF-8')); ?></span>
														<?php endif; ?>
													</div>
												<?php endforeach; ?>
											</div>
										<?php endif; ?>
									</div>
								<?php endforeach; ?>
							<?php endif; ?>

							<?php if (($showCategory ?? true) && !empty($item->categories)) : ?>
								<div class="item-categories one_grid_categories">
									<span class="one_grid_categories_label"><?php echo Text::_('JCATEGORY') . ': '; ?></span>
									<?php 
									$categoryNames = [];
									foreach ($item->categories as $category) {
										$categoryNames[] = '<span class="one_grid_category_name">' . htmlspecialchars($category->title, ENT_QUOTES, 'UTF-8') . '</span>';
									}
									echo implode(', ', $categoryNames);
									?>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			<?php endforeach; ?>
		</div>
	<?php else : ?>
		<div class="alert alert-info">
			<p><?php echo Text::_('COM_ONECORE_NO_ITEMS_FOUND') ?: 'No items found.'; ?></p>
		</div>
	<?php endif; ?>
</div>

<style>
.mod-onecore-items .one_grid_items,
.mod-onecore-items .items-grid {
	margin-top: 0;
}
.mod-onecore-items .one_grid_card,
.mod-onecore-items .item-card {
	transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
	transform-style: preserve-3d;
	perspective: 1000px;
	border-radius: 8px;
	overflow: hidden;
	background: #fff;
	box-shadow: 
		0 2px 4px rgba(0,0,0,0.08),
		0 1px 2px rgba(0,0,0,0.06);
}
.mod-onecore-items .one_grid_card:hover,
.mod-onecore-items .item-card:hover {
	transform: translateY(-10px) rotateX(1deg) rotateY(1deg);
	box-shadow: 
		0 20px 40px rgba(0,0,0,0.12),
		0 10px 20px rgba(0,0,0,0.08),
		0 5px 10px rgba(0,0,0,0.05);
}
.mod-onecore-items .one_grid_image,
.mod-onecore-items .item-image {
	overflow: hidden;
	border-radius: 4px 4px 0 0;
}
.mod-onecore-items .one_grid_image img,
.mod-onecore-items .one_grid_image_img,
.mod-onecore-items .item-image img {
	width: 100%;
	height: 200px;
	object-fit: cover;
	transition: transform 0.3s ease;
}
.mod-onecore-items .one_grid_card:hover .one_grid_image img,
.mod-onecore-items .one_grid_card:hover .one_grid_image_img {
	transform: scale(1.05);
}
.mod-onecore-items .one_grid_image_placeholder,
.mod-onecore-items .one_grid_image_placeholder.card-img-top {
	width: 100%;
	height: 200px;
	background: linear-gradient(135deg, rgba(240, 245, 250, 1) 0%, rgba(242, 242, 242, 1) 50%, rgba(221, 229, 238, 1) 100%);
	display: flex;
	flex-direction: column;
	align-items: center;
	justify-content: center;
	border: none;
	position: relative;
	border-radius: 4px 4px 0 0;
	overflow: hidden;
	box-shadow: 
		inset 0 3px 6px rgba(255,255,255,0.9),
		inset 0 -3px 6px rgba(0,0,0,0.15),
		0 6px 12px rgba(0,0,0,0.12),
		0 3px 6px rgba(0,0,0,0.1),
		0 1px 2px rgba(0,0,0,0.08);
	transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1), box-shadow 0.4s ease, background 0.3s ease;
	transform-style: preserve-3d;
	backface-visibility: hidden;
}
.mod-onecore-items .one_grid_image_placeholder::before {
	content: '';
	position: absolute;
	top: 0;
	left: 0;
	right: 0;
	height: 50%;
	background: linear-gradient(180deg, rgba(255,255,255,0.5) 0%, rgba(255,255,255,0.2) 50%, rgba(255,255,255,0) 100%);
	pointer-events: none;
	z-index: 1;
	transition: opacity 0.3s ease;
}
.mod-onecore-items .one_grid_card:hover .one_grid_image_placeholder::before {
	opacity: 0.9;
}
.mod-onecore-items .one_grid_image_placeholder::after {
	content: '';
	position: absolute;
	bottom: 0;
	left: 0;
	right: 0;
	height: 35%;
	background: linear-gradient(0deg, rgba(0,0,0,0.15) 0%, rgba(0,0,0,0.08) 50%, rgba(0,0,0,0) 100%);
	pointer-events: none;
	z-index: 1;
	transition: opacity 0.3s ease;
}
.mod-onecore-items .one_grid_card:hover .one_grid_image_placeholder::after {
	opacity: 0.8;
}
.mod-onecore-items .one_grid_card:hover .one_grid_image_placeholder,
.mod-onecore-items .one_grid_card:hover .one_grid_image_placeholder.card-img-top {
	transform: translateZ(15px) scale(1.03) rotateX(1deg);
	background: linear-gradient(135deg, #f0f5fa 0%, #c8d5e8 50%, #b5c8e0 100%);
	box-shadow: 
		inset 0 4px 8px rgba(255,255,255,0.95),
		inset 0 -4px 8px rgba(0,0,0,0.2),
		0 12px 24px rgba(0,0,0,0.18),
		0 6px 12px rgba(0,0,0,0.15),
		0 3px 6px rgba(0,0,0,0.12),
		0 1px 3px rgba(0,0,0,0.1);
}
.mod-onecore-items .one_grid_placeholder_icon {
	width: 80px;
	height: 80px;
	color: rgba(102, 102, 102, 0.65);
	margin-bottom: 10px;
	position: relative;
	z-index: 2;
	filter: drop-shadow(0 2px 4px rgba(0,0,0,0.12)) drop-shadow(0 1px 2px rgba(255,255,255,0.5));
	transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1), color 0.3s ease, filter 0.3s ease;
	transform: translateZ(0);
}
.mod-onecore-items .one_grid_card:hover .one_grid_placeholder_icon {
	transform: translateZ(8px) scale(1.15) rotateY(5deg);
	color: rgba(102, 102, 102, 0.95);
	filter: drop-shadow(0 6px 12px rgba(0,0,0,0.2)) drop-shadow(0 2px 4px rgba(255,255,255,0.6));
}
.mod-onecore-items .one_grid_placeholder_text {
	color: rgba(102, 102, 102, 0.75);
	font-size: 0.9rem;
	text-align: center;
	padding: 0 10px;
	position: relative;
	z-index: 2;
	font-weight: 600;
	letter-spacing: 0.3px;
	text-shadow: 
		0 1px 2px rgba(255,255,255,0.9),
		0 -1px 1px rgba(0,0,0,0.1);
	transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1), color 0.3s ease, text-shadow 0.3s ease;
	transform: translateZ(0);
}
.mod-onecore-items .one_grid_card:hover .one_grid_placeholder_text {
	transform: translateZ(8px) translateY(-2px);
	color: rgba(102, 102, 102, 1);
	text-shadow: 
		0 2px 4px rgba(255,255,255,1),
		0 -1px 2px rgba(0,0,0,0.15),
		0 1px 3px rgba(0,0,0,0.1);
}
.mod-onecore-items .one_grid_categories,
.mod-onecore-items .item-categories {
	margin-top: 0.5rem;
	font-size: 0.9rem;
	color: #666;
}
.mod-onecore-items .one_grid_col--featured .one_grid_card {
	border: 2px solid #dc3545;
}
</style>

