<?php

/**
 * @package     Comdev.Module
 * @subpackage  mod_onecore_items
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Module\OnecoreItems\Site\Dispatcher;

use Joomla\CMS\Dispatcher\AbstractModuleDispatcher;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\HelperFactoryAwareInterface;
use Joomla\CMS\Helper\HelperFactoryAwareTrait;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Dispatcher class for mod_onecore_items
 *
 * @since  1.0.0
 */
class Dispatcher extends AbstractModuleDispatcher implements HelperFactoryAwareInterface
{
	use HelperFactoryAwareTrait;

	/**
	 * Returns the layout data.
	 *
	 * @return  array
	 *
	 * @since   1.0.0
	 */
	protected function getLayoutData()
	{
		$data = parent::getLayoutData();

		// Load component language file for translations (COM_ONECORE_*)
		Factory::getLanguage()->load('com_onecore', JPATH_SITE . '/components/com_onecore');

		// Initialize defaults
		$data['items'] = [];
		$data['columns'] = 3;
		$data['showImage'] = true;
		$data['showTitle'] = true;
		$data['showIntrotext'] = true;
		$data['showCategory'] = true;
		$data['moduleClassSfx'] = '';

		// Get display options from params
		$params = $data['params'];
		$data['columns'] = $params->get('columns', 3);
		$data['showImage'] = $params->get('show_image', 1);
		$data['showTitle'] = $params->get('show_title', 1);
		$data['showIntrotext'] = $params->get('show_introtext', 1);
		$data['showCategory'] = $params->get('show_category', 1);
		$data['moduleClassSfx'] = $params->get('moduleclass_sfx', '');

		// Get helper and items
		try {
			$helperFactory = $this->getHelperFactory();
			if ($helperFactory) {
				$helper = $helperFactory->getHelper('ItemsHelper');
				if ($helper) {
					$moduleParams = [
						'count' => $params->get('count', 6),
						'show_latest' => $params->get('show_latest', 1),
						'featured_only' => $params->get('featured_only', 0),
					];
					$data['items'] = $helper->getItems($moduleParams);
				}
			}
		} catch (\Exception $e) {
			// Log error but continue
			$data['app']->getLogger()->error('Error in mod_onecore_items dispatcher: ' . $e->getMessage(), ['exception' => $e]);
		}

		return $data;
	}
}
