<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;

$stats = $this->statistics ?? [];
$maxListings = 0;
if (!empty($stats['listings_per_day'])) {
	$maxListings = max(array_column($stats['listings_per_day'], 'count'));
}

// Ensure total_content is set
if (!isset($stats['total_content'])) {
	$stats['total_content'] = 0;
}
?>

<?php
$licenseInfo = $stats['license_info'] ?? [];
$isLicenseActive = $licenseInfo['is_active'] ?? false;
$licenseKey = $licenseInfo['key'] ?? '';
$licenseStatus = $licenseInfo['status'] ?? 'inactive';
$componentVersionName = $stats['component_version_name'] ?? 'OneCore';
$showRenewalDiscount = $licenseInfo['show_renewal_discount'] ?? false;
$daysUntilExpiry = $licenseInfo['days_until_expiry'] ?? null;
?>
<div class="onecore-dashboard">
	<!-- Renewal Discount Banner - show if license expires within 1 month -->
	<?php if ($isLicenseActive && $showRenewalDiscount) : ?>
	<div class="onecore-renewal-banner">
		<div class="onecore-renewal-content">
			<div class="onecore-renewal-title">🎉 <?php echo Text::_('COM_ONECORE_LICENSE_RENEWAL_DISCOUNT_TITLE'); ?></div>
			<div class="onecore-renewal-text">
				<?php if ($daysUntilExpiry > 0) : ?>
					<?php echo Text::sprintf('COM_ONECORE_LICENSE_RENEWAL_DISCOUNT_TEXT', $daysUntilExpiry); ?>
				<?php else : ?>
					<?php echo Text::_('COM_ONECORE_LICENSE_RENEWAL_DISCOUNT_EXPIRED'); ?>
				<?php endif; ?>
			</div>
		</div>
		<a href="https://comdev.eu/renewal" target="_blank" class="onecore-renewal-btn">
			<?php echo Text::_('COM_ONECORE_LICENSE_RENEWAL_BUTTON'); ?> →
		</a>
	</div>
	<?php endif; ?>

	<!-- License Banner - only show if license is NOT active -->
	<?php if (!$isLicenseActive) : ?>
	<div class="onecore-upgrade-banner">
		<div class="onecore-upgrade-content">
			<div class="onecore-upgrade-title">🚀 Upgrade to OneCore Plus</div>
			<div class="onecore-upgrade-text">Unlock advanced features, priority support, and exclusive tools. Get more power for your listings!</div>
		</div>
		<div class="onecore-upgrade-buttons">
			<a href="https://comdev.eu/product-category/joomla-extensions/onecore/" target="_blank" rel="noopener noreferrer" class="onecore-buy-btn">
				<?php echo Text::_('COM_ONECORE_LICENSE_BUY_NOW'); ?>
			</a>
			<button type="button" class="onecore-upgrade-btn" onclick="document.getElementById('license-activation-form').style.display = 'block'; this.parentElement.style.display = 'none';">
				<?php echo Text::_('COM_ONECORE_LICENSE_ACTIVATE_BUTTON'); ?> →
			</button>
		</div>
	</div>
	<?php endif; ?>

	<!-- License Activation Form -->
	<?php if (!$isLicenseActive) : ?>
	<div id="license-activation-form" class="onecore-license-form" style="display: none;">
		<div class="onecore-license-form-content">
			<h3><?php echo Text::_('COM_ONECORE_LICENSE_ACTIVATION'); ?></h3>
			<p><?php echo Text::_('COM_ONECORE_LICENSE_ACTIVATION_DESC'); ?></p>
			<form action="<?php echo Route::_('index.php?option=com_onecore&task=license.activate'); ?>" method="post" id="license-activation-form-submit">
				<?php echo HTMLHelper::_('form.token'); ?>
				<div class="onecore-license-form-group">
					<label for="license_key"><?php echo Text::_('COM_ONECORE_LICENSE_KEY_LABEL'); ?></label>
					<input type="text" id="license_key" name="license_key" class="form-control" 
						value="<?php echo htmlspecialchars($licenseKey); ?>" 
						placeholder="<?php echo Text::_('COM_ONECORE_LICENSE_KEY_PLACEHOLDER'); ?>" required>
				</div>
				<div class="onecore-license-form-actions">
					<button type="submit" class="btn btn-primary" id="license-activate-button"><?php echo Text::_('COM_ONECORE_LICENSE_ACTIVATE_BUTTON'); ?></button>
					<button type="button" class="btn btn-secondary" onclick="document.getElementById('license-activation-form').style.display = 'none'; document.querySelector('.onecore-upgrade-buttons').style.display = 'flex';"><?php echo Text::_('JCANCEL'); ?></button>
				</div>
			</form>
			<?php if (!empty($licenseKey)) : ?>
			<div class="onecore-license-form-actions" style="margin-top: 10px;">
				<form action="<?php echo Route::_('index.php?option=com_onecore&task=license.check'); ?>" method="post" style="display: inline;">
					<?php echo HTMLHelper::_('form.token'); ?>
					<button type="submit" class="btn btn-info"><?php echo Text::_('COM_ONECORE_LICENSE_CHECK_STATUS'); ?></button>
				</form>
			</div>
			<?php endif; ?>
			<?php if (!empty($licenseKey) && $licenseStatus !== 'active') : ?>
			<div class="onecore-license-status-info">
				<strong><?php echo Text::_('COM_ONECORE_LICENSE_CURRENT_STATUS'); ?>:</strong> 
				<span class="license-status-<?php echo $licenseStatus; ?>"><?php echo Text::_('COM_ONECORE_LICENSE_STATUS_' . strtoupper($licenseStatus)); ?></span>
				<?php if (!empty($licenseInfo['last_check_formatted'])) : ?>
				<br><small><?php echo Text::_('COM_ONECORE_LICENSE_LAST_CHECK'); ?>: <?php echo $licenseInfo['last_check_formatted']; ?></small>
				<?php endif; ?>
			</div>
			<?php endif; ?>
		</div>
	</div>
	<?php endif; ?>

	<div class="onecore-dashboard-content">
		<!-- Dashboard Header -->
		<div class="onecore-dashboard-header">
			<div>
				<h1 class="onecore-dashboard-title">Dashboard</h1>
				<p class="onecore-dashboard-subtitle">Plan, prioritize, and accomplish your tasks with ease.</p>
			</div>
			<a href="<?php echo Route::_('index.php?option=com_onecore&view=content&layout=edit'); ?>" class="onecore-add-content-btn">
				<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
					<line x1="12" y1="5" x2="12" y2="19" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
					<line x1="5" y1="12" x2="19" y2="12" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
				</svg>
				Add Content
			</a>
		</div>

		<!-- First Row: 4 Stat Cards -->
		<div class="row g-4 mb-4">
			<div class="col-md-3 col-sm-6">
				<div class="onecore-stat-card">
					<div class="onecore-stat-icon onecore-stat-icon--listings" aria-hidden="true">
						<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
							<path d="M9 6h11" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
							<path d="M9 12h11" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
							<path d="M9 18h11" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
							<path d="M4 6h.01" fill="none" stroke="currentColor" stroke-width="4" stroke-linecap="round"/>
							<path d="M4 12h.01" fill="none" stroke="currentColor" stroke-width="4" stroke-linecap="round"/>
							<path d="M4 18h.01" fill="none" stroke="currentColor" stroke-width="4" stroke-linecap="round"/>
						</svg>
					</div>
					<div class="onecore-stat-label">Total Listings</div>
					<div class="onecore-stat-value"><?php echo number_format($stats['total_content']); ?></div>
					<?php if ($stats['recent_content'] > 0) : ?>
						<div class="onecore-stat-change">
							<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
								<polyline points="23 6 13.5 15.5 8.5 10.5 1 18" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<polyline points="17 6 23 6 23 12" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
							<?php echo $stats['recent_content']; ?> Increased from last month
						</div>
					<?php else : ?>
						<div class="onecore-stat-change gray">No changes</div>
					<?php endif; ?>
				</div>
			</div>

			<div class="col-md-3 col-sm-6">
				<div class="onecore-stat-card">
					<div class="onecore-stat-icon onecore-stat-icon--events" aria-hidden="true">
						<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
							<rect x="3" y="5" width="18" height="16" rx="2" ry="2" fill="none" stroke="currentColor" stroke-width="2"/>
							<path d="M16 3v4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
							<path d="M8 3v4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
							<path d="M3 11h18" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
						</svg>
					</div>
					<div class="onecore-stat-label">Total Events</div>
					<div class="onecore-stat-value"><?php echo number_format($stats['total_events'] ?? 0); ?></div>
					<div class="onecore-stat-change gray">All events</div>
				</div>
			</div>

			<div class="col-md-3 col-sm-6">
				<div class="onecore-stat-card">
					<div class="onecore-stat-icon onecore-stat-icon--featured" aria-hidden="true">
						<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
							<path d="M12 17.3l-6.18 3.25 1.18-6.88L1.99 8.99l6.9-1 3.11-6.25 3.11 6.25 6.9 1-4.99 4.68 1.18 6.88z"
								fill="none" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
						</svg>
					</div>
					<div class="onecore-stat-label">Featured Listings</div>
					<div class="onecore-stat-value"><?php echo number_format($stats['featured_content']); ?></div>
					<?php if ($stats['featured_content'] > 0) : ?>
						<div class="onecore-stat-change">
							<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
								<polyline points="23 6 13.5 15.5 8.5 10.5 1 18" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<polyline points="17 6 23 6 23 12" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
							<?php echo $stats['featured_content']; ?> Active featured
						</div>
					<?php else : ?>
						<div class="onecore-stat-change gray">No featured listings</div>
					<?php endif; ?>
				</div>
			</div>

			<div class="col-md-3 col-sm-6">
				<div class="onecore-stat-card">
					<div class="onecore-stat-icon onecore-stat-icon--users" aria-hidden="true">
						<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
							<path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
							<path d="M9 11a4 4 0 1 0 0-8 4 4 0 0 0 0 8z" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
							<path d="M22 21v-2a4 4 0 0 0-3-3.87" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
							<path d="M16 3.13a4 4 0 0 1 0 7.75" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
						</svg>
					</div>
					<div class="onecore-stat-label">All Users</div>
					<div class="onecore-stat-value"><?php echo number_format($stats['all_users']); ?></div>
					<div class="onecore-stat-change gray">Content creators</div>
				</div>
			</div>
		</div>

		<!-- Second Row: Chart and Info -->
		<div class="row g-4 mb-4">
			<div class="col-md-8">
				<div class="onecore-chart-card">
					<div class="onecore-chart-title">Listings Per Day</div>
					<div class="onecore-chart-container" style="position: relative;">
						<canvas id="onecore-chart-canvas" width="400" height="200" style="display: none;"></canvas>
						<div id="onecore-chart-loading" style="text-align: center; color: #94a3b8; padding: 40px; position: absolute; top: 0; left: 0; right: 0; bottom: 0; display: flex; align-items: center; justify-content: center;">Loading chart data...</div>
						<div id="onecore-chart-error" style="text-align: center; color: #ef4444; padding: 40px; position: absolute; top: 0; left: 0; right: 0; bottom: 0; display: none; align-items: center; justify-content: center;">Error loading chart data</div>
					</div>
				</div>
			</div>
			<div class="col-md-4">
				<div class="onecore-info-card">
					<div class="onecore-info-title">Quick Info</div>
					<p class="onecore-info-text">
						Manage your listings efficiently with OneCore. Use the dashboard to track your content, 
						categories, and user activity. Create new listings using the "Add Content" button above.
					</p>
					<p class="onecore-info-text" style="margin-top: 16px;">
						Monitor your featured listings and pending reviews to keep your content up to date.
					</p>
				</div>
			</div>
		</div>

		<!-- Third Row: Next Steps and Sidebar -->
		<div class="row g-4">
			<div class="col-md-8">
				<div class="onecore-changelog-card">
					<div class="onecore-changelog-title">Next Steps</div>
					<?php if (!$isLicenseActive) : ?>
						<!-- Free version - Upgrade prompt -->
						<div class="onecore-changelog-item mt-0">
							<h3 class="mb-3">🚀 Upgrade to PLUS!</h3>
							<div class="onecore-version-subtitle mt-2 mb-2">Get more features!</div>
							<div class="onecore-version-description">
								Unlock advanced features, priority support, and exclusive tools. Activate your license to get access to premium functionality including custom field types, enhanced analytics, and more!
							</div>
						</div>
						<div class="onecore-changelog-item">
							<h4>Getting Started</h4>
							<div class="onecore-changelog-date">Recommended actions</div>
							<div class="onecore-changelog-text">
								1. <a href="<?php echo Route::_('index.php?option=com_onecore&view=categories'); ?>" style="color: #3b82f6; text-decoration: none;">Add some categories</a> to organize your listings<br>
								2. <a href="<?php echo Route::_('index.php?option=com_onecore&view=customfields'); ?>" style="color: #3b82f6; text-decoration: none;">Add some custom fields</a> to enhance your content<br>
								3. <a href="<?php echo Route::_('index.php?option=com_onecore&view=content&layout=edit'); ?>" style="color: #3b82f6; text-decoration: none;">Create your first listing</a><br>
								4. <a href="<?php echo Route::_('index.php?option=com_onecore&view=events'); ?>" style="color: #3b82f6; text-decoration: none;">Create an event</a> (recurrence is PLUS only)<br>
								5. <a href="<?php echo Route::_('index.php?option=com_config&view=component&component=com_onecore'); ?>" style="color: #3b82f6; text-decoration: none;">Configure map settings</a> for location-based listings
							</div>
						</div>
					<?php else : ?>
						<!-- Plus version - Next steps -->
						<div class="onecore-changelog-item">
							<h4>🎉 Congratulations!</h4>
							<div class="onecore-dashboard-subtitle">You are using the PLUS version</div>
							<div class="onecore-changelog-text">
								Here are some next steps to get the most out of OneCore Plus:
							</div>
						</div>
						<div class="onecore-changelog-item">
							<h4>Getting Started</h4>
							<div class="onecore-changelog-date">Recommended actions</div>
							<div class="onecore-changelog-text">
								1. <a href="<?php echo Route::_('index.php?option=com_onecore&view=categories'); ?>" style="color: #3b82f6; text-decoration: none;">Add some categories</a> to organize your listings<br>
								2. <a href="<?php echo Route::_('index.php?option=com_onecore&view=customfields'); ?>" style="color: #3b82f6; text-decoration: none;">Add some custom fields</a> to enhance your content<br>
								3. <a href="<?php echo Route::_('index.php?option=com_onecore&view=content&layout=edit'); ?>" style="color: #3b82f6; text-decoration: none;">Create your first listing</a> with all the premium features<br>
								4. Explore advanced custom field types (available in PLUS)<br>
								5. <a href="<?php echo Route::_('index.php?option=com_config&view=component&component=com_onecore'); ?>" style="color: #3b82f6; text-decoration: none;">Configure map settings</a> for location-based listings
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
			<div class="col-md-4">
				<div class="onecore-sidebar-card <?php echo $isLicenseActive ? 'license-plus' : ''; ?>">
					<div class="onecore-sidebar-version">
						<?php echo htmlspecialchars($componentVersionName); ?> <?php echo htmlspecialchars($stats['component_version']); ?>
						<span class="onecore-license-status-badge <?php echo $isLicenseActive ? 'license-plus' : 'license-free'; ?>">
							<?php echo $isLicenseActive ? Text::_('COM_ONECORE_LICENSE_PLUS') : Text::_('COM_ONECORE_LICENSE_FREE'); ?>
						</span>
					</div>
					<?php if ($isLicenseActive) : ?>

					<?php endif; ?>
					<div class="onecore-sidebar-links">
						<a href="#" class="onecore-sidebar-link" onclick="alert('Support - Contact us for assistance'); return false;">
							<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
								<path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
							<span class="onecore-sidebar-link-text">Support</span>
						</a>
						<a href="#" class="onecore-sidebar-link" onclick="alert('Documentation - Visit our docs'); return false;">
							<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
								<path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<polyline points="14 2 14 8 20 8" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
							<span class="onecore-sidebar-link-text">Documentation</span>
						</a>
						<a href="#" class="onecore-sidebar-link" onclick="alert('Updates - Check for new versions'); return false;">
							<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
								<polyline points="23 4 23 10 17 10" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<polyline points="1 20 1 14 7 14" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
								<path d="M3.51 9a9 9 0 0 1 14.85-3.36L23 10M1 14l4.64 4.36A9 9 0 0 0 20.49 15" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
							</svg>
							<span class="onecore-sidebar-link-text">Check Updates</span>
						</a>
						<a href="<?php echo Route::_('index.php?option=com_config&view=component&component=com_onecore'); ?>" class="onecore-sidebar-link">
							<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
								<circle cx="12" cy="12" r="3" fill="none" stroke="currentColor" stroke-width="2"/>
								<path d="M12 1v6m0 6v6M5.64 5.64l4.24 4.24m4.24 4.24l4.24 4.24M1 12h6m6 0h6M5.64 18.36l4.24-4.24m4.24-4.24l4.24-4.24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
							</svg>
							<span class="onecore-sidebar-link-text">Settings</span>
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
	// License activation form handling
	const licenseForm = document.getElementById('license-activation-form-submit');
	if (licenseForm) {
		licenseForm.addEventListener('submit', function(e) {
			// Show loading state
			const submitButton = document.getElementById('license-activate-button');
			if (submitButton) {
				const originalText = submitButton.textContent;
				submitButton.disabled = true;
				submitButton.textContent = 'Activating...';
				
				// Re-enable after 30 seconds in case of no redirect
				setTimeout(function() {
					if (submitButton.disabled) {
						submitButton.disabled = false;
						submitButton.textContent = originalText;
					}
				}, 30000);
			}
		});
	}
	
	// Animate numbers on load
	const statValues = document.querySelectorAll('.onecore-stat-value');
	statValues.forEach(function(el) {
		const text = el.textContent.replace(/,/g, '');
		const finalValue = parseInt(text);
		if (!isNaN(finalValue) && finalValue > 0) {
			let current = 0;
			const increment = finalValue / 40;
			const timer = setInterval(function() {
				current += increment;
				if (current >= finalValue) {
					el.textContent = finalValue.toLocaleString();
					clearInterval(timer);
				} else {
					el.textContent = Math.floor(current).toLocaleString();
				}
			}, 25);
		}
	});

	// Load chart data via AJAX
	const canvas = document.getElementById('onecore-chart-canvas');
	const loading = document.getElementById('onecore-chart-loading');
	const error = document.getElementById('onecore-chart-error');
	
	if (canvas) {
		const ctx = canvas.getContext('2d');
		const container = canvas.parentElement;
		
		// Set canvas size
		function resizeCanvas() {
			const rect = container.getBoundingClientRect();
			canvas.width = rect.width - 48; // padding
			canvas.height = 200;
		}
		resizeCanvas();
		window.addEventListener('resize', resizeCanvas);
		
		// Get CSRF token
		const token = Joomla.getOptions('csrf.token', '');
		
		// Load chart data via AJAX
		Joomla.request({
			url: 'index.php?option=com_onecore&task=display.getChartData&format=json' + (token ? '&' + token + '=1' : ''),
			method: 'GET',
			onSuccess: function(response) {
				try {
					console.log('Chart response:', response);
					// Remove PHP warnings/notices before JSON (they appear as HTML)
					let cleanResponse = response;
					// Try to extract JSON if response contains HTML warnings
					const jsonMatch = cleanResponse.match(/\{[\s\S]*\}/);
					if (jsonMatch) {
						cleanResponse = jsonMatch[0];
					}
					const data = JSON.parse(cleanResponse);
					console.log('Parsed data:', data);
					
					// JsonResponse returns data in 'data' property
					// Structure: { success: true, message: null, messages: null, data: { labels: [], data: [], max: 0 } }
					let chartData = null;
					
					if (data && data.data && typeof data.data === 'object' && Array.isArray(data.data.labels) && Array.isArray(data.data.data)) {
						// JsonResponse format
						chartData = data.data;
					} else if (data && data.labels && data.data && Array.isArray(data.labels) && Array.isArray(data.data)) {
						// Direct data structure (fallback)
						chartData = data;
					} else if (data && data.success === false) {
						// Error response
						console.error('Chart data error:', data.message || 'Unknown error');
						loading.style.display = 'none';
						error.style.display = 'block';
						return;
					}
					
					if (chartData && Array.isArray(chartData.labels) && Array.isArray(chartData.data)) {
						loading.style.display = 'none';
						error.style.display = 'none';
						canvas.style.display = 'block';
						drawChart(ctx, canvas, chartData);
					} else {
						console.error('Invalid chart data structure:', chartData);
						loading.style.display = 'none';
						error.style.display = 'flex';
						canvas.style.display = 'none';
					}
				} catch (e) {
					console.error('Chart data parse error:', e, 'Response:', response);
					loading.style.display = 'none';
					error.style.display = 'flex';
					canvas.style.display = 'none';
				}
			},
			onError: function(xhr) {
				console.error('Chart data load error:', xhr);
				loading.style.display = 'none';
				error.style.display = 'flex';
				canvas.style.display = 'none';
			}
		});
		
		function drawChart(ctx, canvas, chartData) {
			const labels = chartData.labels || [];
			const data = chartData.data || [];
			const max = chartData.max || 1;
			
			if (labels.length === 0 || data.length === 0) {
				ctx.fillStyle = '#94a3b8';
				ctx.font = '14px -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif';
				ctx.textAlign = 'center';
				ctx.fillText('No data available', canvas.width / 2, canvas.height / 2);
				return;
			}
			
			const padding = 40;
			const chartWidth = canvas.width - (padding * 2);
			const chartHeight = canvas.height - (padding * 2);
			const barWidth = chartWidth / labels.length;
			const barSpacing = barWidth * 0.2;
			const actualBarWidth = barWidth - barSpacing;
			
			// Clear canvas
			ctx.clearRect(0, 0, canvas.width, canvas.height);
			
			// Draw grid lines
			ctx.strokeStyle = '#e2e8f0';
			ctx.lineWidth = 1;
			for (let i = 0; i <= 5; i++) {
				const y = padding + (chartHeight / 5) * i;
				ctx.beginPath();
				ctx.moveTo(padding, y);
				ctx.lineTo(canvas.width - padding, y);
				ctx.stroke();
			}
			
			// Draw bars
			data.forEach(function(value, index) {
				const barHeight = max > 0 ? (value / max) * chartHeight : 0;
				const x = padding + (index * barWidth) + (barSpacing / 2);
				const y = padding + chartHeight - barHeight;
				
				// Bar gradient
				const gradient = ctx.createLinearGradient(x, y, x, y + barHeight);
				gradient.addColorStop(0, '#3b82f6');
				gradient.addColorStop(1, '#1d4ed8');
				
				// Draw bar
				ctx.fillStyle = gradient;
				ctx.fillRect(x, y, actualBarWidth, barHeight);
				
				// Bar border
				ctx.strokeStyle = '#1e40af';
				ctx.lineWidth = 1;
				ctx.strokeRect(x, y, actualBarWidth, barHeight);
				
				// Value label on top
				if (value > 0) {
					ctx.fillStyle = '#1e293b';
					ctx.font = '12px -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif';
					ctx.textAlign = 'center';
					ctx.fillText(value, x + (actualBarWidth / 2), y - 5);
				}
				
				// Day label at bottom
				ctx.fillStyle = '#64748b';
				ctx.font = '11px -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif';
				ctx.textAlign = 'center';
				ctx.fillText(labels[index], x + (actualBarWidth / 2), canvas.height - 10);
			});
		}
	}
});
</script>