<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Comdev\Component\Onecore\Administrator\Helper\LicenseHelper;

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('keepalive')
	->useScript('form.validate');

// Check license for Plus features
$isLicensePlus = LicenseHelper::getLicenseType() === 'plus';
$canAddPlusFeatures = LicenseHelper::canAddPlusFeatures();
$isLicenseExpired = LicenseHelper::isLicenseExpired();

// Check if this is existing field (editing) or new field
$itemId = 0;
$currentFieldType = '';
if (isset($this->item) && is_object($this->item)) {
	$itemId = (int) ($this->item->id ?? 0);
	$currentFieldType = $this->item->type ?? '';
} elseif ($this->form) {
	$itemId = (int) $this->form->getValue('id', null, 0);
	$currentFieldType = $this->form->getValue('type', null, '');
}

$isExistingField = ($itemId > 0);
$isCurrentFieldPlus = in_array($currentFieldType, ['select', 'multiselect'], true);

// Dynamic UI: show configuration only after type selection, and show height only for textarea
$document = \Joomla\CMS\Factory::getApplication()->getDocument();
$document->addScriptDeclaration("
(function() {
	'use strict';

	function closestControlGroup(el) {
		if (!el) return null;
		if (el.closest) {
			return el.closest('.control-group, .control-group .controls, .control-group .control-label')?.closest?.('.control-group') || el.closest('.control-group');
		}
		return null;
	}

	function setVisible(wrapper, visible) {
		if (!wrapper) return;
		wrapper.style.display = visible ? '' : 'none';
	}

	function toggleConfigurationFields() {
		var typeSelect = document.getElementById('jform_type');
		var heightInput = document.getElementById('jform_height');
		
		if (!typeSelect) return;

		var type = (typeSelect.value || '').toLowerCase();
		var hasType = type === 'input' || type === 'textarea';

		// Find configuration tab (Joomla uses data-bs-target or href for tabs)
		var configTabLink = null;
		var configTabPane = null;
		
		// Try to find tab link by text content or ID
		var allTabLinks = document.querySelectorAll('[role=\"tab\"], .nav-link, a[data-bs-toggle=\"tab\"]');
		allTabLinks.forEach(function(link) {
			var linkText = link.textContent || link.innerText || '';
			if (linkText.indexOf('Configuration') !== -1 || linkText.indexOf('Konfiguracja') !== -1 || 
			    (link.getAttribute('href') && link.getAttribute('href').indexOf('configuration') !== -1)) {
				configTabLink = link;
			}
		});
		
		// Find tab pane
		if (configTabLink) {
			var targetId = configTabLink.getAttribute('href') || configTabLink.getAttribute('data-bs-target') || '';
			if (targetId.startsWith('#')) {
				targetId = targetId.substring(1);
			}
			configTabPane = document.getElementById(targetId);
		}
		
		// Fallback: find by fieldset name
		if (!configTabPane) {
			var configFieldset = document.querySelector('fieldset[name=\"configuration\"], .onecore-cf-configuration');
			if (configFieldset) {
				configTabPane = configFieldset.closest('.tab-pane');
			}
		}

		// Show/hide configuration tab and pane
		if (configTabLink && configTabPane) {
			if (hasType) {
				configTabLink.style.display = '';
				configTabPane.style.display = '';
				// If tab is active, ensure it's visible
				if (configTabPane.classList.contains('active') || configTabPane.classList.contains('show')) {
					configTabPane.style.display = '';
				}
			} else {
				configTabLink.style.display = 'none';
				configTabPane.style.display = 'none';
				// If this tab was active, switch to basic tab
				if (configTabPane.classList.contains('active') || configTabPane.classList.contains('show')) {
					var basicTabLink = document.querySelector('[href*=\"basic\"], [data-bs-target*=\"basic\"]');
					if (basicTabLink) {
						basicTabLink.click();
					}
				}
			}
		} else {
			// Fallback: hide all fields in configuration except type
			var configFields = document.querySelectorAll('.onecore-cf-configuration .control-group, fieldset[name=\"configuration\"] .control-group');
			configFields.forEach(function(field) {
				if (!field.querySelector('.onecore-cf-type-selector')) {
					setVisible(field, hasType);
				}
			});
		}

		// Show/hide height field only for textarea
		if (heightInput) {
			var wrapper = closestControlGroup(heightInput) || heightInput.parentElement;
			var isTextarea = type === 'textarea';
			setVisible(wrapper, isTextarea && hasType);

			// Disable + normalize value when hidden
			if (!isTextarea) {
				heightInput.value = '0';
				heightInput.disabled = true;
			} else {
				heightInput.disabled = false;
			}
		}

		// Disable searchable field for textarea type
		var searchableField = document.querySelector('.onecore-cf-searchable');
		if (searchableField) {
			// Find the control group containing the searchable field
			var searchableWrapper = closestControlGroup(searchableField) || searchableField.closest('.control-group');
			var isTextareaType = type === 'textarea';
			
			// Find all radio inputs within the searchable field wrapper
			var searchableInputs = [];
			if (searchableWrapper) {
				searchableInputs = searchableWrapper.querySelectorAll('input[type=\"radio\"], input[type=\"checkbox\"]');
			} else {
				searchableInputs = searchableField.querySelectorAll('input[type=\"radio\"], input[type=\"checkbox\"]');
			}
			
			if (searchableInputs.length > 0) {
				searchableInputs.forEach(function(input) {
					input.disabled = isTextareaType;
					if (isTextareaType) {
						// Uncheck all options when disabled
						input.checked = false;
					}
				});
			}
			
			// Add visual indication that field is disabled
			if (searchableWrapper) {
				if (isTextareaType) {
					searchableWrapper.classList.add('disabled');
					searchableWrapper.style.opacity = '0.6';
					searchableWrapper.style.pointerEvents = 'none';
				} else {
					searchableWrapper.classList.remove('disabled');
					searchableWrapper.style.opacity = '';
					searchableWrapper.style.pointerEvents = '';
				}
			}
		}
	}

	// Hide Plus options if license expired (but allow editing existing Plus fields)
	function togglePlusOptions() {
		var typeSelect = document.getElementById('jform_type');
		if (!typeSelect) return;
		
		var canAddPlusFeatures = <?php echo $canAddPlusFeatures ? 'true' : 'false'; ?>;
		var isExistingField = <?php echo $isExistingField ? 'true' : 'false'; ?>;
		var isCurrentFieldPlus = <?php echo $isCurrentFieldPlus ? 'true' : 'false'; ?>;
		var currentFieldType = '<?php echo htmlspecialchars($currentFieldType, ENT_QUOTES, 'UTF-8'); ?>';
		
		// Find select and multiselect options
		var selectOption = null;
		var multiselectOption = null;
		
		for (var i = 0; i < typeSelect.options.length; i++) {
			if (typeSelect.options[i].value === 'select') {
				selectOption = typeSelect.options[i];
			} else if (typeSelect.options[i].value === 'multiselect') {
				multiselectOption = typeSelect.options[i];
			}
		}
		
		// If editing existing Plus field, allow it
		if (isExistingField && isCurrentFieldPlus) {
			// Allow editing existing Plus fields
			if (selectOption) {
				selectOption.style.display = '';
				selectOption.disabled = false;
			}
			if (multiselectOption) {
				multiselectOption.style.display = '';
				multiselectOption.disabled = false;
			}
		} else if (!canAddPlusFeatures) {
			// License expired - hide Plus options for new fields
			if (selectOption) {
				selectOption.style.display = 'none';
				selectOption.disabled = true;
			}
			if (multiselectOption) {
				multiselectOption.style.display = 'none';
				multiselectOption.disabled = true;
			}
			
			// If Plus type is currently selected and it's a new field, reset to input
			if (!isExistingField && (typeSelect.value === 'select' || typeSelect.value === 'multiselect')) {
				typeSelect.value = 'input';
				toggleConfigurationFields();
			}
		} else {
			// License active - show Plus options
			if (selectOption) {
				selectOption.style.display = '';
				selectOption.disabled = false;
			}
			if (multiselectOption) {
				multiselectOption.style.display = '';
				multiselectOption.disabled = false;
			}
		}
	}

	document.addEventListener('DOMContentLoaded', function() {
		// Initial state: hide configuration if no type selected
		toggleConfigurationFields();
		togglePlusOptions();
		
		var typeSelect = document.getElementById('jform_type');
		if (typeSelect) {
			typeSelect.addEventListener('change', function() {
				toggleConfigurationFields();
				togglePlusOptions();
			});
		}
	});
})();
");
?>

<?php if ($this->form && $this->form->getField('title')) : ?>
<form action="<?php echo Route::_('index.php?option=com_onecore&view=customfields&layout=edit&id=' . (int) ($this->item->id ?? 0)); ?>" method="post" name="adminForm" id="customfield-form" aria-label="<?php echo Text::_('COM_ONECORE_CUSTOMFIELD_FORM_TITLE_' . ((int) ($this->item->id ?? 0) === 0 ? 'NEW' : 'EDIT'), true); ?>" class="form-validate">

	<div class="main-card">
		<?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', ['active' => 'basic', 'recall' => true, 'breakpoint' => 768]); ?>
		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'basic', Text::_('JGLOBAL_BASIC_OPTIONS')); ?>

		<div class="row">
			<div class="col-lg-12">
				<?php echo $this->form->renderFieldset('basic'); ?>
			</div>
		</div>

		<?php echo HTMLHelper::_('uitab.endTab'); ?>
		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'configuration', Text::_('COM_ONECORE_CUSTOMFIELD_CONFIGURATION')); ?>

		<div class="row">
			<div class="col-lg-12">
				<?php echo $this->form->renderFieldset('configuration'); ?>
			</div>
		</div>

		<?php echo HTMLHelper::_('uitab.endTab'); ?>
		<?php echo HTMLHelper::_('uitab.endTabSet'); ?>

		<?php echo $this->form->renderControlFields(); ?>
		<input type="hidden" name="task" value="">
	</div>
</form>
<?php else : ?>
	<div class="alert alert-danger">
		<?php echo Text::_('COM_ONECORE_ERROR_FORM_NOT_LOADED'); ?>
	</div>
<?php endif; ?>

