<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.multiselect');

$listOrder = $this->escape(($this->state && $this->state->get('list.ordering')) ? $this->state->get('list.ordering') : 'a.ordering');
$listDirn  = $this->escape(($this->state && $this->state->get('list.direction')) ? $this->state->get('list.direction') : 'asc');
?>

<form action="<?php echo Route::_('index.php?option=com_onecore&view=customfields'); ?>" method="post" name="adminForm" id="adminForm">
	<div class="row">
		<div class="col-md-12">
			<div id="j-main-container" class="j-main-container">
				<?php echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>

				<?php if (empty($this->items)) : ?>
					<div class="alert alert-info">
						<span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
						<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
					</div>
				<?php else : ?>
					<table class="table" id="customfieldsList">
						<thead>
							<tr>
								<td class="w-1 text-center">
									<?php echo HTMLHelper::_('grid.checkall'); ?>
								</td>
								<th scope="col" class="w-1 text-center d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
								</th>
								<th scope="col">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.title', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-10 d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_CUSTOMFIELD_TYPE', 'a.type', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-5 d-none d-md-table-cell text-center">
									<?php echo Text::_('COM_ONECORE_CUSTOMFIELD_REQUIRED'); ?>
								</th>
								<th scope="col" class="w-5 d-none d-md-table-cell text-center">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_CUSTOMFIELD_SEARCHABLE', 'a.searchable', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-15 d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'COM_ONECORE_CUSTOMFIELD_GROUP', 'g.title', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-10 d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ORDERING', 'a.ordering', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-3 d-none d-lg-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($this->items as $i => $item) : ?>
								<tr class="row<?php echo $i % 2; ?>">
									<td class="text-center">
										<?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
									</td>
									<td class="text-center d-none d-md-table-cell">
										<?php echo HTMLHelper::_('jgrid.published', $item->published ?? 0, $i, 'customfields.', true, 'cb'); ?>
									</td>
									<th scope="row" class="has-context">
										<a href="<?php echo Route::_('index.php?option=com_onecore&task=customfields.edit&id=' . (int) $item->id); ?>">
											<?php echo $this->escape($item->title ?? ''); ?>
										</a>
									</th>
									<td class="d-none d-md-table-cell">
										<?php echo $this->escape($item->type ?? ''); ?>
									</td>
									<td class="d-none d-md-table-cell text-center">
										<?php echo !empty($item->required) ? Text::_('JYES') : Text::_('JNO'); ?>
									</td>
									<td class="d-none d-md-table-cell text-center">
										<?php echo !empty($item->searchable) ? Text::_('JYES') : Text::_('JNO'); ?>
									</td>
									<td class="d-none d-md-table-cell">
										<?php if (!empty($item->group_title)) : ?>
											<a href="<?php echo Route::_('index.php?option=com_onecore&task=customfieldgroups.edit&id=' . (int) ($item->group_id ?? 0)); ?>">
												<?php echo $this->escape($item->group_title); ?>
											</a>
										<?php else : ?>
											<span class="text-muted"><?php echo Text::_('JNONE'); ?></span>
										<?php endif; ?>
									</td>
									<td class="d-none d-md-table-cell">
										<?php echo (int) ($item->ordering ?? 0); ?>
									</td>
									<td class="d-none d-lg-table-cell">
										<?php echo (int) ($item->id ?? 0); ?>
									</td>
								</tr>
							<?php endforeach; ?>
						</tbody>
					</table>

					<?php if ($this->pagination) : ?>
						<?php echo $this->pagination->getListFooter(); ?>
					<?php endif; ?>
				<?php endif; ?>

				<input type="hidden" name="task" value="">
				<input type="hidden" name="boxchecked" value="0">
				<?php echo HTMLHelper::_('form.token'); ?>
			</div>
		</div>
	</div>
</form>

