<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');

$document = \Joomla\CMS\Factory::getApplication()->getDocument();
$document->addScriptDeclaration("
(function() {
	'use strict';
	
	function updatePosItemOptions() {
		var entityType = document.getElementById('jform_entity_type');
		var posItem = document.getElementById('jform_pos_item');
		
		if (!entityType || !posItem) {
			return;
		}
		
		var selectedValue = posItem.value;
		var isEvents = entityType.value === 'events';
		
		// Get all options
		var options = posItem.querySelectorAll('option');
		var sidebarOption = null;
		var modalOption = null;
		
		options.forEach(function(option) {
			var value = option.value;
			
			if (value === 'sidebar') {
				sidebarOption = option;
			} else if (value === 'modal') {
				modalOption = option;
			}
		});
		
		if (isEvents) {
			// For events: show sidebar, hide modal
			if (sidebarOption) {
				sidebarOption.style.display = '';
			}
			if (modalOption) {
				modalOption.style.display = 'none';
				// If modal was selected, change to sidebar
				if (selectedValue === 'modal') {
					posItem.value = 'sidebar';
				}
			}
		} else {
			// For content: show sidebar, hide modal
			if (sidebarOption) {
				sidebarOption.style.display = '';
			}
			if (modalOption) {
				modalOption.style.display = 'none';
				// If modal was selected, change to none
				if (selectedValue === 'modal') {
					posItem.value = 'none';
				}
			}
		}
	}
	
	// Run on page load
	if (document.readyState === 'loading') {
		document.addEventListener('DOMContentLoaded', function() {
			setTimeout(updatePosItemOptions, 100);
		});
	} else {
		setTimeout(updatePosItemOptions, 100);
	}
	
	// Run on entity_type change
	document.addEventListener('change', function(e) {
		if (e.target && e.target.id === 'jform_entity_type') {
			updatePosItemOptions();
		}
	});
})();
");
?>

<form action="<?php echo Route::_('index.php?option=com_onecore&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="customfieldgroup-form" class="form-validate">
	<div class="row">
		<div class="col-lg-9">
		<div class="card card-body">
				<?php echo $this->form->renderField('title'); ?>
				<?php echo $this->form->renderField('description'); ?>
			</div>
		</div>
		<div class="col-lg-3">
			<?php echo HTMLHelper::_('bootstrap.startTabSet', 'myTab', ['active' => 'details']); ?>
				<?php echo HTMLHelper::_('bootstrap.addTab', 'myTab', 'details', Text::_('JDETAILS')); ?>
					<div class="card card-body">
						<?php echo $this->form->renderField('entity_type'); ?>
						<?php echo $this->form->renderField('category_id'); ?>
						<?php echo $this->form->renderField('show_title'); ?>
						<?php echo $this->form->renderField('show_description'); ?>
						<?php echo $this->form->renderField('ordering'); ?>
						<?php echo $this->form->renderField('published'); ?>
					</div>
				<?php echo HTMLHelper::_('bootstrap.endTab'); ?>
				<?php echo HTMLHelper::_('bootstrap.addTab', 'myTab', 'display', Text::_('COM_ONECORE_CUSTOMFIELDGROUP_DISPLAY')); ?>
				<div class="card card-body">
					<?php echo $this->form->renderField('pos_items'); ?>
					<?php echo $this->form->renderField('pos_item'); ?>
					<?php echo $this->form->renderField('pos_module'); ?>
					</div>
				<?php echo HTMLHelper::_('bootstrap.endTab'); ?>
			<?php echo HTMLHelper::_('bootstrap.endTabSet'); ?>
		</div>
	</div>
	<input type="hidden" name="task" value="">
	<?php echo HTMLHelper::_('form.token'); ?>
</form>
