<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.multiselect');

$listOrder = $this->escape(($this->state && $this->state->get('list.ordering')) ? $this->state->get('list.ordering') : 'g.ordering');
$listDirn  = $this->escape(($this->state && $this->state->get('list.direction')) ? $this->state->get('list.direction') : 'asc');
?>

<form action="<?php echo Route::_('index.php?option=com_onecore&view=customfieldgroups'); ?>" method="post" name="adminForm" id="adminForm">
	<div class="row">
		<div class="col-md-12">
			<div id="j-main-container" class="j-main-container">
				<?php echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]); ?>

				<?php if (empty($this->items)) : ?>
					<div class="alert alert-info">
						<span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
						<?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
					</div>
				<?php else : ?>
					<table class="table" id="customfieldgroupsList">
						<thead>
							<tr>
								<td class="w-1 text-center">
									<?php echo HTMLHelper::_('grid.checkall'); ?>
								</td>
								<th scope="col" class="w-1 text-center d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'g.published', $listDirn, $listOrder); ?>
								</th>
								<th scope="col">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'g.title', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-10 d-none d-md-table-cell">
									<?php echo Text::_('COM_ONECORE_CUSTOMFIELDGROUP_ENTITY_TYPE'); ?>
								</th>
								<th scope="col" class="w-10 d-none d-md-table-cell">
									<?php echo HTMLHelper::_('searchtools.sort', 'JCATEGORY', 'g.category_id', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-5 d-none d-md-table-cell text-center">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ORDERING', 'g.ordering', $listDirn, $listOrder); ?>
								</th>
								<th scope="col" class="w-3 d-none d-md-table-cell text-center">
									<?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'g.id', $listDirn, $listOrder); ?>
								</th>
							</tr>
						</thead>
						<tbody>
							<?php foreach ($this->items as $i => $item) : ?>
								<?php $canEdit = true; ?>
								<tr class="row<?php echo $i % 2; ?>">
									<td class="text-center">
										<?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb', $item->title); ?>
									</td>
									<td class="text-center d-none d-md-table-cell">
										<?php echo HTMLHelper::_('jgrid.published', $item->published, $i, 'customfieldgroups.', true, 'cb'); ?>
									</td>
									<th scope="row" class="has-context">
										<div>
											<?php if ($canEdit) : ?>
												<a href="<?php echo Route::_('index.php?option=com_onecore&task=customfieldgroups.edit&id=' . $item->id); ?>" title="<?php echo Text::_('JACTION_EDIT'); ?> <?php echo $this->escape($item->title); ?>">
													<?php echo $this->escape($item->title); ?>
												</a>
											<?php else : ?>
												<?php echo $this->escape($item->title); ?>
											<?php endif; ?>
										</div>
									</th>
									<td class="d-none d-md-table-cell">
										<?php 
										if (!empty($item->entity_type)) {
											echo Text::_('COM_ONECORE_CUSTOMFIELDGROUP_ENTITY_TYPE_' . strtoupper($item->entity_type));
										} else {
											echo '<span class="text-muted">' . Text::_('JNONE') . '</span>';
										}
										?>
									</td>
									<td class="d-none d-md-table-cell">
										<?php echo $this->escape($item->category_title ?? ''); ?>
									</td>
									<td class="d-none d-md-table-cell text-center">
										<?php echo $item->ordering; ?>
									</td>
									<td class="d-none d-md-table-cell text-center">
										<?php echo (int) $item->id; ?>
									</td>
								</tr>
							<?php endforeach; ?>
						</tbody>
					</table>
				<?php endif; ?>

				<?php echo $this->pagination->getListFooter(); ?>
			</div>
		</div>
	</div>
	<input type="hidden" name="task" value="">
	<input type="hidden" name="boxchecked" value="0">
	<?php echo HTMLHelper::_('form.token'); ?>
</form>
