<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

\defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->getDocument()->getWebAssetManager();
$wa->useScript('keepalive')
    ->useScript('form.validate');
?>

<?php if ($this->form && $this->form->getField('title')) : ?>
<form action="<?php echo Route::_('index.php?option=com_onecore&view=category&layout=edit&id=' . (int) ($this->item->id ?? 0)); ?>" method="post" name="adminForm" id="category-form" aria-label="<?php echo Text::_('COM_ONECORE_CATEGORY_FORM_TITLE_' . ((int) ($this->item->id ?? 0) === 0 ? 'NEW' : 'EDIT'), true); ?>" class="form-validate">

	<?php echo LayoutHelper::render('joomla.edit.title_alias', $this); ?>

	<div class="main-card">
		<?php echo HTMLHelper::_('uitab.startTabSet', 'myTab', ['active' => 'general', 'recall' => true, 'breakpoint' => 768]); ?>
		<?php echo HTMLHelper::_('uitab.addTab', 'myTab', 'general', Text::_('JCATEGORY')); ?>
		<div class="row">
			<div class="col-lg-9">
				<?php if ($this->form->getField('description')) : ?>
					<?php echo $this->form->getLabel('description'); ?>
					<?php echo $this->form->getInput('description'); ?>
				<?php endif; ?>
			</div>
			<div class="col-lg-3">
				<?php echo LayoutHelper::render('joomla.edit.global', $this); ?>
			</div>
		</div>

		<?php echo HTMLHelper::_('uitab.endTab'); ?>

		<?php echo LayoutHelper::render('joomla.edit.params', $this); ?>

		<?php echo HTMLHelper::_('uitab.endTabSet'); ?>

		<?php echo $this->form->renderControlFields(); ?>
		<input type="hidden" name="task" value="">
	</div>
</form>
<?php else : ?>
	<div class="alert alert-danger">
		<?php if (!$this->form) : ?>
			<?php echo Text::_('COM_ONECORE_ERROR_FORM_NOT_LOADED'); ?>
		<?php else : ?>
			<?php echo Text::_('COM_ONECORE_ERROR_FORM_FIELDS_NOT_LOADED'); ?>
			<?php if ($this->form->getField('title')) : ?>
				<p>Form has title field</p>
			<?php else : ?>
				<p>Form does NOT have title field. Form XML may not be loaded correctly.</p>
			<?php endif; ?>
		<?php endif; ?>
	</div>
<?php endif; ?>

