<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\View\Customfields;

use Comdev\Component\Onecore\Administrator\Helper\LicenseHelper;
use Comdev\Component\Onecore\Administrator\Helper\OneCoreHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Customfields view class.
 *
 * @since  1.0.4
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * The Form object
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	protected $form;

	/**
	 * The active item
	 *
	 * @var  object
	 */
	protected $item;

	/**
	 * The model state
	 *
	 * @var  \Joomla\Registry\Registry
	 */
	protected $state;

	/**
	 * Items list
	 *
	 * @var  array
	 */
	protected $items;

	/**
	 * Pagination
	 *
	 * @var  \Joomla\CMS\Pagination\Pagination
	 */
	protected $pagination;

	/**
	 * Filter form
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	public $filterForm;

	/**
	 * Active filters
	 *
	 * @var  array
	 */
	public $activeFilters;

	/**
	 * Method to get the model object
	 * Override to avoid undefined array key error
	 *
	 * @param   string  $name  The name of the model (optional)
	 *
	 * @return  \Joomla\CMS\MVC\Model\BaseDatabaseModel|null  The model object or null
	 *
	 * @since   1.0.4
	 */
	public function getModel($name = null)
	{
		if ($name === null) {
			$name = $this->_defaultModel;
		}

		$key = strtolower($name);
		
		// Check if model exists before accessing array
		if (isset($this->_models[$key])) {
			return $this->_models[$key];
		}
		
		return null;
	}

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template
	 *
	 * @return  void
	 *
	 * @since   1.0.4
	 */
	public function display($tpl = null)
	{
		$app = Factory::getApplication();
		$layout = $app->getInput()->get('layout', 'default');
		$task = $app->getInput()->get('task', '');

		if ($layout === 'edit' || \in_array($task, ['customfields.add', 'customfields.edit'], true) || $app->getInput()->get('id')) {
			if ($layout !== 'edit') {
				$this->setLayout('edit');
			}
			$this->displayEdit($tpl);
		} else {
			$this->displayList($tpl);
		}
	}

	/**
	 * Display edit form
	 *
	 * @param   string  $tpl  Template
	 *
	 * @return  void
	 *
	 * @since  1.0.4
	 */
	protected function displayEdit($tpl = null)
	{
		// Create model directly (same approach as Controller) to avoid undefined array key error
		$className = 'Comdev\\Component\\Onecore\\Administrator\\Model\\Customfields\\ItemModel';
		$model = null;

		if (\class_exists($className)) {
			$component = Factory::getApplication()->bootComponent('com_onecore');
			$factory = $component->getMVCFactory();

			$config = ['ignore_request' => false];
			$model = new $className($config, $factory);

			if ($model instanceof \Joomla\Database\DatabaseAwareInterface) {
				$model->setDatabase(Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class));
			}
			if ($model instanceof \Joomla\CMS\Form\FormFactoryAwareInterface) {
				$model->setFormFactory(Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class));
			}
			if ($model instanceof \Joomla\Event\DispatcherAwareInterface) {
				$model->setDispatcher(Factory::getContainer()->get(\Joomla\Event\DispatcherInterface::class));
			}
		}

		if (!$model) {
			throw new \RuntimeException('Model Item not found');
		}

		\Joomla\CMS\Form\Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_onecore/forms');

		$this->form = $model->getForm();
		$this->item = $model->getItem();
		$this->state = $model->getState();

		// Check license and modify form if needed
		$isLicenseActive = LicenseHelper::isLicenseActive();
		if ($isLicenseActive) {
			// Set license value to plus for showon attribute
			$this->form->setValue('license', null, 'plus');
		} else {
			// Remove select option from type field if license is not active
			$typeField = $this->form->getField('type');
			if ($typeField) {
				// Try to remove select option using removeOption method if available
				if (method_exists($typeField, 'removeOption')) {
					$typeField->removeOption('select');
				} else {
					// Fallback: modify XML directly
					$element = $typeField->__get('element');
					if ($element instanceof \SimpleXMLElement) {
						$selectOptions = $element->xpath('.//option[@value="select"]');
						foreach ($selectOptions as $option) {
							unset($option[0]);
						}
					}
				}
			}
			
			// Hide options field
			$optionsField = $this->form->getField('options');
			if ($optionsField) {
				$optionsField->hidden = true;
			}
			
			// If current field type is select, change it to input
			if (isset($this->item->type) && $this->item->type === 'select') {
				$this->form->setValue('type', null, 'input');
			}
		}

		$this->addToolbarEdit();
		parent::display($tpl);
	}

	/**
	 * Display list
	 *
	 * @param   string  $tpl  Template
	 *
	 * @return  void
	 *
	 * @since  1.0.4
	 */
	protected function displayList($tpl = null)
	{
		$model = $this->getModel('Customfields');

		$this->items = $model ? ($model->getItems() ?: []) : [];
		$this->pagination = $model ? $model->getPagination() : null;
		$this->state = $model ? $model->getState() : new \Joomla\Registry\Registry();
		$this->filterForm = $model ? $model->getFilterForm() : null;
		$this->activeFilters = $model ? $model->getActiveFilters() : [];

		if (!$this->filterForm) {
			$formFactory = Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class);
			$this->filterForm = $formFactory->createForm('filter_customfields', ['control' => '']);
			$xml = new \SimpleXMLElement('<form><fields name="filter"></fields><fields name="list"></fields></form>');
			$this->filterForm->load($xml);
		}

		$this->addToolbarList();
		parent::display($tpl);
	}

	/**
	 * Toolbar for list
	 *
	 * @return void
	 *
	 * @since 1.0.4
	 */
	protected function addToolbarList()
	{
		OneCoreHelper::setToolbarTitle(\Joomla\CMS\Language\Text::_('COM_ONECORE_CUSTOMFIELDS'), 'tag');

		$canDo = \Joomla\CMS\Helper\ContentHelper::getActions('com_onecore');

		if ($canDo->get('core.create')) {
			ToolbarHelper::addNew('customfields.add');
		}

		if ($canDo->get('core.edit.state')) {
			ToolbarHelper::publish('customfields.publish', 'JTOOLBAR_PUBLISH', true);
			ToolbarHelper::unpublish('customfields.unpublish', 'JTOOLBAR_UNPUBLISH', true);
		}

		if ($canDo->get('core.delete')) {
			ToolbarHelper::deleteList('JGLOBAL_CONFIRM_DELETE', 'customfields.delete');
		}
	}

	/**
	 * Toolbar for edit
	 *
	 * @return void
	 *
	 * @since 1.0.4
	 */
	protected function addToolbarEdit()
	{
		$isNew = ($this->item->id ?? 0) == 0;

		OneCoreHelper::setToolbarTitle(
			$isNew ? \Joomla\CMS\Language\Text::_('COM_ONECORE_CUSTOMFIELD_NEW') : \Joomla\CMS\Language\Text::_('COM_ONECORE_CUSTOMFIELD_EDIT'),
			'tag'
		);

		ToolbarHelper::apply('customfields.apply');
		ToolbarHelper::save('customfields.save');

		if (!$isNew) {
			ToolbarHelper::save2new('customfields.save2new');
		}

		ToolbarHelper::cancel('customfields.cancel', $isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE');
	}
}

