<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\View\Customfieldgroups;

use Comdev\Component\Onecore\Administrator\Helper\OneCoreHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Customfieldgroups view class.
 *
 * @since  1.0.9
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * The Form object
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	protected $form;

	/**
	 * The active item
	 *
	 * @var  object
	 */
	protected $item;

	/**
	 * The model state
	 *
	 * @var  \Joomla\Registry\Registry
	 */
	protected $state;

	/**
	 * Items list
	 *
	 * @var  array
	 */
	protected $items;

	/**
	 * Pagination
	 *
	 * @var  \Joomla\CMS\Pagination\Pagination
	 */
	protected $pagination;

	/**
	 * Filter form
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	public $filterForm;

	/**
	 * Active filters
	 *
	 * @var  array
	 */
	public $activeFilters;

	/**
	 * Method to get the model object
	 * Override to avoid undefined array key error
	 *
	 * @param   string  $name  The name of the model (optional)
	 *
	 * @return  \Joomla\CMS\MVC\Model\BaseDatabaseModel|null  The model object or null
	 *
	 * @since   1.0.9
	 */
	public function getModel($name = null)
	{
		if ($name === null) {
			$name = $this->_defaultModel;
		}

		$key = strtolower($name);
		
		// Check if model exists before accessing array
		if (isset($this->_models[$key])) {
			return $this->_models[$key];
		}
		
		return null;
	}

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template
	 *
	 * @return  void
	 *
	 * @since   1.0.9
	 */
	public function display($tpl = null)
	{
		$app = Factory::getApplication();
		$layout = $app->getInput()->get('layout', 'default');
		$task = $app->getInput()->get('task', '');

		if ($layout === 'edit' || \in_array($task, ['customfieldgroups.add', 'customfieldgroups.edit'], true) || $app->getInput()->get('id')) {
			if ($layout !== 'edit') {
				$this->setLayout('edit');
			}
			$this->displayEdit($tpl);
		} else {
			$this->displayList($tpl);
		}
	}

	/**
	 * Display edit form
	 *
	 * @param   string  $tpl  Template
	 *
	 * @return  void
	 *
	 * @since  1.0.9
	 */
	protected function displayEdit($tpl = null)
	{
		// Create model directly (same approach as Controller) to avoid undefined array key error
		$className = 'Comdev\\Component\\Onecore\\Administrator\\Model\\Customfieldgroups\\ItemModel';
		$model = null;

		if (\class_exists($className)) {
			$component = Factory::getApplication()->bootComponent('com_onecore');
			$factory = $component->getMVCFactory();

			$config = ['ignore_request' => false];
			$model = new $className($config, $factory);

			if ($model instanceof \Joomla\Database\DatabaseAwareInterface) {
				$model->setDatabase(Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class));
			}
			if ($model instanceof \Joomla\CMS\Form\FormFactoryAwareInterface) {
				$model->setFormFactory(Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class));
			}
			if ($model instanceof \Joomla\Event\DispatcherAwareInterface) {
				$model->setDispatcher(Factory::getContainer()->get(\Joomla\Event\DispatcherInterface::class));
			}
		}

		if (!$model) {
			throw new \RuntimeException('Model Item not found');
		}

		\Joomla\CMS\Form\Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_onecore/forms');

		$this->form = $model->getForm();
		$this->item = $model->getItem();
		$this->state = $model->getState();

		$this->addToolbarEdit();

		parent::display($tpl);
	}

	/**
	 * Display list view
	 *
	 * @param   string  $tpl  Template
	 *
	 * @return  void
	 *
	 * @since  1.0.9
	 */
	protected function displayList($tpl = null)
	{
		/** @var \Comdev\Component\Onecore\Administrator\Model\CustomfieldgroupsModel $model */
		$model = $this->getModel('Customfieldgroups', 'Administrator');

		$this->items = $model->getItems();
		$this->pagination = $model->getPagination();
		$this->state = $model->getState();
		$this->filterForm = $model->getFilterForm();
		$this->activeFilters = $model->getActiveFilters();

		if (!$this->filterForm) {
			$formFactory = Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class);
			$this->filterForm = $formFactory->createForm('filter_customfieldgroups', ['control' => '']);
			$xml = new \SimpleXMLElement('<form><fields name="filter"></fields><fields name="list"></fields></form>');
			$this->filterForm->load($xml);
		}

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.0.9
	 */
	protected function addToolbar()
	{
		OneCoreHelper::setToolbarTitle(\Joomla\CMS\Language\Text::_('COM_ONECORE_CUSTOMFIELDGROUPS'), 'tag');

		ToolbarHelper::addNew('customfieldgroups.add');
		ToolbarHelper::editList('customfieldgroups.edit');
		ToolbarHelper::publish('customfieldgroups.publish', 'JTOOLBAR_PUBLISH', true);
		ToolbarHelper::unpublish('customfieldgroups.unpublish', 'JTOOLBAR_UNPUBLISH', true);
		ToolbarHelper::deleteList('JGLOBAL_CONFIRM_DELETE', 'customfieldgroups.delete');
	}

	/**
	 * Add the page title and toolbar for edit form.
	 *
	 * @return  void
	 *
	 * @since   1.0.9
	 */
	protected function addToolbarEdit()
	{
		$isNew = ($this->item->id == 0);

		OneCoreHelper::setToolbarTitle(
			\Joomla\CMS\Language\Text::_($isNew ? 'COM_ONECORE_CUSTOMFIELDGROUP_NEW' : 'COM_ONECORE_CUSTOMFIELDGROUP_EDIT'),
			'tag'
		);

		ToolbarHelper::apply('customfieldgroups.apply');
		ToolbarHelper::save('customfieldgroups.save');
		ToolbarHelper::save2new('customfieldgroups.save2new');
		ToolbarHelper::cancel('customfieldgroups.cancel', $isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE');
	}
}
