<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\View\Category;

use Comdev\Component\Onecore\Administrator\Helper\OneCoreHelper;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Category view class.
 *
 * @since  1.0.0
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * The Form object
	 *
	 * @var  \Joomla\CMS\Form\Form
	 */
	protected $form;

	/**
	 * The active item
	 *
	 * @var  object
	 */
	protected $item;

	/**
	 * The model state
	 *
	 * @var  \Joomla\Registry\Registry
	 */
	protected $state;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  The name of the template file to parse
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	public function display($tpl = null)
	{
		$model = $this->getModel('Category');
		
		if ($model) {
			$this->form = $model->getForm();
			$this->item = $model->getItem();
			$this->state = $model->getState();
			
			// Ensure form is loaded correctly
			if (!$this->form || !$this->form->getField('title')) {
				// Try to reload form with explicit path
				\Joomla\CMS\Form\Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_onecore/forms');
				$formFactory = \Joomla\CMS\Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class);
				$this->form = $formFactory->createForm('com_onecore.category', ['control' => 'jform']);
				if (!$this->form->loadFile('category', false)) {
					// Fallback: create minimal form
					$xml = new \SimpleXMLElement('<form><fieldset><field name="title" type="text" label="JGLOBAL_TITLE" required="true" /></fieldset></form>');
					$this->form->load($xml);
				}
			}
		} else {
			\Joomla\CMS\Form\Form::addFormPath(JPATH_ADMINISTRATOR . '/components/com_onecore/forms');
			$formFactory = \Joomla\CMS\Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class);
			$this->form = $formFactory->createForm('com_onecore.category', ['control' => 'jform']);
			if (!$this->form->loadFile('category', false)) {
				// Fallback: create minimal form
				$xml = new \SimpleXMLElement('<form><fieldset><field name="title" type="text" label="JGLOBAL_TITLE" required="true" /></fieldset></form>');
				$this->form->load($xml);
			}
			$this->item = (object) ['id' => 0];
			$this->state = new \Joomla\Registry\Registry();
		}

		// Set useCoreUI to true to ensure uitab is used consistently
		$this->useCoreUI = true;

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Method to get the form object
	 *
	 * @return  \Joomla\CMS\Form\Form  The form object
	 *
	 * @since   1.0.0
	 */
	public function getForm()
	{
		return $this->form;
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	protected function addToolbar()
	{
		$isNew = ($this->item->id ?? 0) == 0;

		OneCoreHelper::setToolbarTitle($isNew ? \Joomla\CMS\Language\Text::_('COM_ONECORE_CATEGORY_NEW') : \Joomla\CMS\Language\Text::_('COM_ONECORE_CATEGORY_EDIT'), 'folder');

		ToolbarHelper::apply('category.apply');
		ToolbarHelper::save('category.save');
		
		if (!$isNew) {
			ToolbarHelper::save2new('category.save2new');
		}
		
		ToolbarHelper::cancel('category.cancel', $isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE');
	}
}
