<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Service\HTML;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\Utilities\ArrayHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * HTML helper class for com_onecore
 *
 * @since  1.0.0
 */
class AdministratorService
{
	/**
	 * Method to get a featured state on a grid
	 *
	 * @param   integer       $value     The state value.
	 * @param   integer       $i         The row index
	 * @param   boolean|array $canChange Whether the state can be changed or not
	 * @param   string        $prefix    The task prefix (e.g., 'content' or 'events')
	 *
	 * @return  string  The HTML for the featured state
	 *
	 * @since   1.0.0
	 */
	public function featured($value, $i, $canChange = true, $prefix = 'content')
	{
		Factory::getApplication()->getDocument()->getWebAssetManager()->useScript('list-view');

		// Array of image, task, title, action
		$states = [
			0 => ['unfeatured', $prefix . '.featured', 'COM_ONECORE_UNFEATURED', 'JGLOBAL_ITEM_FEATURE'],
			1 => ['featured', $prefix . '.unfeatured', 'JFEATURED', 'JGLOBAL_ITEM_UNFEATURE'],
		];
		$state       = ArrayHelper::getValue($states, (int) $value, $states[1]);
		$icon        = $state[0] === 'featured' ? 'star featured' : 'circle';
		$tooltipText = Text::_($state[3]);

		if (!$canChange) {
			$tooltipText = Text::_($state[2]);
		}

		$html = '<button type="button" class="js-grid-item-action tbody-icon' . ($value == 1 ? ' active' : '') . '"'
			. ' aria-labelledby="cb' . $i . '-desc" data-item-id="cb' . $i . '" data-item-task="' .  $state[1] . '">'
			. '<span class="icon-' . $icon . '" aria-hidden="true"></span>'
			. '</button>'
			. '<div role="tooltip" id="cb' . $i . '-desc">' . $tooltipText . '</div>';

		return $html;
	}
}
