<?php

/**
 * @package     Comdev.Component
 * @subpackage  com_onecore
 *
 * @copyright   (C) 2026 Comdev. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Comdev\Component\Onecore\Administrator\Controller;

use Joomla\CMS\MVC\Controller\FormController;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Customfieldgroups controller class.
 *
 * @since  1.0.9
 */
class CustomfieldgroupsController extends FormController
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.0.9
	 */
	protected $text_prefix = 'COM_ONECORE_CUSTOMFIELDGROUPS';

	/**
	 * The URL view list variable.
	 *
	 * @var    string
	 * @since  1.0.9
	 */
	protected $view_list = 'customfieldgroups';

	/**
	 * Constructor.
	 *
	 * @param   array  $config   An optional associative array of configuration settings.
	 * @param   mixed  $factory  The factory.
	 * @param   mixed  $app      The Application for the dispatcher
	 * @param   mixed  $input    Input
	 *
	 * @since   1.0.9
	 */
	public function __construct($config = [], $factory = null, $app = null, $input = null)
	{
		parent::__construct($config, $factory, $app, $input);

		// Register publish/unpublish tasks
		$this->registerTask('unpublish', 'publish');
	}

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  \Joomla\CMS\MVC\Model\BaseDatabaseModel  The model.
	 *
	 * @since   1.0.9
	 */
	public function getModel($name = '', $prefix = '', $config = ['ignore_request' => true])
	{
		$input = $this->app->getInput();
		$task = $input->get('task', '');
		$view = $input->get('view', '');
		$layout = $input->get('layout', '');
		$id = $input->get('id', 0);

		$isEditOperation = false;
		if (
			$task === 'customfieldgroups.add'
			|| $task === 'customfieldgroups.edit'
			|| $task === 'customfieldgroups.save'
			|| $task === 'customfieldgroups.apply'
			|| $task === 'customfieldgroups.save2new'
			|| $task === 'customfieldgroups.save2copy'
			|| $layout === 'edit'
			|| ($view === 'customfieldgroups' && (int) $id > 0)
			|| \in_array($task, ['add', 'edit', 'save', 'apply', 'save2new', 'save2copy', 'reload'], true)
		) {
			$isEditOperation = true;
		}

		if (empty($name)) {
			$name = $isEditOperation ? 'Item' : 'Customfieldgroups';
		}

		if (($name === 'Customfieldgroups' || $name === 'customfieldgroups') && $isEditOperation) {
			$name = 'Item';
		}

		if ($name === 'Item' || $name === 'item') {
			$className = 'Comdev\\Component\\Onecore\\Administrator\\Model\\Customfieldgroups\\ItemModel';

			if (\class_exists($className)) {
				$component = \Joomla\CMS\Factory::getApplication()->bootComponent('com_onecore');
				$factory = $component->getMVCFactory();

				$config['ignore_request'] = false;

				$model = new $className($config, $factory);

				if ($model instanceof \Joomla\Database\DatabaseAwareInterface) {
					$model->setDatabase(\Joomla\CMS\Factory::getContainer()->get(\Joomla\Database\DatabaseInterface::class));
				}
				if ($model instanceof \Joomla\CMS\Form\FormFactoryAwareInterface) {
					$model->setFormFactory(\Joomla\CMS\Factory::getContainer()->get(\Joomla\CMS\Form\FormFactoryInterface::class));
				}
				if ($model instanceof \Joomla\Event\DispatcherAwareInterface) {
					$model->setDispatcher(\Joomla\CMS\Factory::getContainer()->get(\Joomla\Event\DispatcherInterface::class));
				}

				return $model;
			}
		}

		return parent::getModel($name, $prefix, $config);
	}

	/**
	 * Method to publish a list of custom field groups.
	 *
	 * @return  void
	 *
	 * @since  1.0.9
	 */
	public function publish()
	{
		$this->checkToken();

		$cid = (array) $this->input->get('cid', [], 'int');
		$cid = array_filter($cid);

		$data = ['publish' => 1, 'unpublish' => 0];
		$task = $this->getTask();
		$value = \Joomla\Utilities\ArrayHelper::getValue($data, $task, 0, 'int');

		if (empty($cid)) {
			\Joomla\CMS\Factory::getApplication()->enqueueMessage(
				\Joomla\CMS\Language\Text::_('JGLOBAL_NO_ITEM_SELECTED'),
				'warning'
			);
		} else {
			$model = $this->getModel('Customfieldgroups', 'Administrator', ['ignore_request' => false]);
			try {
				$model->publish($cid, $value);
			} catch (\Exception $e) {
				$this->setMessage($e->getMessage(), 'error');
			}
		}

		$this->setRedirect(
			\Joomla\CMS\Router\Route::_(
				'index.php?option=' . $this->option . '&view=' . $this->view_list,
				false
			)
		);
	}

	/**
	 * Delete selected custom field groups.
	 *
	 * @return  void
	 *
	 * @since  1.0.9
	 */
	public function delete()
	{
		$this->checkToken();

		$cid = (array) $this->input->get('cid', [], 'int');
		$cid = array_filter($cid);

		if (empty($cid)) {
			\Joomla\CMS\Factory::getApplication()->enqueueMessage(
				\Joomla\CMS\Language\Text::_('JGLOBAL_NO_ITEM_SELECTED'),
				'warning'
			);
		} else {
			$model = $this->getModel('Customfieldgroups', 'Administrator', ['ignore_request' => false]);
			try {
				if (!$model->delete($cid)) {
					$err = $model->getError();
					$this->setMessage($err ?: \Joomla\CMS\Language\Text::_('JLIB_APPLICATION_ERROR_DELETE_FAILED'), 'error');
				}
			} catch (\Exception $e) {
				$this->setMessage($e->getMessage(), 'error');
			}
		}

		$this->setRedirect(
			\Joomla\CMS\Router\Route::_(
				'index.php?option=' . $this->option . '&view=' . $this->view_list,
				false
			)
		);
	}
}
